#!/usr/bin/env python

import sys
import qt

import SetPath
import GraphView
import ImageView
import ExtendedImageView
from TacoServer import *
from  Numeric import *
import string
from Binding import Timer


OPC_CLEAR      =1  
OPC_PUT_IMAGE  =2
OPC_PUT_GRAPH  =3
OPC_DELETE     =4

        

class ViewWindow(qt.QMainWindow):
    def __init__(self,parent,view_class,name="",view_pars={}):
        qt.QMainWindow.__init__(self,None,name,qt.Qt.WDestructiveClose)
        self.name=name
        self.parent=parent
        self.Data=None
        self.View =view_class(self,view_pars)
        self.setCaption(name)
        self.View.Show()
        self.resize(600,400)
        self.show ()
        self.parent.windows.append (self)

    def SetSource(self,data):
        if hasattr(self,"Data") and self.Data is not None: self.Data.Destroy()        
        self.Data=data
        self.View.SetSource(data)
        

    def closeEvent(self,ce):
        ce.accept()
        if hasattr(self,"View") and self.View is not None: self.View.Destroy()        
        if hasattr(self,"Data") and self.Data is not None: self.Data.Destroy()        
        self.View=None
        self.Data=None
        self.parent.windows.remove (self)
        

    def resizeEvent(self,e):
        try:
            self.View.resize(self.width(), self.height())
        except:
            pass



class ViewServer(TacoServer):
    BASE=0
    SendArray=BASE+1
    SendCmd=BASE+2
    SetArray=BASE+3
    PutImage=BASE+4
    my_cmd_list = {
                    SendArray:      [D_VAR_FLOATARR, D_VOID_TYPE , 'send_array','SendArray'],
                    SendCmd:        [D_VAR_STRINGARR, D_VOID_TYPE , 'send_cmd','SendCmd'],
                    SetArray:       [D_VAR_FLOATARR, D_VOID_TYPE , 'set_array','SetArray'],
                    PutImage:       [D_VAR_FLOATARR, D_VOID_TYPE , 'put_image','PutImage'], 
                  }
    
    def __init__(self,workspace=None,name="ViewServer"):
        self.workspace=workspace
        TacoServer.__init__ (self, name, command_list=self.my_cmd_list)
        self.timer=Timer(None,self.cmd_exec)
        if self.workspace is None:
            self.windows=[]
        
    def send_array (self, par):
        self.array=array(par)

    def send_cmd (self, par):
        global mw,app
        self.cmd={}
        
        if len(par):
            for i in range (int(par[0])):
                self.cmd[par[i*2+1]]=par[i*2+2]
        self.timer.Start(interval=0,single_shot=1)
        app.wakeUpGuiThread()

 

    def cmd_exec(self):
        command=self.cmd
        array=self.array
        opc=int(command["opc"])
        window=self.get_window(command["name"])
        if opc==OPC_CLEAR:
            if window is None: return
            window.SetSource(None)

        elif opc==OPC_DELETE:
            if window is None: return
            window.close()

        elif opc==OPC_PUT_GRAPH:            
            if window is None:
                window=ViewWindow (self,GraphView.GraphView,command["name"],{"AddLockPosition":1,"AddOnLine":1,"AddRefresh":1,"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,})
            window.SetSource(GraphView.Graph(array))
            window.show()

        elif  opc==OPC_PUT_IMAGE:            
            array=reshape(array,(int(command["sizey"]),int(command["sizex"])))
            if window is None:            
                window=ViewWindow (self,ExtendedImageView.ExtendedImageView,command["name"],{"AddSelection":0})
            window.SetSource(ImageView.Image(array))

    def get_window(self,name):        
        if self.workspace is None: workspace=self
        else:workspace=self.workspace
        for window in workspace.windows:
            if window.name==name:
                return window
        return None


if __name__ == "__main__":
    app =qt.QApplication(sys.argv)

    #mw = ApplicationWindow()
    #mw.setCaption('ViewServer')
    #app.setMainWidget (mw)    
    #mw.show()
    #srv=ViewServer(workspace=mw.mdi,name="ViewServer")

    srv=ViewServer(workspace=None,name="ViewServer")
    dev=(srv,)
    server_startup(dev,nodb=1,pn=5000011)

    app.exec_loop()




