from qt import *

class ToolBar(QWidget):
	def __init__(self, parent=None, name=None, fl=0):
		QWidget.__init__(self, parent, name, fl)
		self.setSizePolicy(QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed))

		layout= QHBoxLayout(self)
		layout.setAutoAdd(1)

		self.toolTip= QToolTip(self)
		self.separator= []

	def addSpace(self, space=5):
		self.separator.append([len(self.children())-1+len(self.separator), space])

	def show(self):
		for sep in self.separator:
			self.layout().insertSpacing(sep[0], sep[1])
		QWidget.show(self)

class ToolSeparator(QFrame):
	def __init__(self, parent, width=15):
		QFrame.__init__(self, parent)
		self.setFrameStyle(QFrame.VLine|QFrame.Raised)
		self.setLineWidth(1)
		self.setMidLineWidth(3)
		self.setFixedWidth(width)

class ToolLabel(QLabel):
       def __init__(self, parent, text, size=6):
               QLabel.__init__(self, text, parent)
               self.setSizePolicy(QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed))
               font= self.font()
               font.setPointSize(size)
               self.setFont(font)

class ToolTextButton(QPushButton):
	def __init__(self, parent, text, callback=None, size=8):
		QPushButton.__init__(self, parent)
		self.setSizePolicy(QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Fixed))
		font= self.font()
		font.setPointSize(size)
		self.setFont(font)
		self.setText(text)

		if callback is not None:
			self.connect(self, SIGNAL("clicked()"), callback)

class ToolButton(QToolButton):
	def __init__(self, parent, pixmap=None, text=None, callback=None):
		QToolButton.__init__(self, parent)
		if pixmap is not None:
			self.setIconSet(QIconSet(QPixmap(pixmap)))
		if text is not None:
			self.setText(text)
			if hasattr(parent, "toolTip"):
				parent.toolTip.add(self, text)
			else:
				self.toolTip= QToolTip(self)
				self.toolTip.add(self, text)

		if callback is not None:
			self.connect(self, SIGNAL("clicked()"), callback)

class ToolToggleButton(ToolButton):
	def __init__(self, parent, pixmap=None, text=None, callback=None):
		ToolButton.__init__(self, parent, pixmap, text)
		self.setToggleButton(1)
		if callback is not None:
			self.callback= callback
			self.connect(self, SIGNAL("stateChanged(int)"), callback)

	def setStateSilently(self, state):
		if self.callback is not None:
			self.disconnect(self, SIGNAL("stateChanged(int)"), self.callback)
			ToolButton.setState(self, state)
			self.connect(self, SIGNAL("stateChanged(int)"), self.callback)
		else:
			ToolButton.setState(self, state)
		

if __name__=='__main__':
	import sys
	import resources
	a= QApplication(sys.argv)

	def clicked(*args):
		print "clicked", args
	w= QWidget()
	l= QVBoxLayout(w)

	tb= ToolBar(w)
	b= ToolToggleButton(tb, resources.zoom, "Zoom", clicked)
	b= ToolSeparator(tb)
	b= ToolButton(tb, resources.zoomplus, "Zoom +")
	tb.addSpace()
	b= ToolButton(tb, resources.zoomminus, "Zoom -")
	b.setEnabled(0)

	l.addWidget(tb)

	a.setMainWidget(w)
	w.show()
	a.exec_loop()
