
from qt import *
from SpecFileData import *
from SpecFileSelector import SpecFileSelector
from SpecFileSelection import McaSelection

class SpecFileSource:
	def __init__(self, eh=None):
		# --- event handler
		self.eh= eh
		if self.eh is not None:
			self.addPlotEvent= self.eh.create("addDataSelection")
			self.delPlotEvent= self.eh.create("delDataPage")
			self.eh.register("delDataSelection", self.delDataSelection)

		# --- source data
		self.source	= SpecFileData()

		# --- selector widget
		self.selector	= None

		# --- selection lists
		self.tempData= []
		self.selectedData= {}
			# { "filename": [ "mcakey" ] }

	#
	# handle its selector widget
	#
	def createSelector(self, parent=None):
		self.selector= SpecFileSelector(parent)
		self.selector.setData(self.source)
		QObject.connect(self.selector, PYSIGNAL("tempSelection"), self.tempSelection)
		QObject.connect(self.selector, PYSIGNAL("newSelection"), self.addMcaKeys)
		QObject.connect(self.selector, PYSIGNAL("delSelection"), self.delMcaKeys)
		return self.selector

	def getSelector(self):
		return self.selector

	def hasSelector(self):
		return (self.selector is not None)

	def hideSelector(self):
		if self.selector is not None and self.selector.isVisible():
			self.selector.hide()

	def showSelector(self):
		if self.selector is not None and self.selector.isHidden():
			self.selector.show()
			self.selector.refresh()

	def refreshSelector(self):
		if self.selector is not None:
			self.selector.refresh()

	def updateSelector(self):
		if self.selector is not None and self.selector.isVisible():
			self.selector.setSelection(self.selectedData)

	def closeSelector(self):
		if self.selector is not None:
			self.selector.close(1)
			self.selector= None

	#
	# data source
	#
	def getData(self):
		return self.source

	def setSource(self, filename):
		self.source.SetSource(filename)
		self.refreshSelector()

	#
	# selection (callback from widget or other)
	#
	def tempSelection(self, mcakeys):
		print "tempSelection", mcakeys

	def addMcaKeys(self, sourcename, mcakeys):
		if sourcename != self.source.SourceName:
			self.source.SetSource(sourcename)
		if sourcename not in self.selectedData.keys():
			self.selectedData[sourcename]= []

		# --- look for mca to add in the current selection
		add= [ key for key in mcakeys if key not in self.selectedData[sourcename] ]

		# --- load the source and generate DataSelection objects
		newSelections= []
		for key in add:
			# --- first load the source
			self.source.LoadSource(key_list=[key], append=1)
			# --- create DataSelection object
			sel= McaSelection(self.source, sourcename, key)
			newSelections.append(sel)
			self.selectedData[sourcename].append(key)

		if len(newSelections):
			# --- send event to add DataSelection in plotList
			if self.eh is not None:
				self.eh.event(self.addPlotEvent, newSelections)
			self.updateSelector()

	def delMcaKeys(self, sourcename, mcakeys):
		if not self.selectedData.has_key(sourcename): return
		delkeys= [ key for key in mcakeys if key in self.selectedData[sourcename] ]
		if len(delkeys):
			dellist= [{"SourceType":SOURCE_TYPE, "SourceName":sourcename, "Key":key} for key in delkeys]

			# --- send event to remove DataSelection in graph, tables, ...
			if self.eh is not None:
				self.eh.event(self.delPlotEvent, dellist)

			# --- remove selection keys and update selector
			#TODO: wait the answer from graph
			for key in delkeys:
				self.selectedData[sourcename].remove(key)
			self.updateSelector()

	def sendError(self, message):
		print "SpecFileSourceError:", message

	#
	# delete DataSelection objects
	#
	def delDataSelection(self, selection):
		nb= 0
		for sel in selection:
			info= sel.GetInfo()
			type= info["SourceType"]
			if type==SOURCE_TYPE:
				source= info["SourceName"]
				key= info["Key"]
				if self.selectedData.has_key(source):
					if key in self.selectedData[source]:
						self.selectedData[source].remove(key)
						nb += 1
		if nb: self.updateSelector()

def test():
	import sys

	if not len(sys.argv)>1:
		print "USAGE: %s <specfile>"%sys.argv[0]
		sys.exit(0)

	a = QApplication(sys.argv)
	s = SpecFileSource()
	w = s.createSelector()
	a.setMainWidget(w)
	s.setSource(sys.argv[1])
	s.showSelector()

	a.exec_loop()

if __name__=="__main__":
	test()
