from SpecFileData import SOURCE_TYPE
from DataSelection import OrthoLineSelection
import os.path

class McaSelection(OrthoLineSelection):
	#def __init__(self, source=None, source_name=None, mca_key=None, synchronized=1):
	#	keydict= { "SourceType": SOURCE_TYPE, "SourceName": source_name, "Key": mca_key }
	#	OrthoLineSelection.__init__(self, source=source, page=keydict, synchronized=synchronized)
	def __init__(self, source=None, key_list=None, synchronized=1):
		OrthoLineSelection.__init__(self, source=source, page=key_list, synchronized=synchronized)

	def GetOutput(self):
		ret= OrthoLineSelection.GetOutput(self)

		source= self.GetSource()
		info= source.GetPageInfo(self.IndexList[0])
		if info is not None and info.has_key("Labels") and info["Labels"] is not None:
			norm= {}
			cnames= info["AllLabels"]
			cvalues= info["Labels"]
			for name,value in zip(info["AllLabels"],info["Labels"]):
				norm[name]= value
			ret["norm"]= norm
		return ret

	def GetInfo(self):
		""" Return the dictionnary that index the page selected
		"""
		info= {}
		info["index_list"]= self.IndexList
		info["Legend"]= "%s:%s"%(os.path.basename(self.IndexList[0]["SourceName"]), self.IndexList[0]["Key"])
		return info

	def GetType(self):
		return SOURCE_TYPE
