import EventHandler
import sps
from qt import *
from resources import reload, fileclose

class SPS_StandardMca(QWidget):
	def __init__(self, parent=None, name="SPS_MCA_DATA", fl=0, title="MCA", size=8192):
		QWidget.__init__(self, parent, name, fl)

		layout= QGridLayout(self, 5, 2)

		self.title= QLabel(self)
		font= self.title.font()
		font.setBold(1)
		self.title.setFont(font)
		layout.addMultiCellWidget(self.title, 0, 0, 0, 1, Qt.AlignCenter)
		layout.addRowSpacing(0, 40)

		text= QLabel("Limit spectrum size to: (optionnal)", self)
		font= text.font()
		font.setItalic(1)
		text.setFont(font)
		layout.addMultiCellWidget(text, 1, 1, 0, 1, Qt.AlignLeft)

		text=QLabel("First Channel:", self)
		layout.addWidget(text, 2, 0, Qt.AlignRight)
		text=QLabel("Last Channel:", self)
		layout.addWidget(text, 3, 0, Qt.AlignRight)

		self.firstSpin= QSpinBox(self)
		self.lastSpin= QSpinBox(self)
		layout.addWidget(self.firstSpin, 2, 1, Qt.AlignLeft)
		layout.addWidget(self.lastSpin, 3, 1, Qt.AlignLeft)

		self.firstSpin.setMinValue(0)
		self.lastSpin.setMinValue(0)

		self.setSize(size)
		self.setTitle(title)

	def setSize(self, size):
		self.size= size
		self.firstSpin.setMaxValue(size)
		self.lastSpin.setMaxValue(size)
		self.lastSpin.setValue(size)

	def setTitle(self, title):
		self.title.setText("Standard %s shared array"%title)

	def getSelection(self):
		first= self.firstSpin.value()
		last= self.lastSpin.value()
		keys= {"plot":"cols", "x":0, "y":1}
		if first!=0 or last!=self.size:
			keys["range"]= (first, last)
		return [keys]

class SPS_StandardArray(QWidget):
	def __init__(self, parent=None, name="SPS_StandardArray", fl=0, rows=0, cols=0):
		QWidget.__init__(self, parent, name, fl)
		layout= QGridLayout(self, 4, 2)

		plab= QLabel("Plot", self)
		xlab= QLabel("X :", self)
		ylab= QLabel("Y :", self)

		layout.addWidget(plab, 0, 0, Qt.AlignRight)
		layout.addWidget(xlab, 1, 0, Qt.AlignRight)
		layout.addWidget(ylab, 2, 0, Qt.AlignRight|Qt.AlignTop)

		self.plotCombo= QComboBox(self)
		self.plotCombo.setEditable(0)
		self.plotCombo.insertItem("Rows")
		self.plotCombo.insertItem("Columns")

		self.xCombo= QComboBox(self)
		self.xCombo.setEditable(0)

		self.yList= QListBox(self)
		self.yList.setSelectionMode(QListBox.Multi)

		layout.addWidget(self.plotCombo, 0, 1)
		layout.addWidget(self.xCombo, 1, 1)
		layout.addWidget(self.yList, 2, 1)

		self.connect(self.plotCombo, SIGNAL("activated(int)"), self.__plotChanged)

		self.setSize(rows, cols)

	def setSize(self, rows, cols):
		self.rows= rows
		self.cols= cols

		idx= self.cols<=self.rows
		self.plotCombo.setCurrentItem(idx)
		self.__plotChanged(idx)

	def __plotChanged(self, index):
		if index==1:
			txt= "Column"
			val= self.cols
		else:
			txt= "Row"
			val= self.rows
		self.xCombo.clear()
		self.xCombo.insertItem("Array Index")
		self.yList.clear()
		for x in range(val):
			self.xCombo.insertItem("%s %d"%(txt,x))
			self.yList.insertItem("%s %d"%(txt,x))
		if val==2:
			self.xCombo.setCurrentItem(1)
			self.__xChanged(1)

	def __xChanged(self, index):
		pass

	def getSelection(self):
		selection= []

		idx= self.plotCombo.currentItem()
		if idx==1: plot= "cols"
		else: plot= "rows"

		idx= self.xCombo.currentItem()
		if idx==0: x= None
		else: x= idx-1

		ylist= [ idx for idx in range(self.yList.count()) if self.yList.isSelected(idx) ]
		for y in ylist:
			selection.append({"plot":plot, "x":x, "y":y})
		return selection

class SPSSelector(QWidget):
	HiddenArrays= ["SCAN_D", "SCAN_D_ENV", "MCA_DATA_PARAM"]
	ClassArrays= {"mca": SPS_StandardMca, "array": SPS_StandardArray, "empty": QWidget}

	def __init__(self, parent=None, name="SPSSelector", fl=0):
		QWidget.__init__(self, parent, name, fl)

		self.data= None
		self.currentArray= None

		self.eh= EventHandler.EventHandler()
		self.addEvent= self.eh.create("addSelection")
		self.delEvent= self.eh.create("delSelection")

		mainLayout= QVBoxLayout(self)

		# --- spec name selection
		specWidget= QWidget(self)
		self.specCombo= QComboBox(specWidget)
		self.specCombo.setEditable(0)
		self.reload= QIconSet(QPixmap(reload))
		refreshButton= QToolButton(specWidget)
		refreshButton.setIconSet(self.reload)
		refreshButton.setSizePolicy(QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Minimum))
		self.closeIcon= QIconSet(QPixmap(fileclose))
		closeButton= QToolButton(specWidget)
		closeButton.setIconSet(self.closeIcon)
		closeButton.setSizePolicy(QSizePolicy(QSizePolicy.Fixed, QSizePolicy.Minimum))
		specLayout= QHBoxLayout(specWidget)
		specLayout.addWidget(self.specCombo)
		specLayout.addWidget(refreshButton)
		specLayout.addWidget(closeButton)

		self.connect(refreshButton, SIGNAL("clicked()"), self.__reloadSpec)
		self.connect(closeButton, SIGNAL("clicked()"), self.__closeSpec)
		self.connect(self.specCombo, SIGNAL("activated(const QString &)"), self.__selectSpec)

		# --- splitter
		self.splitter= QSplitter(self)
		self.splitter.setOrientation(QSplitter.Vertical)

		# --- shm array list
		self.arrayList= QListView(self.splitter, "ShmArrayList")
		self.arrayList.addColumn("X")
		self.arrayList.addColumn("Array Name")
		self.arrayList.addColumn("Rows")
		self.arrayList.addColumn("Cols")
		self.arrayList.setSorting(-1)
		self.arrayList.header().setClickEnabled(0,-1)
		self.arrayList.setAllColumnsShowFocus(1)
		self.arrayList.setSelectionMode(QListView.Single)
		
		self.connect(self.arrayList, SIGNAL("selectionChanged()"), self.__arraySelection)

		# --- array parameter
		self.paramIndex= {}
		self.paramWidget= QWidgetStack(self.splitter)
		for type in self.ClassArrays.keys():
			widclass= self.ClassArrays[type]
			wid= widclass(self.paramWidget)
			self.paramWidget.addWidget(wid)
			self.paramIndex[type]= self.paramWidget.id(wid)

		# --- command buttons
		butWidget= QWidget(self)
		butWidget.setSizePolicy(QSizePolicy(QSizePolicy.Minimum, QSizePolicy.Minimum))
		removeButton= QPushButton("Remove", butWidget)
		selectButton= QPushButton("Show", butWidget)

		butLayout= QHBoxLayout(butWidget)
		butLayout.addWidget(removeButton)
		butLayout.addWidget(selectButton)

		self.connect(selectButton, SIGNAL("clicked()"), self.__selectClicked)
		self.connect(removeButton, SIGNAL("clicked()"), self.__removeClicked)

		# --- main layout
		mainLayout.addWidget(specWidget)
		mainLayout.addWidget(self.splitter)
		mainLayout.addWidget(butWidget)

	def setData(self, data):
		self.data= data
		self.__reloadSpec()

	def setSelected(self, sellist):
		self.selection= sellist
		self.markArraySelected()

	def markArraySelected(self):
		markArrays= [ sel["Key"] for sel in self.selection if sel["SourceName"]==self.data.SourceName ]
		item= self.arrayList.firstChild()
		while item is not None:
			name= str(item.text(1))
			if name in markArrays:
				item.setText(0, "X")
			else:
				item.setText(0, "")
			item= item.nextSibling()
	
	def __closeSpec(self):
		name= self.data.SourceName
		todel= [ sel for sel in self.selection if sel["SourceName"]==self.data.SourceName ]
		if len(todel):
			ans= QMessageBox.information(self, "Remove Shared Arrays",
				"%d arrays are linked to spec session <%s>.\nRemove all these arrays ?"%(len(todel),name),
				QMessageBox.No, QMessageBox.Yes)
			if ans==QMessageBox.Yes:
				self.eh.event(self.delEvent, todel)

	def __reloadSpec(self):
		speclist= sps.getspeclist()
		if self.specCombo.count():
			selected= str(self.specCombo.currentText())
		else:
			selected= None
		self.specCombo.clear()
		if len(speclist):
			for spec in speclist:
					self.specCombo.insertItem(spec)
			self.selectSpec(selected)

	def selectSpec(self, specname=None):
		if specname is not None:
			for idx in range(self.specCombo.count()):
				if str(self.specCombo.text(idx))==specname:
					self.specCombo.setCurrentItem(idx)
					self.__selectSpec(specname)
					break

	def __selectSpec(self, specname):
		specname= str(specname)
		if self.data is not None:
			self.data.SetSource(specname)
			self.__refreshList()

	def __refreshList(self):
		self.arrayList.clear()
		if self.data is None or self.data.SourceName is None: return

		list= self.data.GetSourceInfo()["KeyList"]
		if len(list):
			list.sort()
			list.reverse()
			for name in list:
				if name not in self.HiddenArrays:
					info= self.data.GetSourceInfo(name)
					rows= info["rows"]
					cols= info["cols"]
					item= QListViewItem(self.arrayList, "", name, str(rows), str(cols))
					self.arrayList.insertItem(item)
			self.markArraySelected()
		else:
			self.__getParamWidget("empty")

	def __arraySelection(self):
		item= self.arrayList.selectedItem()
		self.currentArray= str(item.text(1))
		info= self.data.GetSourceInfo(self.currentArray)

		if self.currentArray=="MCA_DATA":
			wid= self.__getParamWidget("mca")
			wid.setTitle("MCA")
			wid.setSize(info["rows"])
		elif self.currentArray[0:8]=="XIA_PLOT":
			wid= self.__getParamWidget("mca")
			wid.setTitle("XIA")
			wid.setSize(info["rows"])
		else:
			wid= self.__getParamWidget("array")
			wid.setSize(info["rows"], info["cols"])

	def __getParamWidget(self, widtype):
		wid= self.paramWidget.visibleWidget()
		if self.paramWidget.id(wid)!=self.paramIndex[widtype]:
			self.paramWidget.raiseWidget(self.paramIndex[widtype])
			wid= self.paramWidget.visibleWidget()
		return wid

	def __selectClicked(self):
		selkeys= self.__getSelectedKeys()
		if len(selkeys):
			self.eh.event(self.addEvent, selkeys)

	def __getSelectedKeys(self):
		selkeys= []
		parwid= self.paramWidget.visibleWidget()
		if self.currentArray is not None:
			source= self.data.SourceName
			for sel in parwid.getSelection():
				sel["SourceName"]= source
				sel["Key"]= self.currentArray
				selkeys.append(sel)
		return selkeys

	def __removeClicked(self):
		selkeys= self.__getSelectedKeys()
		if len(selkeys):
			self.eh.event(self.delEvent, selkeys)
