#!/usr/bin/env python
import sys
import PyDVT
#PyDVT.SetBinding("QwtBinding")
from PyMcaWindow import PyMcaWindow

def printHelp():
	help= """
PyMca - Command line arguments

-f (--specfile=) filename:mcano
	Open mca number <mcano> from specfile <filename>	
	Mca number is defined as scanno.order.mcano (example: 6.1.1 = first mca of scan no 6)
-a (--specarray=) specname:array[:plot:x:y]
	Open shared array named <array> from spec session <specname>
	For standard MCA arrays, X is read from column 0, Y from column 1 (=:cols:0:1)
	You can specify which columns/rows to plot for other arrays using :plot:x:y
	where plot is either <cols> or <rows>, x index of x row/col, y index of y row/col
-g (--graph)
	Open a new graph window. By default, one graph is opened on startup.
	Every data options (-f/-a) following a -g will be plotted on the new graph. 
	Example: pymca -f mydata.dat:1.1.1 -g -a optics:MCA_DATA
		will display mca 1.1.1 of mydata.dat on graph 0, and shared array
		MCA_DATA read from optics session on graph 1
-s (--size=) <width>x<height>
	Setup window size (default=600x400)
-h (--help)
	This help.
"""
	print help
	sys.exit(0)
		
def parseArguments():
	import getopt

	try:
		opts, args= getopt.getopt(sys.argv[1:], "hgf:a:s:",
				["help","graph","specfile=","specarray=","size="])
	except getopt.error, msg:
		print "%s: ERROR while parsing command line arguments"
		print "\t%s"%msg
		return (None, None)

	graph= 0
	source= [{}]
	settings= {}

	for opt,arg in opts:
		if opt in ("-h", "--help"):
			printHelp()
		if opt in ("-g", "--graph"):
			if graph or len(source[0].keys()):
				graph += 1
				source.append({})
		if opt in ("-f", "--specfile"):
			file= string.split(arg, ":")
			if len(file)==2:
				sel= {"SourceName":file[0], "Key":file[1]}
				if not source[graph].has_key("SpecFile"):
					source[graph]["SpecFile"]= []
				source[graph]["SpecFile"].append(sel)
		if opt in ("-a", "--specarray"):
			array= string.split(arg, ":")
			if len(array)>=2:
				sel= {"SourceName":array[0], "Key":array[1]}
				if len(array)==5:
					sel.update({"plot":array[2], "x":int(array[3]), "y":int(array[4])})
				if not source[graph].has_key("SPS"):
					source[graph]["SPS"]= []
				source[graph]["SPS"].append(sel)
		if opt in ("-s", "--size"):
			size= string.split(arg, "x")
			if len(size)==2:
				try:
					(x,y)= (int(size[0]), int(size[1]))
					settings["size"]= (x,y)
				except:
					print "WARNING: Cannot parse size option (%s)"%size
					pass

	return (settings, source)


if __name__ == "__main__":

	(settings, source)= parseArguments()

	import qt
	import mdi

	app= mdi.MDIApp(sys.argv)

	# --- waiting widget
	wa= qt.QMessageBox("PyMca", "PyMca loading ...", qt.QMessageBox.NoIcon,
				qt.QMessageBox.NoButton, qt.QMessageBox.NoButton, 
				qt.QMessageBox.NoButton, None, None)
	wa.show()

	# --- create main window
	mw= PyMcaWindow()
	mw.setCaption('PyMca')
	mw.show()

	# --- setting options
	if settings.has_key("size"):
		mw.resize(settings["size"][0], settings["size"][1])
		mw.onMdiTile()

	# --- open graph / sources
	for idx in range(len(source)):
		if idx>0: mw.onNewGraph()
		for type, selkeys in source[idx].items():
			mw.selectSource(type, selkeys)
		
	app.setMainWidget (mw)
	wa.close()
	app.exec_loop()
