
#from PyDVT.FitFilter import FitFilter
from FitFilter import FitFilter

from Filter import Filter
from Specfit import Specfit
from SpecfitFunctions import SpecfitFunctions

class PeakSearchFilter(Filter):
	def __init__(self,source,synchronized=1):
		Filter.__init__(self,source,synchronized,buffer_input=1)

		self.fit= Specfit()
		self.fitfun= SpecfitFunctions()

		self.Parameters= { "FwhmPoints": self.fitfun.config["FwhmPoints"],
				   "Sensitivity": self.fitfun.config["Sensitivity"],
				   "Yscaling": self.fitfun.config["Yscaling"],
				   "YscalingAuto": 1
				 }

	def GetOutput(self):
        	input=self.GetInput()
        	if "data" not in input.keys(): return {}
        	ydata=input ["data"]
        	if "xdata" in input.keys(): xdata=input["xdata"]
		else: xdata=Numeric.arrayrange(ydata.shape[0])

		if self.Parameters["YscalingAuto"]:
			self.fit.setdata(x=xdata,y=ydata)
			yscaling= self.fit.guess_yscaling()
			print "guess_yscaling", yscaling
		else:
			yscaling= self.Parameters["Yscaling"]

		peaks= self.fitfun.seek(ydata, xdata, yscaling=yscaling, 
				fwhm= self.Parameters["FwhmPoints"], 
				sensitivity= self.Parameters["Sensitivity"])
		peaksdict= {}
		for idx in range(len(peaks)):
			peaksdict["pk%d"%idx]= (peaks[idx], None)
			
		return { "yscaling": yscaling, "peaks": peaksdict }

	def SetParameters(self, parameters):
		self.Parameters.update(parameters)

	def GetParameters(self):
		return self.Parameters

	def GetType(self):
		return "Peak"


class McaFitFilter(FitFilter):

	DefaultParameters= {"Weight":0,"Theory":"Area Gaussians","Background":"Linear",
                  "Mode":"MCA","Sensitivity":3.25,"FwhmPoints":10,"Yscaling":1.0}

	def __init__(self, source, synchronized=1):
		FitFilter.__init__(self, source, synchronized)
		self.Parameters.update(self.DefaultParameters)

	def GetType(self):
		return "Fit"

	def Destroy(self, source=None):
		if self.Editor is not None:
			print "close", self.Editor
			self.Editor.close()
			self.Editor= None
		FitFilter.Destroy(self)
