from qt import *
from qttable import *
from GraphWindow import CalibDefaultType

class McaFilterData(QWidget):
	def __init__(self, parent=None, name="McaFilterData", fl=0):
		QWidget.__init__(self, parent, name, fl)

		mainLayout= QVBoxLayout(self)

		self.table= QTable(self)
		self.table.verticalHeader().hide()
		#self.table.setResizeEnabled(1,-1)
		self.table.setShowGrid(1)

		mainLayout.addWidget(self.table)

	def ConnectTo(self, graph):
		self.graph= graph
		self.Refresh()

	def Refresh(self):
		self.table.setNumRows(0)
		self.table.setNumCols(0)
		if self.graph is not None:
			self.SetData(self.graph.GetSource())

	def SetData(self, source=()):
		toshow= []
		nbrows= 0
		for filter in source:
			data= filter.GetOutput(xaxis=DefaultCalib)
			info= filter.GetSource().GetInfo()

			y= data["data"]
			n= len(y)
			if n>nbrows: nbrows=n

			type= info.get("SourceType", "-")
			name= info.get("SourceName", "-")

			toshow.append( (type, name, y) )
		if not len(toshow): return
		toshow.insert(0, ("Channels", "", range(nbrows)))

		self.table.setNumRows(nbrows+2)
		self.table.setNumCols(len(toshow))

		for idx in range(len(toshow)):
			self.table.setText(0, idx, str(toshow[idx][0]))
			self.table.setText(1, idx, str(toshow[idx][1]))
			data= toshow[idx][2]
			for row in range(len(data)):
				self.table.setText(2+row, idx, str(data[row]))
