from qt import *

from McaGraphView import *
from McaFitFilter import *
from ToolBar import *
from PyDVT.Binding import FitParametersDialog

import EventHandler
import mdi
import resources

import string

class GraphWindow(mdi.ChildWindow):
	def __init__(self, parent=None, name="Graph"):
		mdi.ChildWindow.__init__(self, parent, name, Qt.WDestructiveClose)

		self.name= name
		self.setCaption(self.name)

		self.toolbar= ToolBar(self)
		self.view= McaGraphView(self)
		self.__init_toolbar()
		self.status= McaGraphStatus(self.view)

		layout= QVBoxLayout(self)
		layout.addWidget(self.toolbar)
		layout.addWidget(self.view)

		self.view.eh.register("SettingChange", self.__settingRefresh)
		self.view.SetMode("Normal")
		self.resize(400,300)

	def __init_toolbar(self):
		#tb= ToolLabel(self.toolbar, "Mouse")
		self.normalButton= ToolToggleButton(self.toolbar, resources.normal, "Normal Mode", self.__toggleNormal)
		self.zoomButton= ToolToggleButton(self.toolbar, resources.zoom, "Zoom Mode", self.__toggleZoom)
		self.roiButton= ToolToggleButton(self.toolbar, resources.roi, "Roi Mode", self.__toggleRoi)
		self.peakButton= ToolToggleButton(self.toolbar, resources.peak, "Peak Mode", self.__togglePeak)

		tb= ToolSeparator(self.toolbar)
		#self.toolbar.addSpace()
		tb= ToolButton(self.toolbar, resources.zoomreset, "Reset Zoom", self.view.ResetZoom)
		#tb= ToolButton(self.toolbar, resources.zoomplus, "Zoom+")
		#tb= ToolButton(self.toolbar, resources.zoomminus, "Zoom-")

		tb= ToolSeparator(self.toolbar)
		tb= ToolButton(self.toolbar, resources.roireset, "Remove ROIs", self.view.DeleteRoi)

		tb= ToolSeparator(self.toolbar)
		tb= ToolButton(self.toolbar, resources.peakreset, "Remove Peaks", self.view.DeletePeaks)

		tb= ToolSeparator(self.toolbar)

		tb= ToolButton(self.toolbar, resources.fit, "Fit Active Spectrum", self.__fitClicked)
		tb= ToolButton(self.toolbar, resources.peaksearch, "Peak Search on Active Spectrum", self.__peakClicked)

	def __fitClicked(self):
		filter= self.view.GetActiveFilter()
		if filter is not None:
			self.fitWindow= FitParametersDialog(None, None)
			self.fitWindow.setCaption("FIT %s"%self.name)
			self.fitWindow.show()

			self.fitFilter= McaFitFilter(filter)
			self.fitFilter.ConnectParameterEditor(self.fitWindow)
			print self.fitFilter.Editor.GetParameters()
			
			self.view.AddDataSelection((self.fitFilter,))
		else:
			QMessageBox.information(self, "Fit", 
				"No spectrum selected.\nSelect one by clicking on graph and restart fit.")

	def __peakClicked(self):
		filter= self.view.GetActiveFilter()
		if filter is not None:
			peakFilter= PeakSearchFilter(filter)
			data= peakFilter.GetOutput()
			if data.has_key("peaks"):
				filter.SetPeaks(data["peaks"])
				filter.Refresh()
		else:
			QMessageBox.information(self, "Peak Search",
				"No spectrum selected.\nSelect one by clicking on graph and restart fit.")

	def __settingRefresh(self, setting, value):
		if setting=="Mode":
			self.normalButton.setStateSilently(value=="Normal" and QButton.On or QButton.Off)
			self.zoomButton.setStateSilently(value=="Zoom" and QButton.On or QButton.Off)
			self.roiButton.setStateSilently(value=="Roi" and QButton.On or QButton.Off)
			self.peakButton.setStateSilently(value=="Peak" and QButton.On or QButton.Off)

	def __toggleZoom(self, state):
		self.view.SetMode(state==QButton.On and "Zoom" or "Normal")

	def __toggleRoi(self, state):
		self.view.SetMode(state==QButton.On and "Roi" or "Normal")

	def __togglePeak(self, state):
		self.view.SetMode(state==QButton.On and "Peak" or "Normal")

	def __toggleNormal(self, state):
		if state==QButton.On: self.view.SetMode("Normal")
		else:	self.normalButton.setStateSilently(QButton.On)

	def closeEvent(self, e):
		self.emit(PYSIGNAL("GraphClosed"), (self,e))

	def destroy(self, e):
		self.view.eh.register("SettingChange", self.__settingRefresh)
		self.view.Destroy()
		mdi.ChildWindow.closeEvent(self, e)

class McaGraphStatus(QWidget):
	def __init__(self, parent, name="McaGraphStatus", fl=0):
		QWidget.__init__(self, parent, name, fl)
		self.setSizePolicy(QSizePolicy(QSizePolicy.Expanding, QSizePolicy.Fixed))
		ft= self.font()	
		ft.setPointSize(ft.pointSize()-2)
		self.setFont(ft)

		self.view= parent
		layout= QHBoxLayout(self)

		# --- Calibration ComboBox
		self.calibCombo= QComboBox(self)
		for idx in range(len(CalibTypes)):
			self.calibCombo.insertItem(CalibTypes[idx], idx)
		idx= CalibTypes.index(self.view.GetCalib())
		self.calibCombo.setCurrentItem(idx)
		self.connect(self.calibCombo, SIGNAL("activated(int)"), self.__calibChanged)
		layout.addWidget(self.calibCombo)

		# --- X value
		lb= QLabel("X:", self)
		ft= lb.font()
		ft.setBold(1)
		lb.setFont(ft)
		layout.addWidget(lb)

		self.currentX= QLabel(self)
		layout.addWidget(self.currentX)

		layout.addSpacing(10)

		# --- Y value
		lb= QLabel("Y:", self)
		ft= lb.font()
		ft.setBold(1)
		lb.setFont(ft)
		layout.addWidget(lb)

		self.currentY= QLabel(self)
		layout.addWidget(self.currentY)

		sp= QSpacerItem(1, 1, QSizePolicy.Expanding, QSizePolicy.Fixed)
		layout.addItem(sp)

		# --- Active Spectrum text
		lb= QLabel("Active:", self)
		ft= lb.font()
		ft.setBold(1)
		lb.setFont(ft)
		layout.addWidget(lb)
		
		self.activeFilter= QLabel(self)
		layout.addWidget(self.activeFilter)

		# --- Active Spectrum ComboBox
		#self.activeCombo= QComboBox(self)
		#layout.addWidget(self.activeCombo)
	
		# --- init	
		self.setCurrentPos()
		#self.setGraphFilters()
		self.setActiveFilter()

		#self.view.eh.register("SourceChange", self.setGraphFilters)
		self.view.eh.register("CursorPosition", self.setCurrentPos)
		self.view.eh.register("ActiveChange", self.setActiveFilter)

	def setCurrentPos(self, x=None, y=None):
		if x is None:
			self.currentX.setText("-.---")
		else:
			self.currentX.setText("%g"%x)
		if y is None:
			self.currentY.setText("-.---")
		else:
			if type(y)==type(()):
				y= list(y)
				y.sort()
				y= [ "%g"%yy for yy in y ]
				ytxt= string.join(y, ",")
			else:
				ytxt="%g"%y
			self.currentY.setText(ytxt)

	def setActiveFilter(self, filter=None):
		if filter is None: active= "none"
		else:	active= filter.GetLegend()
		self.activeFilter.setText(active)
		#if filter is None: 
		#	active= "none"
		#else:
		#	active= filter.GetLegend()
		#	if active not in self.filterNames: active= "none"
		#self.activeCombo.setCurrentItem(self.filterNames.index(active))
			
	def setGraphFilters(self, filters=None):
		active= self.activeCombo.currentText()
		self.filterNames= ["none"]
		if filters is not None:
			for filter in filters:
				self.filterNames.append(filter.GetLegend())
		self.activeCombo.clear()
		for idx in range(len(self.filterNames)):
			self.activeCombo.insertItem(self.filterNames[idx], idx)
		active= active in self.filterNames and active or "none"
		self.activeCombo.setCurrentItem(self.filterNames.index(active))

	def __calibChanged(self, idx):
		calib= CalibTypes[idx]
		self.view.SetCalib(calib)
