from qt import *

from McaGraphView import GraphStyle, GraphCursor, GraphMode

class GraphSetting(QWidget):
	def __init__(self, parent=None, name=None, graph=None):
		QWidget.__init__(self, parent, name, 0)
		self.name= name
		self.graph= graph
		self.refreshFlag= 0

		self.Combo= {}
		layout= QHBoxLayout(self)

		leftWidget= QWidget(self)
		leftLayout= QGridLayout(leftWidget, 4, 2)

		modeLb= QLabel("Mouse selection", leftWidget)
		leftLayout.addWidget(modeLb, 0, 0, Qt.AlignLeft)
		cursorLb= QLabel("Cursor Type", leftWidget)
		leftLayout.addWidget(cursorLb, 1, 0, Qt.AlignLeft)
		onlineLb= QLabel("Graph Refresh", leftWidget)
		leftLayout.addWidget(onlineLb, 2, 0, Qt.AlignLeft)
		lockLb= QLabel("Lock position", leftWidget)
		leftLayout.addWidget(lockLb, 3, 0, Qt.AlignLeft)

		modeCb= self.__getComboBox(leftWidget, GraphMode)
		leftLayout.addWidget(modeCb, 0, 1)
		self.connect(modeCb, SIGNAL("activated(int)"), self.__modeCb)
		cursorCb= self.__getComboBox(leftWidget, GraphCursor)
		leftLayout.addWidget(cursorCb, 1, 1)
		self.connect(cursorCb, SIGNAL("activated(int)"), self.__cursorCb)
		onlineCb= self.__getComboBox(leftWidget, ["Off", "On"])
		leftLayout.addWidget(onlineCb, 2, 1)
		self.connect(onlineCb, SIGNAL("activated(int)"), self.__onlineCb)
		lockCb= self.__getComboBox(leftWidget, ["No", "Yes"])
		leftLayout.addWidget(lockCb, 3, 1)
		self.connect(lockCb, SIGNAL("activated(int)"), self.__lockCb)

		self.Combo["Mode"]= modeCb
		self.Combo["Cursor"]= cursorCb
		self.Combo["OnLine"]= onlineCb
		self.Combo["Lock"]= lockCb

		rightWidget= QWidget(self)
		rightLayout= QGridLayout(rightWidget, 4, 2)

		styleLb= QLabel("Graph style", rightWidget)
		rightLayout.addWidget(styleLb, 0, 0, Qt.AlignLeft)
		xaxisLb= QLabel("X-axis scale", rightWidget)
		rightLayout.addWidget(xaxisLb, 1, 0, Qt.AlignLeft)
		yaxisLb= QLabel("Y-axis scale", rightWidget)
		rightLayout.addWidget(yaxisLb, 2, 0, Qt.AlignLeft)
		gridLb= QLabel("Axis gridlines", rightWidget)
		rightLayout.addWidget(gridLb, 3, 0, Qt.AlignLeft)

		styleCb= self.__getComboBox(rightWidget, GraphStyle)
		rightLayout.addWidget(styleCb, 0, 1)
		self.connect(styleCb, SIGNAL("activated(int)"), self.__styleCb)
		xaxisCb= self.__getComboBox(rightWidget, ["Linear", "Log"])
		rightLayout.addWidget(xaxisCb, 1, 1)
		self.connect(xaxisCb, SIGNAL("activated(int)"), self.__xaxisCb)
		yaxisCb= self.__getComboBox(rightWidget, ["Linear", "Log"])
		rightLayout.addWidget(yaxisCb, 2, 1)
		self.connect(yaxisCb, SIGNAL("activated(int)"), self.__yaxisCb)
		gridCb= self.__getComboBox(rightWidget, ["Hide", "Show"])
		rightLayout.addWidget(gridCb, 3, 1)
		self.connect(gridCb, SIGNAL("activated(int)"), self.__gridLb)

		self.Combo["Style"]= styleCb
		self.Combo["LogX"]= xaxisCb
		self.Combo["LogY"]= yaxisCb
		self.Combo["Gridlines"]= gridCb

		layout.addWidget(leftWidget)
		layout.addWidget(rightWidget)

	def setAutoRefresh(self, auto):
		if auto!=self.refreshFlag:
			self.refreshFlag= auto
			if auto:
				settings= self.graph.GetSettings()
				for (type,value) in settings.items():
					self.__settingChange(type, value)
				self.graph.eh.register("SettingChange", self.__settingChange)
			else:
				self.graph.eh.unregister("SettingChange", self.__settingChange)

	def __settingChange(self, type, value):
		if type=="Mode":
			self.Combo["Mode"].setCurrentItem(GraphMode.index(value))
		elif type=="Style":
			self.Combo["Style"].setCurrentItem(GraphStyle.index(value))
		elif type=="Cursor":
			self.Combo["Cursor"].setCurrentItem(GraphCursor.index(value))
		elif type in ["LogX", "LogY", "Gridlines", "Lock", "OnLine"]:
			self.Combo[type].setCurrentItem(value)

	def __modeCb(self, idx):
		mode= GraphMode[idx]
		self.graph.SetMode(mode)

	def __cursorCb(self, idx):
		type= GraphCursor[idx]
		self.graph.SetCursorType(type)

	def __onlineCb(self, idx):
		self.graph.SetOnLine(idx)

	def __lockCb(self, idx):
		self.graph.SetLock(idx)

	def __styleCb(self, idx):
		style= GraphStyle[idx]
		self.graph.SetStyle(style)

	def __xaxisCb(self, idx):
		self.graph.SetLogX(idx)

	def __yaxisCb(self, idx):
		self.graph.SetLogY(idx)

	def __gridLb(self, idx):
		self.graph.SetGridlines(idx)

        def __getComboBox(self, parent, data, selected=None):
                item= QComboBox(parent)
		item.insertStringList(self.__getStringList(data))
                if selected is not None:
                        item.setCurrentItem(data.index(selected))
                return item

        def __getStringList(self, plist):
                strlist= QStringList()
                for d in plist:
                        strlist.append(d)
                return strlist

