from qt import *
from qttable import *
from PyDVT.View import View
from GraphWindow import PenStyles, PenColors, getColorName, getColorRgb, YScales
from PyDVT.GraphView import Pen
from PyDVT.Binding import Dialog

class GraphRoiList(QWidget):
	def __init__(self, parent=None, name="GraphRoiList", fl=0):
		QWidget.__init__(self, parent, name, fl)
		self.refreshFlag= 0

		mainLayout= QHBoxLayout(self)

		# --- table with roi limits
		self.table= QTable(self)
		self.table.setSelectionMode(QTable.MultiRow)
		self.table.setFocusStyle(QTable.FollowStyle)
		self.table.setReadOnly(0)
		#self.table.setNumCols(4)
		self.table.setNumCols(3)

		Hheader= self.table.horizontalHeader()
		Hheader.setLabel(0, "Min")
		Hheader.setLabel(1, "Max")
		Hheader.setLabel(2, "BorderColor")
		#Hheader.setLabel(3, "Hide")

		self.connect(self.table, SIGNAL("valueChanged(int,int)"), self.__valueChanged)

		# --- action buttons
		butWidget= QWidget(self)
		removeButton= QPushButton("Remove", butWidget)
		addButton= QPushButton("Add", butWidget)
		#viewButton= QPushButton("View/Hide", butWidget)

		butLayout= QVBoxLayout(butWidget)
		butLayout.addWidget(addButton)
		butLayout.addWidget(removeButton)
		#butLayout.addWidget(viewButton)

		self.connect(removeButton, SIGNAL("clicked()"), self.__removeClicked)
		self.connect(addButton, SIGNAL("clicked()"), self.__addClicked)
		#self.connect(viewButton, SIGNAL("clicked()"), self.__viewClicked)

		mainLayout.addWidget(self.table)
		mainLayout.addWidget(butWidget, 0, Qt.AlignTop)

	def SetSource(self, roilist):
		""" source = McaGraphRoiList object
		"""
		self.source= roilist
		self.Refresh()
		self.source.eh.register("ListChange", self.Refresh)

	def setAutoRefresh(self, auto):
		if auto!=self.refreshFlag:
			if auto:
				self.Refresh()
				self.source.eh.register("ListChange", self.Refresh)
			else:
				self.source.eh.unregister("ListChange", self.Refresh)

	def Refresh(self, rois=None):
		self.Clear()
		if rois is None: rois= self.source.GetList()
		self.table.setNumRows(len(rois))
		for idx in range(len(rois)):
			self.SetRow(idx, rois[idx])
		self.__adjustTable()

	def SetRow(self, row, select):
		limits= select.GetLimits()
		pen= select.GetPen()
		color= getColorName(pen.color)
		self.table.setText(row, 0, "%.3f"%limits[0])
		self.table.setText(row, 1, "%.3f"%limits[1])
		self.table.setItem(row, 2, self.__getComboItem([col[0] for col in PenColors], color))
		#self.table.setItem(row, 3, self.__getCheckItem(select.IsHidden()))
		
	def Clear(self):
		#self.table.clearSelection(1)
		self.table.setNumRows(0)

	def Destroy(self):
		self.source.eh.unregister("RoiChange", self.Refresh)
		del self.source

	def __valueChanged(self, row, col):
		roi= self.source.GetList()[row]
		if col==2:	self.__colorChanged(roi, row)
		#elif col==3:	self.__hideChanged(roi)
		else:		self.__limitChanged(roi, row)

	def __colorChanged(self, roi, row):
		color= getColorRgb(str(self.table.item(row, 2).currentText()))
		pen= roi.GetPen()
		pen.color= color
		roi.SetPen(pen)
		roi.Update()

	def __limitChanged(self, roi, row):
		min= str(self.table.text(row, 0))
		max= str(self.table.text(row, 1))
		try:
			fmin= float(min)
			fmax= float(max)
			roi.SetLimits((fmin,fmax))
		except:
			QMessageBox.critical(self, "ERROR in roi limits",
						"Wrong limits for Roi.\nReset values to previous ones.")
			self.SetRow(row, roi)

	def __hideChanged(self, roi):
		if roi.IsHidden(): roi.Show()
		else: roi.Hide()

	def __removeClicked(self):
		todelete= [ row for row in range(self.table.numRows()) if self.table.isRowSelected(row) ]
		self.source.Delete(todelete, sendevent=0)
		self.Refresh()

	def __addClicked(self):
		self.source.Add(((0,0), (1,0)), sendevent=0)
		self.Refresh()

	def __viewClicked(self):
		if self.source.Hidden:
			self.source.Show()
		else:
			self.source.Hide()
	
	def __getCheckItem(self, checked):
		item= QCheckTableItem(self.table, None)
		item.setChecked(checked)
		return item
	
        def __getComboItem(self, data, selected=None):
                item= QComboTableItem(self.table, self.__getStringList(data))
                if selected is not None:
                        item.setCurrentItem(str(selected))
                return item

        def __getStringList(self, plist):
                strlist= QStringList()
                for d in plist:
                        strlist.append(d)
                return strlist

        def __adjustTable(self):
                for col in range(self.table.numCols()):
                        self.table.adjustColumn(col)


class RoiLimitsDialog(Dialog):
	def __init__(self, parent=None):
		Dialog.__init__(self,parent,title="Roi Limits",modal=0,resizable=1)

		mainLayout= QVBoxLayout(self)

		self.roiLimits= GraphRoiList(self)
		mainLayout.addWidget(self.roiLimits)

		okButton=QPushButton(self)
                okButton.setAutoDefault(0)
                okButton.setText('close')
                self.connect(okButton,SIGNAL('clicked()'),self.valid)
                mainLayout.addWidget(okButton)

	def SetSource(self, roilist):
		self.roiLimits.SetSource(roilist)

	def closeEvent(self, ce=None):
		self.Destroyed= 1
		self.roiLimits.Destroy()
		if ce is not None:
			ce.accept()
		self.close()

	def valid(self, event=None):
                self.Destroyed=1
                self.close()

if __name__=="__main__":
	import sys
	app = QApplication(sys.argv)
	app.connect(app,SIGNAL('lastWindowClosed()'),app,SLOT('quit()'))

	dial=RoiLimitsDialog()
        dial.Show()

	app.exec_loop()

