from qt import *
from EventHandler import EventHandler
from GraphItemList import GraphItemList
from GraphDataList import GraphDataList
from GraphRoiList import GraphRoiList
from GraphSetting import GraphSetting
from DataInfo import DataInfo


class GraphInfo(QSplitter):
	def __init__(self, parent=None, name=None, graph=None):
		QSplitter.__init__(self, parent, name)

		self.name= name
		self.graph= graph
		self.refreshFlag= 0
		self.eh= EventHandler()

		self.itemList= GraphItemList(self, self.name, self.graph)

		self.itemStack= QWidgetStack(self)
		self.dataListWidget= None
		self.roiListWidget= None
		self.graphSettingWidget= None
		self.dataInfoWidget= None

		self.connect(self.itemList, PYSIGNAL("itemSelected"), self.showItem)
		self.itemList.initSelect()

		sizes= self.sizes()

	def setAutoRefresh(self, auto):
		if self.refreshFlag!=auto:
			self.refreshFlag= auto
			self.itemList.setAutoRefresh(auto)
			wid= self.itemStack.visibleWidget()
			if wid is not None: wid.setAutoRefresh(auto)

	def setGraphNames(self, graphnames):
		if self.dataListWidget is not None:
			self.dataListWidget.setGraphNames(graphnames)

	def showItem(self, name):
		wid= self.itemStack.visibleWidget()
		if wid is not None: wid.setAutoRefresh(0)

		if name=="list":	self.showDataList()
		elif name=="roi":	self.showRoiList()
		elif name=="setting":	self.showGraphSetting()
		else:			self.showDataInfo(name)

	def showDataList(self):
		if self.dataListWidget is None:
			self.dataListWidget= GraphDataList(self.itemStack, self.name, self.graph, self.eh)
		self.itemStack.raiseWidget(self.dataListWidget)
		self.dataListWidget.setAutoRefresh(1)

	def showRoiList(self):
		if self.roiListWidget is None:
			self.roiListWidget= GraphRoiList(self.itemStack)
			self.roiListWidget.SetSource(self.graph.getRoiList())
		self.itemStack.raiseWidget(self.roiListWidget)
		self.roiListWidget.setAutoRefresh(1)

	def showGraphSetting(self):
		if self.graphSettingWidget is None:
			self.graphSettingWidget= GraphSetting(self.itemStack, self.name, self.graph)
		self.itemStack.raiseWidget(self.graphSettingWidget)
		self.graphSettingWidget.setAutoRefresh(1)

	def showDataInfo(self, name):
		if self.dataInfoWidget is None:
			self.dataInfoWidget= DataInfo(self.itemStack, self.name, self.graph)
		self.itemStack.raiseWidget(self.dataInfoWidget)
		self.dataInfoWidget.setFilter(self.graph.GetFilter(name))
		self.dataInfoWidget.setAutoRefresh(1)

if __name__=="__main__":
	import sys

	a= QApplication(sys.argv)
	w= GraphInfo()
	w.show()
	a.setMainWidget(w)
	a.exec_loop()
