from qt import *
from qttable import *

from GraphWindow import PenStyles, PenColors, getColorName, getColorRgb, YScales
from PyDVT.GraphView import Pen

class GraphDataList(QWidget):
	def __init__(self, parent=None, name=None, graph=None, eh=None):
		QWidget.__init__(self, parent, name, 0)

		self.name	= name
		self.graph	= graph
		self.graphNames	= []
		self.names	= []
		self.refreshFlag= 0
	
		self.eh= eh
		if self.eh is not None:
			self.addFilterEvent= self.eh.create("addFilterEvent")
			self.delFilterEvent= self.eh.create("delFilterEvent")

		self.mainLayout= QHBoxLayout(self)

		# --- table with plot list
		self.table= QTable(self)
		self.table.setSelectionMode(QTable.MultiRow)
		self.table.setFocusStyle(QTable.FollowStyle)

		Theaders= [ ("Type",1), ("Name",1), ("PlotColor",0), ("PlotLine",0), ("YScale",0),
				("YFactor",0), ("Normalization",0) ]
		self.table.setNumCols(len(Theaders))
		Hheader= self.table.horizontalHeader()
		for idx in range(len(Theaders)):
			Hheader.setLabel(idx, Theaders[idx][0])
			self.table.setColumnReadOnly(idx, Theaders[idx][1])

		self.connect(self.table, SIGNAL("valueChanged(int,int)"), self.__valueChanged)
		self.mainLayout.addWidget(self.table)

		# --- buttons
		butWidget	= QWidget(self)
		butLayout	= QVBoxLayout(butWidget)
		removeButton	= QPushButton("Remove", butWidget)
		movetoButton	= QToolButton(butWidget)
		movetoButton.setSizePolicy(QSizePolicy(QSizePolicy.Minimum, QSizePolicy.Fixed))
		movetoButton.setText("Move To")
		self.graphMenu	= QPopupMenu(movetoButton)
		self.connect(self.graphMenu, SIGNAL("aboutToShow()"), self.__graphMenu)
		movetoButton.setPopup(self.graphMenu)
		movetoButton.setPopupDelay(0)

		butLayout.addWidget(removeButton)
		butLayout.addWidget(movetoButton)

		self.mainLayout.addWidget(butWidget, 0, Qt.AlignTop)

		self.connect(removeButton, SIGNAL("clicked()"), self.__removeClicked)


	def setGraphNames(self, graphNames):
		if graphNames != self.graphNames[:-1]:
			self.graphNames= graphNames + ["New"]

	def setAutoRefresh(self, auto):
		if self.refreshFlag!=auto:
			self.refreshFlag= auto
			if auto:
				self.setGraphFilters(self.graph.GetSource())
				self.graph.eh.register("SourceChange", self.setGraphFilters)
			else:
				self.graph.eh.unregister("SourceChange", self.setGraphFilters)


	def setGraphFilters(self, graphfilters):
		print "setGraphFilters", self.name, graphfilters

		self.table.setNumRows(0)
		self.names= []

		if graphfilters is not None:
			for filter in graphfilters:
				print filter, filter.GetType()
				if filter.GetType()!="Peak":
					self.addRow(filter)
			self.__adjustTable()

	def addRow(self, filter):
		graphinfo= filter.GetInfo()
		datainfo= filter.GetDataSelection().GetInfo()
		try: typeinfo= filter.GetSource().GetType()
		except: typeinfo= "-"

		self.table.setNumRows(self.table.numRows()+1)	
		row= self.table.numRows()-1
		self.names.append(graphinfo["name"])

		self.table.setText(row, 0, str(typeinfo))
		self.table.setText(row, 1, str(datainfo.get("Legend", "-")))
		self.table.setItem(row, 2, 
			self.__getComboItem([col[0] for col in PenColors], getColorName(graphinfo["pen"].color)))
		self.table.setItem(row, 3, self.__getComboItem(PenStyles, graphinfo["pen"].style))
		self.table.setItem(row, 4, self.__getComboItem(YScales, YScales[graphinfo["yscale"]]))
		self.table.setText(row, 5, str(graphinfo.get("yfactor", 1)))
		self.table.setItem(row, 6, self.__getComboItem(graphinfo["norm"].keys()+["none"], 
						(graphinfo.get("active_norm") or "none")))

	def __getComboItem(self, data, selected=None):
		item= QComboTableItem(self.table, self.__getStringList(data))
		if selected is not None:
			item.setCurrentItem(data.index(selected))
		return item

	def __getStringList(self, plist):
		strlist= QStringList()
		for d in plist:
			strlist.append(d)
		return strlist

	def __adjustTable(self):
	 	for col in range(self.table.numCols()):
			self.table.adjustColumn(col)

	def __removeClicked(self):
		filters= ()
		names= ()
		for row in range(self.table.numRows()):
			if self.table.isRowSelected(row):
				names += (self.names[row],)
				filters += (self.graph.GetFilter(self.names[row]),)
		if len(filters) and self.eh is not None:
			self.eh.event(self.delFilterEvent, filters)

	def __valueChanged(self, row, col):
		if col==2 or col==3:	self.__penChanged(row)
		elif col==4:		self.__yscaleChanged(row)
		elif col==5:		self.__yfactorChanged(row)
		elif col==6:		self.__normChanged(row)
		else: print "__valueChanged not handled", row, col

	def __penChanged(self, row):
		name= self.names[row]
		color= getColorRgb(str(self.table.item(row, 2).currentText()))
		style= str(self.table.item(row, 3).currentText())
		self.graph.SetPen(name, Pen(color, 1, style))

	def __yscaleChanged(self, row):
		name= self.names[row]
		yscale= YScales.index(str(self.table.item(row, 4).currentText()))
		self.graph.SetYScale(name, yscale)

	def __yfactorChanged(self, row):
		name= self.names[row]
		sfactor= str(self.table.text(row, 5))
		filter= self.graph.GetFilter(name)
		try:
			yfactor= float(sfactor)
			filter.SetYFactor(yfactor)
			filter.Refresh()
		except:
			QMessageBox.critical(self, "ERROR in YFactor", \
				"YFactor should be a float number.\nReset it to old value")
			self.table.setText(row, 5, str(filter.yscale))
		
	def __normChanged(self, row):
		name= self.names[row]
		norm= str(self.table.item(row, 6).currentText())
		if norm=="none": norm=None
		filter= self.graph.GetFilter(name)
		filter.SetActiveNorm(norm)
		filter.Refresh()

	def __graphMenu(self):
		self.graphMenu.clear()
		self.graphMenuIndex= {}
		for graph in self.graphNames:
			if graph!=self.name:
				idx= self.graphMenu.insertItem(graph, self.__movetoGraph)
				self.graphMenuIndex[idx]= graph

	def __movetoGraph(self, idx):
		graph= self.graphMenuIndex[idx]
		filters= ()
		names= ()
		for row in range(self.table.numRows()):
			if self.table.isRowSelected(row):
				names += (self.names[row],)
				filters += (self.graph.GetFilter(self.names[row]),)
		if len(filters):
			self.graph.RemoveFilter(names)
			if self.eh is not None:
				self.eh.event(self.addFilterEvent, filters, graph)
