import qt,saxs,array
from Numeric import *
from ExtendedImageView import *
from ExtendedGraphView import *
from scidxp.util import *
import ReadEdfFile
import ImageView
import GraphView

DEBUG=1

class IntegratePhiFilter(GraphFilter):
	def __init__(self,name=None,source=None,synchronized=1,buffer_input=0,yscale=0,xdata=None,pen=Pen((0,0,0),2,"solid"),symbol="none",plugin=None,parentWindow=None):
		GraphView.GraphFilter.__init__(self,name,source,synchronized,buffer_input,yscale,xdata,pen,symbol)
		self.name=name
		self.plugin=plugin
		self.parentWindow=parentWindow
	
	def GetOutput(self):
		if DEBUG: print 'In IntegratePhiFilter.GetOuput...'
		
		sel=self.GetInput()
		
		image=sel['data']
				
		if len(self.plugin.GetRois(self.parentWindow))!=3:
			print 'You must select 3 ROIs before integrate !'
			return {}
		else:
			print 'number of ROIs:',len(self.plugin.GetRois(self.parentWindow))
			Limits = [self.plugin.GetRois(self.parentWindow)[0].limits[0],self.plugin.GetRois(self.parentWindow)[1].limits[0],self.plugin.GetRois(self.parentWindow)[2].limits[0]]
			Limits.sort()
			ROI=Limits[1]
			BKG1=Limits[0]
			BKG2=Limits[2]
			print 'BKG1,ROI,BKG2=',BKG1,ROI,BKG2
          		y1, y2 = ROI[0],ROI[1]
			y3, y4 = BKG1[0],BKG1[1]
			y5, y6 = BKG2[0],BKG2[1]
          		ROI = Numeric.sum(image[:,int(y1):int(y2)],1)
            		BKG1 = Numeric.sum(image[:,int(y3):int(y4)],1)
          		BKG2 = Numeric.sum(image[:,int(y5):int(y6)],1)
        		if len(BKG1) == len(BKG2):
         			BKG = BKG1 + BKG2
        		else:
          			BKG = BKG1
        		integrated_arr = ROI - BKG
		
			#image = data.astype(Numeric.Float32)
			#print image[0,0]
      			#out_image =array((image))
			
      			xdata=arange(0,integrated_arr.shape[0],1)			
			return {'name': self.name,'data': integrated_arr,'xdata': xdata,'yscale': self.yscale,'pen':self.pen,'symbol':self.symbol}
			
			#self.GetInput()["data"]=integrated_arr
			#return GraphFilter.GetOutput(self)
		
	
