# Copyright (c) 2002 Detlev Offenbach <detlev@die-offenbachs.de>

import os

from qt import *

from BookmarkForm import BookmarkForm

class BookmarkDialog(BookmarkForm):
    def __init__(self,parent,name=None,modal=0,fl=0):
        BookmarkForm.__init__(self,parent,name,modal,fl)
        
        self.parent = parent
        
        self.bmListView.setSorting(-1)
        
    def populateBMListView(self):
        """
        Private function to set up the contents of the listview.
        """
        self.bmListView.clear()
        mBookmarks = self.parent.__class__.mBookmarks[:]
        mBookmarks.reverse()
        for bookm in mBookmarks:
            itm = QListViewItem(self.bmListView, bookm[0], bookm[1])
            itm.setRenameEnabled(0, 1)
            itm.setRenameEnabled(1, 1)
        
    def moveUp(self):
        """
        Private slot called to move the selected item up in the list.
        """
        itm = self.bmListView.currentItem()
        if itm is None:
            # nothing selected
            return
            
        itmAbove = itm.itemAbove()
        if itmAbove is None:
            # we're already at the top
            return
            
        itmAbove.moveItem(itm)
        
    def moveDown(self):
        """
        Private slot called to move the selected item down in the list.
        """
        itm = self.bmListView.currentItem()
        if itm is None:
            # nothing selected
            return
            
        itmBelow = itm.itemBelow()
        if itmBelow is None:
            # we're already at the end
            return
            
        itm.moveItem(itmBelow)
        
    def handleDelete(self):
        itm = self.bmListView.currentItem()
        if itm is None:
            # nothing selected
            return
            
        self.bmListView.takeItem(itm)
        del itm
        
    def accept(self):
        """
        Private slot called if the Ok button is pressed.
        It updates the bookmarks list and writes it to
        the bookmarks file.
        """
        self.parent.__class__.mBookmarks = []
        itm = self.bmListView.firstChild()
        while 1:
            self.parent.__class__.mBookmarks.append(
                (str(itm.text(0)), str(itm.text(1))))
            itm = itm.nextSibling()
            if itm is None:
                break
        self.parent.writeBookmarks()
        BookmarkForm.accept(self)
        
    def show(self):
        """
        Public slot called to display this dialog.
        """
        self.populateBMListView()
        BookmarkForm.show(self)