#!/usr/bin/env python

""" This defines the main part of the odak data manipulation section. """
# mcb May 2001
__author__ = "Manfred Burghammer"


import sys, os

from Numeric import *
from PyODAKDM import * 
#from odakdm import *

import utils
from utils import TRUE, FALSE
from excp import BaseExcp

try:
	import readline
except:
	pass




########################################################################
#                                  (                       :

UINT8_T     =  4
UINT16_T    =  5
UINT32_T    =  6
SINT8_T     =  7
SINT16_T    =  8
SINT32_T    =  9
FLOAT_T     = 10
DOUBLE_T    = 11
#COMPLEX_T  = 9912
#DCOMPLEX_T = 9913

CHAR_BIT    = 8
INT_F       = 1
FLOAT_F     = 2

class TypeTables:

#     C          tcode      C def       Num(Nstr) size   signed  family
	_BASE = [\
	  ('uint8_t' , UINT8_T , 'UINT8_T' ,  '',       1,     FALSE,  INT_F),
	  ('uint16_t', UINT16_T, 'UINT16_T',  '',       2,     FALSE,  INT_F),
	  ('uint32_t', UINT32_T, 'UINT32_T',  '',       4,     FALSE,  INT_F),
	  ('sint8_t' , SINT8_T , 'UINT8_T' ,  '',       1,     TRUE,   INT_F),
	  ('sint16_t', SINT16_T, 'UINT16_T',  '',       2,     TRUE,   INT_F),
	  ('sint32_t', SINT32_T, 'UINT32_T',  Int,      4,     TRUE,   INT_F),
	  ('float_t',  FLOAT_T,  'UINT32_T',  '',       4,     TRUE,   FLOAT_F),
	  ('double_t', DOUBLE_T, 'UINT32_T',  Float,    8,     TRUE,   FLOAT_F)\
	]

	def __init__(self):
		self.npDc = {}
		self.sizeDc = {}
		for i in self._BASE:
			self.npDc[i[1]] = i[3]
			self.sizeDc[i[1]] = i[4]
		return

	def getCodeT2NP(self, tcode):
		return self.npDc[tcode]

	def getSizeTcode(self, tcode):
		return self.sizeDc[tcode]


# we need an instance here ...
TT = TypeTables()


#                                  (                       :
class ODMDExcp                     (BaseExcp)              : pass
class ODMData:

	#status
	NEW = 1

	def __init__(self):
		self.status = { 'live' : self.NEW }
		return


class ODMArray(ODMData):

	#status

	def __init__(self, shape=None, tcode=SINT32_T, alloc=FALSE):
		ODMData.__init__(self)
		self.a = None
		self.shape  = shape
		if self.shape:
			self.dim    = len(shape)
		else:
			self.dim = None
		self.tcode  = tcode
		self.alloc  = alloc
		return

	def getNN(self):
		if not self.shape: return 0
		nn = 1
		for i in self.shape:
			nn = nn*i
		return nn

	def getFlatSubData(self, o1, o2, n1, n2):
		# Attention: Numpy uses the "slow index first convention"
		return ravel(self.a[o2:o2+n2,o1:o1+n1])


#                                  (                       :
class ODMFIExcp                    (ODMDExcp)              : pass
class ODMFINoFileExcp              (ODMFIExcp)             : pass
class ODMFileImage(ODMArray):

	def __init__(self, shape=None, tcode=SINT32_T, alloc=FALSE, gfp=None):
		ODMArray.__init__(self, shape, tcode, alloc)
		self.loaded = FALSE
		self.gfp = gfp
		if alloc:
			if not gfp: raise ODMFINoFile("no filename provided")
		return

	def outputBinary(self, ogfp, tcode, swap):
		OdmNpyBinaryOutput(ogfp, self.a, self.getSelfSize(tcode), swap)
		return

	def getSelfSize(self, tcode):
		size = TT.getSizeTcode(tcode)
		for i in self.shape:
			size = size*i
		return size


class ODMBFINoShapeExcp            (ODMFIExcp)             : pass
class ODMBinFileImage(ODMFileImage):

	def __init__(self, shape=None, tcode=SINT32_T, scode=None, alloc=FALSE,
	                   gfp=None, offset=0, swap=0):
		ODMFileImage.__init__(self, shape, tcode, alloc, gfp)
		self.offset = offset
		self.swap = swap
		if alloc:
			self.npcode = TT.getCodeT2NP(tcode)
			if not self.shape:
				raise ODMBFINoShape("no shape provided")
			self.a = zeros(self.shape, self.npcode)
			print "reading binary file %s ..." % (self.gfp,)
			if None == scode:
				print "okeydokey"
				if not OdmNpyBinaryInput(self.gfp, self.a,
				                         self.getSelfSize(self.tcode),
				                         self.offset, self.swap):
					self.loaded = TRUE
			else:
				print "gfp, nn, sc, sz, tc, tz, off, swap" 
				print                        self.gfp,\
				                             self.getNN(),\
                                     scode,\
                                     TT.getSizeTcode(scode),\
                                     self.tcode,\
                                     TT.getSizeTcode(tcode),\
                                     self.offset, self.swap

				if not OdmNpyConvBinaryInput(self.gfp, self.a,
				                             self.getNN(),
				                             self.offset,
				                             scode,
				                             TT.getSizeTcode(scode),
				                             self.tcode,
				                             TT.getSizeTcode(tcode),
				                             self.swap):
					self.loaded = TRUE
				
		return

class ODMMARBinningExcp            (ODMFIExcp)             : pass
class ODMMarCCDImageA(ODMFileImage):

	def __init__(self, shape=None, tcode=SINT32_T, alloc=FALSE, gfp=None,
	             binning=1, swap=0):
		ODMFileImage.__init__(self, shape, tcode, alloc, gfp)
		self.swap = swap
		if binning == 1 or binning == 2:
			self.binning = binning
		else:
			raise ODMMARBinningExcp("illegal binning")
		if alloc:
			self.npcode = TT.getCodeT2NP(tcode)
			self.shape = (2048/binning, 2048/binning)
			self.dim = 2
			self.a = zeros(self.shape, self.npcode)
			print "reading marfile %s ..." % (self.gfp,)
			if not OdmNpyMarInput(self.gfp, self.a, binning, self.tcode,
			                      self.swap):
				self.loaded = TRUE
		return

########################################################################
def main(argv):

	print 'Test of module: odm'

	while 1:
		try:
			str = raw_input('test > ')
			# test ...
			wds = string.split(str)
			lenwds = len(wds)
			if lenwds and 'exit' == wds[0]:
				break
			elif lenwds == 1 and 'help' == wds[0]:
				print """
mar if of
bin if of swap
help
! syscmd
"""
			elif lenwds == 3 and 'mar' == wds[0]:
				try:
					mar = ODMMarCCDImageA(alloc=TRUE, gfp=wds[1])
					mar.outputBinary(wds[2], SINT32_T, FALSE)
				except:
					utils.utPrintTraceback()
			elif lenwds == 4 and 'bin' == wds[0]:
				try:
					print "input of", wds[1], "as bin"
					x = ODMBinFileImage(shape=(2048,2048), offset=0,
					                    alloc=TRUE, gfp=wds[1],
					                    swap = string.atoi(wds[3]))
					print "outut of", wds[2], "as signed long bin"
					x.outputBinary(wds[2], SINT32_T, FALSE)
				except:
					utils.utPrintTraceback()
			elif str and '!' == str[0]:
				try:
					os.system(str)
				except:
					utils.utPrintTraceback()
			else:
				print "syntax error"
		except KeyboardInterrupt:
			print '\nBye!'
			break
	return 0


########################################################################
if __name__ == '__main__':
	sys.exit(main(sys.argv))
