#include <stdlib.h>
#include <stddef.h>
#include <limits.h>
#include "mcb.h"

int check_impl(int verbose)
{
	int result;

	result = (size_t)1 == sizeof(char)    &&
	         (size_t)2 == sizeof(short)   &&
	         (size_t)4 == sizeof(long)    &&
	         (size_t)4 == sizeof(float)   &&
	         (size_t)8 == sizeof(double)  &&
	         8 == CHAR_BIT;
	if(verbose)
		printf("check of implementation: passed=%s\n\
CHAR_BIT=%1d  bytes: c=%1ld i=%1ld s=%1ld l=%1ld f=%1ld d=%1ld\n",
		       STRBOOL(result), CHAR_BIT,
		       sizeof(char), sizeof(int), sizeof(short),
		       sizeof(long), sizeof(float), sizeof(double));
	return result;
}

void_t *void_newarray(size_t n)
{
	return (void_t *)malloc(sizeof(char_t)*n);
}

char_t *char_newarray(size_t n)
{
	return (char_t *)malloc(sizeof(char_t)*n);
}

int_t *int_newarray(size_t n)
{
	return (int_t *)malloc(sizeof(int_t)*n);
}

uint8_t *uint8_newarray(size_t n)
{
	return (uint8_t *)malloc(sizeof(uint8_t)*n);
}

uint16_t *uint16_newarray(size_t n)
{
	return (uint16_t *)malloc(sizeof(uint16_t)*n);
}

uint32_t *uint32_newarray(size_t n)
{
	return (uint32_t *)malloc(sizeof(uint32_t)*n);
}

sint8_t * sint8_newarray(size_t n)
{
	return (sint8_t *)malloc(sizeof(sint8_t)*n);
}

sint16_t * sint16_newarray(size_t n)
{
	return (sint16_t *)malloc(sizeof(sint16_t)*n);
}

sint32_t * sint32_newarray(size_t n)
{
	return (sint32_t *)malloc(sizeof(sint32_t)*n);
}

float_t * float_newarray(size_t n)
{
	return (float_t *)malloc(sizeof(float_t)*n);
}

double_t * double_newarray(size_t n)
{
	return (double_t *)malloc(sizeof(double_t)*n);
}

boolean_t * boolean_newarray(size_t n)
{
	return (boolean_t *)malloc(sizeof(boolean_t)*n);
}

error_t * error_newarray(size_t n)
{
	return (error_t *)malloc(sizeof(error_t)*n);
}

