/* file: binio.c
 * author: mcb (Seyssins, Sat May 26 01:03:40 MEST 2001)
 * type: C source
 * what it is:
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "mcb.h"
#include "binio.h"


error_t raw_bin_i(char *gfp, void_t *buffer, size_t nbytes, size_t noffset)
{
	FILE *filep;
	size_t nbytes_read;

	if(NULL == buffer) return NULLPTR_ERR;
	filep = fopen(gfp, "rb");
	if(NULL == filep) return IO_FOPEN_ERR;
	fseek(filep, noffset, SEEK_SET);
	if(feof(filep)) return IO_FEOF_ERR;
	if(ferror(filep)) return IO_FERROR_ERR;
	nbytes_read = fread(buffer, sizeof(char_t), nbytes, filep);
	FREAD_INFO(nbytes, nbytes_read);
	fclose(filep);
	if(nbytes != nbytes_read) return IO_FREAD_ERR; 
	return NO_ERROR;
}


error_t convraw_bin_i(char *gfp, void_t *buffer,
                      size_t nn, size_t noffset,
                      int_t ltype, size_t lsize,
                      int_t rtype, size_t rsize,
                      size_t swap)
{
	error_t result;
	FILE *filep;
	void *v = NULL;
	size_t nbytes_read;
	result = NO_ERROR;


	printf("This is convraw_bin_i ..\n");
	v = void_newarray(nn*lsize);
	printf("%ld %ld %ld\n", nn, lsize,nn*lsize);
	if(NULL == buffer) result = ALLOC_ERR;
	CRETURN(result);

	filep = fopen(gfp, "rb");
	if(NULL == filep) result = IO_FOPEN_ERR;
	CRETURN(result);

	fseek(filep, noffset, SEEK_SET);
	if(feof(filep)) result =  IO_FEOF_ERR;
	CRETURN(result);

	if(ferror(filep)) result =  IO_FERROR_ERR;
	CRETURN(result);

	nbytes_read = fread(v, sizeof(char), nn*lsize, filep);
	FREAD_INFO(lsize*nn, nbytes_read);
	fclose(filep);
	if(nn*lsize != nbytes_read) result = IO_FREAD_ERR;
	printf("%1\n");
	CRETURN(result);
	printf("%1\n");

	if (swap) CRETURN(byte_swap(v, nn, swap));
	printf("%1\n");

	CRETURN(bin_conv(v, nn, buffer, ltype, rtype));
	printf("%1\n");

	return result;
}


error_t raw_bin_o(char *gfp, void_t *buffer, size_t nbytes)
{
	FILE *filep;
	size_t nbytes_wrote;
	
	if(NULL == buffer) return NULLPTR_ERR;
	filep = fopen(gfp, "wb");
	if(NULL == filep) return IO_FOPEN_ERR;
	nbytes_wrote = fwrite(buffer, sizeof(char_t), nbytes, filep);
	FWRITE_INFO(nbytes, nbytes_wrote);
	fclose(filep);
	if(nbytes != nbytes_wrote) return IO_FWRITE_ERR; 
	return NO_ERROR;
}


/* not changing file position if noffset is negative !!! */
error_t fraw_bin_i(FILE *filep, void_t *buffer, size_t nbytes, size_t noffset)
{
	size_t nbytes_read;

	if(NULL == buffer) return NULLPTR_ERR;
	if (noffset >= 0) fseek(filep, noffset, SEEK_SET);
	if(feof(filep)) return IO_FEOF_ERR;
	if(ferror(filep)) return IO_FERROR_ERR;
	nbytes_read = fread(buffer, sizeof(char_t), nbytes, filep);
	FREAD_INFO(nbytes, nbytes_read);
	if(nbytes != nbytes_read) return IO_FREAD_ERR; 
	return NO_ERROR;
}


error_t fraw_bin_o(FILE *filep, void_t *buffer, size_t nbytes)
{
	size_t nbytes_wrote;
	
	if(NULL == buffer) return NULLPTR_ERR;
	nbytes_wrote = fwrite(buffer, sizeof(char_t), nbytes, filep);
	FWRITE_INFO(nbytes, nbytes_wrote);
	if(nbytes != nbytes_wrote) return IO_FWRITE_ERR; 
	return NO_ERROR;
}
