/* file: bina.h
 * author: mcb (Seyssins, Sat May 26 01:03:40 MEST 2001)
 * type: C header to bina.c
 * what it is:
 */

/* error_base */
#define ERROR_BASE_BINA (error_t)2000

/* common error_codes */
#define        NOT_IMPL_BINA_ERR            ERROR_BASE_BINA + 1
#define        ILLEGAL_CLIP_BINA_ERR        ERROR_BASE_BINA + 2
#define        CONVERSION_BINA_ERR          ERROR_BASE_BINA + 3

/* Clip structure */

#define CLIP_AFFECTED   0x0000001L
#define CLIP_ILLEGAL    0x0000002L
#define CLIP_AFFECTED_X 0x0000010L
#define CLIP_ILLEGAL_X  0x0000020L
#define CLIP_AFFECTED_Y 0x0000100L
#define CLIP_ILLEGAL_Y  0x0000200L
#define CLIP_UNDEFINED  0x1000000L

typedef struct ClipStruct *ClipPtr;
typedef struct ClipStruct {
	sint32_t casus;
	sint32_t scanx;
	sint32_t scany;
	sint32_t ojmp;
	sint32_t sjmp;
	sint32_t oax;
	sint32_t obx;
	sint32_t ocx;
	sint32_t nax;
	sint32_t nbx;
	sint32_t ncx;
	sint32_t oay;
	sint32_t oby;
	sint32_t ocy;
	sint32_t nay;
	sint32_t nby;
	sint32_t ncy;
} Clip;


/* declarations */
extern error_t byte_swap(void *p, size_t n, size_t size);
extern void printClip(Clip *c);
extern error_t printClipData(const Clip c, const void *buffer,
                             int_t dtype,  char *fstr);
extern error_t clip(sint32_t oax, sint32_t oay, sint32_t nax, sint32_t nay,
                    sint32_t obx, sint32_t oby, sint32_t nbx, sint32_t nby,
                    sint32_t scanx, sint32_t scany, Clip *c);
extern error_t bin_conv(void *s, size_t size, void *t,
                        int_t stype, int_t ttype);
