/* file: bina.c
 * author: mcb (Seyssins, Sat May 26 01:03:40 MEST 2001)
 * type: C source
 * what it is:
 */
#include <stdio.h>
#include <stdlib.h>
#include "mcb.h"
#include "binio.h"
#include "bina.h"


/* basic binary array operations */
error_t byte_swap(void *p, size_t n, size_t size)
{
	error_t result = NO_ERROR;
	char *a, *b, c;

	switch(size) {
	case 2:
		for (a = (char*)p ; n > 0; n--, a += 1) {
			b = a + 1;
			c = *a; *a++ = *b; *b   = c;
		}
		break;
	case 4:
		for (a = (char*)p ; n > 0; n--, a += 2) {
			b = a + 3;
			c = *a; *a++ = *b; *b-- = c;
			c = *a; *a++ = *b; *b   = c;
		}
		break;
	case 8:
		for (a = (char*)p ; n > 0; n--, a += 4) {
			b = a + 7;
			c = *a; *a++ = *b; *b-- = c;
			c = *a; *a++ = *b; *b-- = c;
			c = *a; *a++ = *b; *b-- = c;
			c = *a; *a++ = *b; *b   = c;
		}
		break;
	default:
		result = NOTIMPL_ERR;
		break;
	}
	return result;
}


/* data clipipping */
void printClip(Clip *c)
{
	printf("\
casus=%#09x\n\
scanx=%10ld  scany=%10ld   ojmp=%10ld   sjmp=%10ld\n\
  nax=%10ld    nay=%10ld    oax=%10ld    oay=%10ld\n\
  nbx=%10ld    nby=%10ld    obx=%10ld    oby=%10ld\n\
  ncx=%10ld    ncy=%10ld    ocx=%10ld    ocy=%10ld\n",
	        c->casus,
	        c->scanx, c->scany, c->ojmp, c->sjmp,
	        c->nax, c->nay, c->oax, c->oay,
	        c->nbx, c->nby, c->obx, c->oby,
	        c->ncx, c->ncy, c->ocx, c->ocy);

	return;
}


error_t printClipData(const Clip c, const void *buffer, int_t dtype, char *fstr)
{
	char_t *outstr, *form = "  %10ld";
	error_t result = NO_ERROR;
	uint32_t i, j;
	uint16_t *u16;
	sint32_t *s32;

	printf("Warning! This function is still incomplete.\n");
	if(fstr) form = fstr;
	if(c.casus & (CLIP_ILLEGAL | CLIP_UNDEFINED)) return ILLEGAL_CLIP_BINA_ERR;
	switch(dtype) {
		case UINT16_T:
			break;
		case SINT32_T:
			s32 = (sint32_t *)buffer;
			s32 = s32 + c.ojmp;
			for(i=0; i<c.ncy;i++) {
				for(j=0; j<c.ncx; j++) {
					printf(form, *s32++);
				}
				s32 += c.sjmp - 1;
				printf("\n");
			}
			break;
		default:
			result = NOTIMPL_ERR;
			break;
	}
	return result;

}


error_t clip(sint32_t oax, sint32_t oay, sint32_t nax, sint32_t nay,
             sint32_t obx, sint32_t oby, sint32_t nbx, sint32_t nby,
             sint32_t scanx, sint32_t scany, Clip *c)
{
	if(NULL == c) return NULLPTR_ERR;

	c->casus   = 0x0000000L;
	c->scanx   = scanx;
	c->scany   = scany;
	c->ojmp    = 0;
	c->sjmp    = 0;
	c->nax     = nax;
	c->nbx     = nbx;
	c->oax     = oax;
	c->obx     = obx;
	c->ncx     = 0;
	c->ocx     = 0;
	c->nay     = nay;
	c->nby     = nby;
	c->oay     = oay;
	c->oby     = oby;
	c->ncy     = 0;
	c->ocy     = 0;

	/* explaining code ...
	ax1 = oax + 1;
	ax2 = oax + nax;
	bx1 = obx + 1;
	bx2 = obx + nbx;
	x1 = MMAX(ax1,bx1);
	x2 = MMIN(ax2,bx2);
	ocx = x1 - 1;
	ncx = x2 - x1 + 1;
	*/
	c->ocx = MAXM(oax, obx);
	c->ncx = MINM(oax + nax -1, obx + nbx - 1) - c->ocx + 1;
	if(c->ocx - c->obx || c->ncx - c->nbx) {
		c->casus |= CLIP_AFFECTED | CLIP_AFFECTED_X;
		if(c->ncx < 1) {
			c->casus |= CLIP_ILLEGAL | CLIP_ILLEGAL_X;
			return ILLEGAL_CLIP_BINA_ERR;
		}
	}
	c->ocy = MAXM(oay, oby);
	c->ncy = MINM(oay + nay - 1, oby + nby - 1) - c->ocy + 1;
	if(c->ocy - c->oby || c->ncy - c->nby) {
		c->casus |= CLIP_AFFECTED | CLIP_AFFECTED_Y;
		if(c->ncy < 1) {
			c->casus |= CLIP_ILLEGAL | CLIP_ILLEGAL_Y;
			return ILLEGAL_CLIP_BINA_ERR;
		}
	}
	c->ojmp = (size_t)(c->ocy*scanx + c->ocx);
	c->sjmp = (size_t)(scanx - c->ncx + 1);
	return NO_ERROR;
}


error_t bin_conv(void *s, size_t size, void *t, int_t stype, int_t ttype)
{
	error_t result;
	size_t i;
	uint8_t   *au8,   *bu8;
	uint16_t  *au16,  *bu16;
	uint32_t  *au32,  *bu32;
	sint32_t  *as32,  *bs32;
	float_t   *af,    *bf;
	double_t  *ad,    *bd;

	result = NO_ERROR;
	switch(stype) {
		case UINT16_T:
			switch(ttype) {	
				case UINT16_T:
					au16 = (uint16_t *)s;
					bu16 = (uint16_t *)t;
					for(i=0; i<size; i++) {
						*bu16 = *au16;
						au16++;bu16++;
					}
					break;
				case UINT32_T:
					au16 = (uint16_t *)s;
					bu32 = (uint32_t *)t;
					for(i=0; i<size; i++) {
						*bu32 = (uint32_t)*au16;
						au16++;bu32++;
					}
					break;
				case SINT32_T:
					au16 = (uint16_t *)s;
					bs32 = (sint32_t *)t;
					for(i=0; i<size; i++) {
						*bs32 = (sint32_t)*au16;
						au16++;bs32++;
					}
					break;
				case FLOAT_T:
					au16 = (uint16_t *)s;
					bf = (float_t *)t;
					for(i=0; i<size; i++) {
						*bf = (float_t)*au16;
						au16++;bf++;
					}
					break;
				case DOUBLE_T:
					au16 = (uint16_t *)s;
					bd = (double_t *)t;
					for(i=0; i<size; i++) {
						*bd = (double_t)*au16;
						au16++;bd++;
					}
					break;
				default:
					result = NOT_IMPL_BINA_ERR;
					break;
			}
			break;
		case UINT8_T:
			switch(ttype) {	
				case UINT16_T:
					au8 = (uint8_t *)s;
					bu16 = (uint16_t *)t;
					for(i=0; i<size; i++) {
						*bu16 = *au8;
						au8++;bu16++;
					}
					break;
				case UINT32_T:
					au8 = (uint8_t *)s;
					bu32 = (uint32_t *)t;
					for(i=0; i<size; i++) {
						*bu32 = (uint32_t)*au8;
						au8++;bu32++;
					}
					break;
				case SINT32_T:
					au8 = (uint8_t *)s;
					bs32 = (sint32_t *)t;
					for(i=0; i<size; i++) {
						*bs32 = (sint32_t)*au8;
						au8++;bs32++;
					}
					break;
				case FLOAT_T:
					au8 = (uint8_t *)s;
					bf = (float_t *)t;
					for(i=0; i<size; i++) {
						*bf = (float_t)*au8;
						au8++;bf++;
					}
					break;
				case DOUBLE_T:
					au8 = (uint8_t *)s;
					bd = (double_t *)t;
					for(i=0; i<size; i++) {
						*bd = (double_t)*au8;
						au8++;bd++;
					}
					break;
				default:
					result = NOT_IMPL_BINA_ERR;
					break;
			}
			break;
		case SINT32_T:
			switch(ttype) {	
				case FLOAT_T:
					as32 = (sint32_t *)s;
					bf = (float_t *)t;
					for(i=0; i<size; i++) {
						*bf = (float_t)*as32;
						as32++;bf++;
					}
					break;
				case DOUBLE_T:
					as32 = (sint32_t *)s;
					bd = (double_t *)t;
					for(i=0; i<size; i++) {
						*bd = (double_t)*as32;
						as32++;bd++;
					}
					break;
				default:
					result = NOT_IMPL_BINA_ERR;
					break;
			}
			break;
		default:
			result = NOT_IMPL_BINA_ERR;
			break;
	}
	return result;
}
