/****************************************************************************
*   @(#)spec_shm.h	4.4 06/09/97 CSS
*
*   "Spec" Release 4
*
*   Copyright (c) 1995,1996,1997
*   by Certified Scientific Software.
*   All rights reserved.
*   Copyrighted as an unpublished work.
*
****************************************************************************/

#define SHM_MAGIC       0xCEBEC000
#define SHM_VERSION     3

/* structure types */
#define SHM_IS_STATUS   0x0001
#define SHM_IS_ARRAY    0x0002
#define SHM_IS_MCA      (0x0004|SHM_IS_ARRAY)
#define SHM_IS_IMAGE    (0x0008|SHM_IS_ARRAY)

/* array data types */
#define SHM_DOUBLE      0
#define SHM_FLOAT       1
#define SHM_LONG        2
#define SHM_ULONG       3
#define SHM_SHORT       4
#define SHM_USHORT      5
#define SHM_CHAR        6
#define SHM_UCHAR       7
#define SHM_STRING      8

#define NAME_LENGTH     32
#define SHM_HEAD_SIZE   1024

struct  shm_head {
	long    magic;                  /* magic number (SHM_MAGIC) */
	long    type;                   /* one of the array data types */
	long    version;                /* version number of this struct */
	long    rows;                   /* number of rows of array data */
	long    cols;                   /* number of cols of array data */
	long    utime;                  /* last-updated counter */
	char    name[NAME_LENGTH];      /* name of spec variable */
	char    spec_version[NAME_LENGTH];      /* name of spec process */
	long    shmid;                  /* shared mem ID */
	long    flags;                  /* more type info */
	long    pid;                    /* process id of spec process */
};

struct  shm_status {
	unsigned long   spec_state;
	/* more later */
};

struct shm_header {
	union {
		struct  shm_head head;
		char    pad[SHM_HEAD_SIZE];
	} head;
	void    *data;
};
