/*
Update 08/11/2001 R. Wilcke (wilcke@esrf.fr)
                  add declarations for functions set_inpmin() and set_inpmax().
Update 05/11/2001 R. Wilcke (wilcke@esrf.fr)
                  add 2 more new arguments to the declaration of azim_int().
Update 22/10/2001 R. Wilcke (wilcke@esrf.fr)
                  add 3 new input arguments to azim_int() declaration.
Update 18/10/2001 R. Wilcke (wilcke@esrf.fr)
                  add declarations for normint_im() and azim_int().
Update 03/10/2001 R. Wilcke (wilcke@esrf.fr)
                  change last argument in the declaration of save_esrf_file()
                  from "char *" to "int".
Update 02/10/2001 R. Wilcke (wilcke@esrf.fr)
                  remove the last two arguments from the declaration of
                  save_esrf_file().
Update 13/09/2001 R. Wilcke (wilcke@esrf.fr)
                  changed type of member "init" in structure "data_head" from
                  "short" to "unsigned short".
Update 20/08/2001 R. Wilcke (wilcke@esrf.fr)
                  add declaration for function get_headval();
Update 17/08/2001 R. Wilcke (wilcke@esrf.fr)
                  changed value of SPDTYP from -1 to 6;
                  added declarations of flags for the data_head members;
                  add member "WaveLeng" to structure "data_head" and define
                  corresponding flag.
Update 14/08/2001 R. Wilcke (wilcke@esrf.fr)
                  add new image type macro SPDTYP;
                  add new input argument of type "int" in 5th position to
                  read_esrf_file().
Update 13/08/2001 R. Wilcke (wilcke@esrf.fr)
                  change type of set_headval() from "void" to "int" and add
                  a second input argument;
                  add definitions for the macros SRCTYP, CORTYP, BKGTYP, FLOTYP,
                  NO_TYP and SCATYP for the image types.
Update 07/08/2001 R. Wilcke (wilcke@esrf.fr)
                  declare new routine set_scaim();
                  add fourth input argument to subtract_im().
Update 03/08/2001 R. Wilcke (wilcke@esrf.fr)
                  declare new routines set_normint() and set_headval();
                  include <string.h>;
                  added definition of structure data_head.
Update 28/06/2001 R. Wilcke (wilcke@esrf.fr)
                  change declaration of routine correct_image() by eliminating
                  the background and floodfield image from the input arguments;
                  declare new routines set_bkgim() and set_floim().
Update 26/06/2001 R. Wilcke (wilcke@esrf.fr)
                  declare new function set_xycorout().
Update 25/06/2001 R. Wilcke (wilcke@esrf.fr)
                  move declaration of "verbose" to "correct.c";
                  declare new functions set_verbose(), set_overflow(),
                  set_dummy(),set_actrad(),set_splinfil(),set_xycorin(),
                  set_xysize(),get_xsize(),get_ysize(),set_bkgconst(),
                  set_doflat(), set_dolater(), set_dospd().
Update 11/05/2001 R. Wilcke (wilcke@esrf.fr)
                  remove declaration of gethead() routine - no longer used.
Update 02/02/2001 R. Wilcke (wilcke@esrf.fr)
                  change all arguments of divide_insito_im() and divide_im()
                  to type "float";
                  change name of substract_im() to subtract_im() and make all
                  arguments of type "float".
                  change all "unsigned short" arguments of mark_overflow() and
                  mark_overflow_nocorr() to type "float";
                  change all "unsigned short" arguments of corr_calc() to type
                  "float";
                  remove declaration of corr_calc_plus();
                  remove definitions of HALFSCALE and FLO_SHIFT;
                  change all "unsigned short" arguments of correct_image() to
                  type "float";
                  change member *temp_im of struct lut_descript to type "float";
Update 18/01/2001 R. Wilcke (wilcke@esrf.fr)
                  removed declaration of pxcorr();
                  changed parameter types of pxcorrgrid() and readarray() from
                  "double" to "float".

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h> 
#include <varargs.h>
#ifdef SYSTIME
#include <sys/time.h>
#else
#include <time.h>
#endif
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include <sys/shm.h>
#include <sys/ipc.h> 
#include <sys/types.h>

#include <edfio.h>
#include <SaxsDefinition.h>
//#include "spec_shm.h"

extern int errno;

#if SOLARIS 
#define UNDERSCORE 1 
#endif

#if LINUX
#define UPPERCASE 1
#endif

#define USE_OFFSET_TAB 0
#define LOW_MEM 0
#define WASTE4_FORSPEED 1  /* This flag needs to be on if you want to read in
			      x and y distortion from a edf file */
#if defined(NONSENS)
#endif
#define WASTE2_FORSRCTEMP 1
#define KEEP_COUNTS 1
#define TEMP_LONG 1
#define LUT_BYTE 0
#define MY_MALLOC 0
#define BOUND_CHECK 1
#define BOUND_SUPER 0


#define MAX_PIXELSIZE 6 
#define MAX_TRIANGLES 1000
#define MAX_PARTS 200
#define VALUES_PERLINE 5

#define MSG 0
#define WARNING 1
#define ERROR 2
#define FATAL 3
#define DMSG 4

#define INCTARGET 1
#define ABSSRC 2
#define UNCOMPRESSED 4
#define PROGEND 8
#define MULTIINC 16

#if LUT_BYTE
#define LUT_TYPE unsigned char
#define FULLSCALE 0x80
#define SHIFT 7
#define MAPSCALE 0x7f
#define BITMASK 0x80
#else
#define LUT_TYPE unsigned short
#define FULLSCALE 0x8000
#define SHIFT 15
#define MAPSCALE 0x7fff
#define BITMASK  0x8000
#endif

#define MAXHIST (1<<18)
#define RELTABSIZE 32
#define TEMP_BUF_SIZE (0x10000 * sizeof(short*))

/*
 * Define the image types:
 * SRCTYP  for the source image
 * CORTYP  for the corrected image
 * BKGTYP  for the background image
 * FLOTYP  for the floodfield image
 * NO_TYP  for the header buffer handed over online (this is a temporary kludge)
 * SCATYP  for the scattering background image
 * SPDTYP  for the spatial distortion correction displacement values
 */
#define SRCTYP 0
#define CORTYP 1
#define BKGTYP 2
#define FLOTYP 3
#define NO_TYP 4
#define SCATYP 5
#define SPDTYP 6

struct lut_descript {
  LUT_TYPE *lut;
  unsigned char *prog;
  int prog_length;
  unsigned int starttidx;
  unsigned int startsidx;
  int *offset_tab;
  int *rel_tab;
  int **relend_tab;
  unsigned short *abs_src;
  float *temp_im;
  int maxxpixel;
  int maxypixel;
  short *xrel;
  short *yrel;
};

struct triangle {
  float x[3];
  float y[3];
  float area;
  int xpos;
  int ypos;
};

/*
 * Declaration of structure for the user data header, and the flags to indicate
 * whether a particular member of the structure has been initialized.
 *
 * The flags will be "OR"ed into the "init" member.
 */
#define FL_ORIEN 0x0001
#define FL_DUMMY 0x0002
#define FL_DDUMM 0x0004
#define FL_OFFS1 0x0008
#define FL_OFFS2 0x0010
#define FL_PSIZ1 0x0020
#define FL_PSIZ2 0x0040
#define FL_INTE0 0x0080
#define FL_INTE1 0x0100
#define FL_CENT1 0x0200
#define FL_CENT2 0x0400
#define FL_SAMDS 0x0800
#define FL_WAVLN 0x1000

struct data_head {
  unsigned short init;
  short Orientat;
  float Dummy;
  float DDummy;
  float Offset_1;
  float Offset_2;
  float PSize_1;
  float PSize_2;
  float Intens_0;
  float Intens_1;
  float Center_1;
  float Center_2;
  float SamplDis;
  float WaveLeng;
};

#if MY_TIMEVAL
struct timeval {
  unsigned long	tv_sec; 	/* seconds */
  long		tv_usec; 	/* and microseconds */
};

struct timezone {
  int	tz_minuteswest; 	/* minutes west of Greenwich */
  int	tz_dsttime; 		/* type of dst correction */
};
#endif

/*
 * The macros "prmsg()" and "__prmsg()" handle the printing of user-defined
 * messages. The actual file name and line number may be added to the user's
 * message.
 *
 * The macros work by calling the function "_prmsg()". For more details, see  
 * the corresponding description.
 *
 * The input parameter that contains the message to print must contain a full
 * print argument list, i.e. the format statement, the variables to print, and
 * the surrounding parentheses! Example for a valid prmsg() call:
 *
 *   prmsg(ERROR,("Cannot read <%s> (open failed)\n",filename));
 *
 * "prmsg" will use the file name and line number corresponding to the location
 * from where it was called. "__prmsg" allows these to be given as parameters.
 * This can be useful, e.g. if the macro is used inside a service function, and
 * the important information is not the location in the service function, but
 * the location where this service function was called.
 *
 * Macro prmsg:
 * Input : N: message type
 *         M: message to print
 * Output: none
 * Return: none
 *
 * Macro __prmsg:
 * Input : N: message type
 *         M: current file name
 *         L: current line number
 *         K: message to print
 * Output: none
 * Return: none
 */
#define prmsg(N,M)  do{_prmsg(NULL,N,__FILE__,__LINE__); _prmsg M; } while(0)
#define __prmsg(N,M,L,K)  do{_prmsg(NULL,N,M,L); _prmsg K; } while(0)

#if MY_MALLOC
/*
 * If MY_MALLOC is defined, an alternative set of routines for memory
 * management is used. The following routines are defined:
 *
 * - pmalloc(), prealloc(), pfree() replace the standard routines malloc(),
 *   realloc() and free();
 * - print_memsize() prints the total allocated memory size.
 *
 * The differences to the standard routines are:
 * - the alternative set provides error printout indicating the current file
 *   and line number where the error occurred;
 * - the alternative set operates on a linked list of data structures of type
 *   "pmem". Each structure contains the size of its data segment, a pointer to
 *   the next element in the list, and a pointer to its own data segment. This
 *   allows to keep track of the overall memory usage by the program with the
 *   routine print_memsize().
 *
 * Otherwise, the input parameters and return values of the routines in the
 * alternative set are the same as the ones in the standard set.
 *
 * If MY_MALLOC is not defined, pmalloc(), prealloc() and pfree() are defined 
 * to be the standard set of memory management routines, and print_memsize()
 * is a dummy.
 */

struct pmem {
  void *data;            /* data segment */
  long int size;         /* size of the data segment */
  struct pmem *next;     /* pointer to next structure in linked list */
  void *fill128;         /* align the return ptr again on 16 byte boundary*/
};

#define pmalloc(N) _pmalloc(N,__FILE__,__LINE__)
#define prealloc(N,M) _prealloc(N,M,__FILE__,__LINE__)
#define pfree(N) _pfree(N,__FILE__,__LINE__)

#else 
#define pmalloc malloc
#define pfree free
#define prealloc realloc
#endif /* MY_MALLOC */

/*
 * Function Prototypes
 */
int get_headval(struct data_head *,int);
int get_xsize(void);
int get_ysize(void);
void set_actrad(float);
void set_bkgconst(float);
void set_bkgim(void *);
void set_doflat(int);
void set_dolater(int);
void set_dospd(int);
void set_dummy(float);
void set_floim(void *);
int set_headval(struct data_head,int);
void set_inpmax(float);
void set_inpmin(float);
void set_normint(int);
void set_overflow(unsigned short);
void set_scaim(void *);
void set_splinfil(char *);
void set_verbose(int);
void set_xycorin(char *,char *);
void set_xycorout(char *,char *);
void set_xysize(int,int);
void _prmsg();     
struct lut_descript *lut_calc();
void *_pmalloc(int size,char *file,int line);
void *_prealloc(void *ptr,int size,char *file,int line);
int _pfree(void *ptr,char *file,int line);
int print_memsize(void);
char *myfgets(FILE* fp);
struct spd_spline *loadspdfile(char *filename);
int findkeyword(FILE *fp,char *keyword);
int readarray(FILE *fp,int no,float *arr);
int unloadspd(struct spd_spline *spline);
int pxcorrgrid(struct spd_spline *spline,int nox,int noy,
  float px[],float py[],float dx[],float dy[]);
int trianglecutv_only(struct triangle *in_tri,float v,
  struct triangle new_triangles[],int *no_new);
int trianglecuth_only(struct triangle *in_tri,float v,
  struct triangle new_triangles[],int *no_new);
int area_only(float *x,float *y,float *area);
int triangle_cutall(struct triangle triangles[],int *n,int *ixmin,
  int *ixmax,int *iymin,int *iymax);
int calcparts(float x[],float y[],int debug,float parts[],int *txmin,
  int *txmax,int *tymin,int *tymax,float *total);
int debugout(struct triangle triangles[],int no_tri,float total,
  float parts[],int xmin,int xmax,int ymin,int ymax);
int pxtomm(float *px,float *py,float *mmx,float *mmy);
int loadspd(char *filename,float *xcenter,float *ycenter,int *res,int dummy);
int andy_corr(float **cor_x,float **cor_y,int x0,int x1,int y0,int y1);
int andy_free_buffers(float *cor_x,float *cor_y);
int make_grid(unsigned short *image,float height,float width,int distorted);
int byte_swap2N();
int my_func(int ix,int iy,float *resx,float *resy);
int correct_image(float *,float *);
int subtract_im(float *,float *,float *,float);
int divide_insito_im(float *,float *);
int divide_im(float *,float *,float *);
int normint_im(float *,float *);
int mark_overflow(float *,float *,struct lut_descript *,float);
int mark_overflow_nocorr(float *,float *);
int azim_int(float *,float *,float,float,float,float,float);
int corr_calc(float *,float *,struct lut_descript *);
int minmax4(float f1,float f2,float f3,float f4,float *p_minf,float *p_maxf);
int histcompare_count(const void *el1,const void *el2);
int histcompare_idx(const void *el1,const void *el2);
int debug_print(unsigned char *,LUT_TYPE *,unsigned short *,int,int,int,int,
  int);
struct shm_header *getShmPtr(int id,int delete);
int user_code(int argc,char *argv[]);
int scan_argument(char *,char *,char *,void *);
int prepare_flood(unsigned short *,float *);
int get_buffer(int,char *,void **,int);
int put_buffer(char *,void **,int);
int clean_buffer(void **,int,int);
char *outname(char *,char *,char *);
int analyse_args(int argc,char *argv[],char * progname);
int save_esrf_file(char *,void *,int,int,int,char *,int);
int read_esrf_file(char *,void **,int *,int *,int,int,int *);
int bench(char *);
int despair(unsigned char *lut_prog,LUT_TYPE *lut_tab,int prog_length);
