#include "spd.h"
#include "Python.h"
#include "Numeric/arrayobject.h"

static struct data_head img_head;


static PyObject *
saxs_set_pixelsize(PyObject *self, PyObject *args)
{
  float psize_1, psize_2;

  if (!PyArg_ParseTuple(args, "ff", &psize_1, &psize_2))
    return NULL;
  
  img_head.PSize_1 = psize_1;
  img_head.init   |= FL_PSIZ1;
  img_head.PSize_2 = psize_2;
  img_head.init   |= FL_PSIZ2;
  
  set_headval(img_head, CORTYP);

  return Py_None;
}

static PyObject *
saxs_set_offset(PyObject *self, PyObject *args)
{
  float offset_1, offset_2;

  if (!PyArg_ParseTuple(args, "ff", &offset_1, &offset_2))
    return NULL;
  
  img_head.Offset_1 = offset_1;
  img_head.init   |= FL_OFFS1;
  img_head.Offset_2 = offset_2;
  img_head.init   |= FL_OFFS2;
  
  set_headval(img_head, CORTYP);

  return Py_None;
}


static PyObject *
saxs_set_center(PyObject *self, PyObject *args)
{
  float center_1, center_2;

  if (!PyArg_ParseTuple(args, "ff", &center_1, &center_2))
    return NULL;
  
  img_head.Center_1 = center_1;
  img_head.init    |= FL_CENT1;
  img_head.Center_2 = center_2;
  img_head.init    |= FL_CENT2;
  
  set_headval(img_head, CORTYP);

  return Py_None;
}



static PyObject *
saxs_azim_int(PyObject *self, PyObject *args)
{
  PyArrayObject *inData, *outData;
  float  r0, re, a0, ae, da;
  int dimOutData[2], status;

  printf("DEBUG: In saxs_azim_int\n");

  if (!PyArg_ParseTuple(args,"OOfffff",
			&inData, &outData, &r0, &re, &a0, &ae, &da))
      return NULL;

  printf("DEBUG: args = %f, %f, %f, %f, %f\n", r0, re, a0, ae, da);
  printf("DEBUG: nd = %d, type_num = %d\n", inData->nd, inData->descr->type_num);
  printf("DEBUG: dims = %d, %d\n", inData->dimensions[0],inData->dimensions[1]);

  set_xysize(inData->dimensions[0],inData->dimensions[1]);

  if (inData->nd !=2 || inData->descr->type_num != PyArray_FLOAT) 
  {
    PyErr_SetString(PyExc_ValueError, "array inData must be of type float");
    return NULL;
  }
  /*
  dimOutData[0] = (int)(re - r0 + 1);
  dimOutData[1] = (int)( (ae - a0)/da );

  dimOutData[0] = 1000;
  dimOutData[1] = 1000;

  printf("DEBUG: dims = (%d,%d)\n", dimOutData[0], dimOutData[1]);

  //  outData = (PyArrayObject *)PyArray_FromDims(2, dimOutData, PyArray_FLOAT);

  printf("DEBUG: dims = (%d,%d)\n", dimOutData[0], dimOutData[1]);
  */
  status = azim_int((float*)(inData->data), 
                    (float*)(outData->data),
		    r0, re, a0, ae, da);

  return Py_None;
}


static PyMethodDef SaxsMethods[]={
  {"azim_int", (PyCFunction)saxs_azim_int, METH_VARARGS},
  {"set_pixelsize", (PyCFunction)saxs_set_pixelsize, METH_VARARGS},
  {"set_offset", (PyCFunction)saxs_set_offset, METH_VARARGS},
  {"set_center", (PyCFunction)saxs_set_center, METH_VARARGS},
  {NULL,NULL}
};

void initsaxs()
{
  (void) Py_InitModule("saxs", SaxsMethods);
}
