/*+++
1 saxs_aff
  Affine transformation of an image sequence

2 PURPOSE
  Affine transformation of an image sequence

  Arguments:
  saxs_aff [options] <i1nam> <onam> <i1fst> <i1lst> <i1inc> 
             <odum> <odim1> <odim2> <ofac> <ocon> <shft1> <shft2>"

  Defaults:
  <input file name>   : input.edf 
  <output file name>  : output.edf
  <first image>       : <first image number in input file>
  <last image>                              : <last image number in input file>
     if argument list ends with first image : <first image>
  <increment>         : 1
  <dummy>             : <dummy value in first image of input file>
  <dimension 1>       : <horizontal dimension of first image in input file>
  <dimension 2>       : <vertical dimension of first image in input file>
  <output const>      : 0.0
  <output factor>     : 1.0
  <horizontal shift>  : 0.0
  <vertical shift>    : 0.0

  Wildcard:
  A "=" in the argument list chooses the default.

2 HISTORY
  1999-12-27 V3.0  PB from saxs_mac V3.12
  2000-01-10 V3.01 PB prompting changed
  2000-08-04 V3.01 PB %f->%g
  2001-07-09 V4.00 PB new loop, no repetition

---*/
# define Version  "saxs_aff V4.00 2000-07-09, Peter Boesecke"

# include <errno.h>
# include <stdio.h>
# include <unistd.h>
# include <fcntl.h>

# include "SaxsPrograms.h"

# define Usage "[options] \n\
                <i1nam> <onam> <i1fst> <i1lst> <i1inc> \n\
                <odum> <odim1> <odim2> \n\
                <t00> <t01> <t10> <t11> <t20> <t21>\n\
          --- Affine transformation of an image sequence --- "

# define BlockNum 2       /* 1 input sequence + 1 output sequence */

/* Float Options */
enum { ArgT00=0, ArgT10,  ArgT20,  ArgT01,  ArgT11,  ArgT21  };

/*---------------------------------------------------------------------------
1 saxs_aff

2 PURPOSE
  Multiplicates an image with a factor and adds a constant
---------------------------------------------------------------------------*/
void saxs_aff (CmdBlk * pcb, ImgHeadBlk ihb[], int * pstatus)
{ int i,j,k;
  int imax = pcb->ImgBlkLen;
  double t[3][2];

  *pstatus = Success;

  printf("\n Calculating ihb[0,% d] = Function(",ihb[0].ImNum);
  for(i=1;i<imax;i++) printf("ihb[% d,% d] ", i, ihb[i].ImNum); 
  printf(")\n\n");

 /* Check the number of images */
  if (imax!=2) {
     printf("%d images found, 1 input and 1 output image required\n", imax);
     *pstatus=Failed; return; }

  /* generate transformation matrix */
  t[0][0] = (double) pcb->Arg[ArgT00].V;
  t[1][0] = (double) pcb->Arg[ArgT10].V;
  t[2][0] = (double) pcb->Arg[ArgT20].V;
  t[0][1] = (double) pcb->Arg[ArgT01].V;
  t[1][1] = (double) pcb->Arg[ArgT11].V;
  t[2][1] = (double) pcb->Arg[ArgT21].V;

  if (pcb->TestBit) {
    for (k=0;k<2;k++) for (j=0;j<3;j++)
        printf("t[%d][%d] = %g\n",j,k,t[j][k]);
    }

  Affine (  pcb, ihb, 1, 0, t, pstatus );
  if (*pstatus!=Success) return;

 } /* saxs_aff*/

/*---------------------------------------------------------------------------
user_io
Do all the keyboard io and return cb, and ib
---------------------------------------------------------------------------*/

void user_io(CmdBlk * pcb, ImgBlk * ib, int * pstatus)
{
  char  progfn[InputLineLength];
  ImgHeadBlk ihb[BlockNum];

  float ROff_1, RPs_1, UOff_1, UPs_1;
  float ROff_2, RPs_2, UOff_2, UPs_2;

 /* Determine program name without directory */
   (void) RightFR((char *) pcb->argv[0],DirSeparator,progfn,InputLineLength);

  /* show usage if no arguments are given */
  if (pcb->argc<=1) printf("Usage: %s %s\n",progfn,Usage);

  /*--- Write name of program ---*/
  printf("\n");
  printf("   %s %s\n",progfn,Version);
  printf("\n");

  ArgvFilenames ( pcb, ib, ihb, 0, BlockNum-1, pstatus);
  if (*pstatus!=Success) return;
  GetReference(pcb->RSys.V,1,ihb,&ROff_1,&ROff_2,&RPs_1,&RPs_2,pstatus );
  if (*pstatus!=Success) return;
  GetReference(pcb->USys.V,1,ihb,&UOff_1,&UOff_2,&UPs_1,&UPs_2,pstatus );
  if (*pstatus!=Success) return;

  /*--- Argument : T00 to T21 */
  if (pcb->Prompt.V) {
    printf("\n");
    printf("                  ( T00, T10 )       ( T20 )\n");
    printf(" T = (A,B) :  A = |          | ; B = |     |\n");
    printf("                  ( T01, T11 )       ( T21 )\n");
    printf("\n");
    printf(" W' = A * W + B\n");
    printf(" with coordinates W (input image), W' (output image)\n");
    printf("\n");
    } /* if */

  argv_float(pcb,"T00", &pcb->Arg[ArgT00],pcb->Arg[ArgT00].V,pstatus);
  if (*pstatus!=Success) return;
  argv_float(pcb,"T01", &pcb->Arg[ArgT01],pcb->Arg[ArgT01].V,pstatus);
  if (*pstatus!=Success) return;
  argv_float(pcb,"T10", &pcb->Arg[ArgT10],pcb->Arg[ArgT10].V,pstatus);
  if (*pstatus!=Success) return;
  argv_float(pcb,"T11", &pcb->Arg[ArgT11],pcb->Arg[ArgT11].V,pstatus);
  if (*pstatus!=Success) return;
  argv_float(pcb,"T20", &pcb->Arg[ArgT20],pcb->Arg[ArgT20].V,pstatus);
  if (*pstatus!=Success) return;
  argv_float(pcb,"T21", &pcb->Arg[ArgT21],pcb->Arg[ArgT21].V,pstatus);
  if (*pstatus!=Success) return;

  printf("\n");
  if (ib[1].Name.I)    printf("i/p file           : %s\n",ib[1].Name.V);
  if (ib[0].Name.I)    printf("o/p file           : %s\n",ib[0].Name.V);
  if (ib[1].First.I)   printf("first image        : %d\n",ib[1].First.V);
  if (ib[1].Last.I)    printf("last image         : %d\n",ib[1].Last.V);
  if (ib[1].Inc.I)     printf("increment          : %d\n",ib[1].Inc.V);
  if (ib[0].Dummy.I)   printf("output dummy       : %g\n",ib[0].Dummy.V);
  if (ib[0].Dim[1].I)  printf("output dimension 1 : %d\n",ib[0].Dim[1].V);
  if (ib[0].Dim[2].I)  printf("output dimension 2 : %d\n",ib[0].Dim[2].V);
  if (pcb->Arg[ArgT00].I)
                       printf("T00                : %g\n",pcb->Arg[ArgT00].V);
  if (pcb->Arg[ArgT01].I)
                       printf("T01                : %g\n",pcb->Arg[ArgT01].V);
  if (pcb->Arg[ArgT10].I)
                       printf("T10                : %g\n",pcb->Arg[ArgT10].V);
  if (pcb->Arg[ArgT11].I)
                       printf("T11                : %g\n",pcb->Arg[ArgT11].V);
  if (pcb->Arg[ArgT20].I)
                       printf("T20                : %g\n",pcb->Arg[ArgT20].V);
  if (pcb->Arg[ArgT21].I)
                       printf("T21                : %g\n",pcb->Arg[ArgT21].V);
  printf("\n");

  if (pcb->TestBit) {
    PrintBlocks ( pcb, ib );
    printf("\n"); }

  return;
}

/*---------------------------------------------------------------------------
main
---------------------------------------------------------------------------*/

main (int argc, char *argv[])
{
  CmdBlk cb;                /* command block  */
  ImgBlk ib[BlockNum];      /* image blocks */

  int status;
  int arg_no = 0;

 /* Init options, control block and image blocks */
  InitOptions( Usage, Version, TRUE, &cb, ib, BlockNum );

  DefFloatOption(&cb,"t00",ArgT00);
  DefFloatOption(&cb,"t10",ArgT10);
  DefFloatOption(&cb,"t20",ArgT20);
  DefFloatOption(&cb,"t01",ArgT01);
  DefFloatOption(&cb,"t11",ArgT11);
  DefFloatOption(&cb,"t21",ArgT21);

 /* Read options from argument list */
  ReadOptions( argv, &arg_no, &cb, ib, &status);
  ReportSaxsStatus( status, &cb.seb, 1 );

 /* Defaults of options */
  if (!cb.Arg[ArgT00].I) cb.Arg[ArgT00].V = 1.0;
  if (!cb.Arg[ArgT10].I) cb.Arg[ArgT10].V = 0.0;
  if (!cb.Arg[ArgT20].I) cb.Arg[ArgT20].V = 0.0;
  if (!cb.Arg[ArgT01].I) cb.Arg[ArgT01].V = 0.0;
  if (!cb.Arg[ArgT11].I) cb.Arg[ArgT11].V = 1.0;
  if (!cb.Arg[ArgT21].I) cb.Arg[ArgT21].V = 0.0;

 /* Keyboard I/O and sequence calculation */

  /* USER KEYBOARD I/O */
  argv_start ( &cb, 1 );
  user_io( &cb, ib, &status);
  argv_end( &cb ); /* must be called after user_io */

  /* SEQUENCE CALCULATION */
  if (status==Success) ImageLoop( &cb, ib, saxs_aff, TRUE, &status );

  if (status==Abort) ReportSaxsStatus( status, &cb.seb, 0 );
    else ReportSaxsStatus( status, &cb.seb, 1 );

  printf("\nEnd of % s\n",argv[0]);

} /* main */

