/***************************************************************************
 *                                                                         *
 * This program takes and ESRF Data Format file and creates a modified one *
 * with the headers padded out to a 512 byte boundary - this means that    *
 * all the data blocks will start at a multiple of 512 bytes. This should  *
 * make it easier to read in.                                              *
 *                                                                         *
 * compile: cc -o boundary boundary.c         (or use replace cc with gcc) *
 *                                                                         *
 * use: bondary input-file [output-file]                                   *
 * where: the input-file name must be given and is the name of an existing *
 *        file to read in.                                                 *
 *        output-file is the name of the file to create - if this is not   
 *        given the input file name is used, all leading directories are   *
 *        stripped and the file extension is changed to '.mod'             *
 *                                                                         *
 * example: boundary ~/myfile.edf                                          *
 *                                                                         *
 * Creates the file myfile.mod in the current directory.                   *
 *                                                                         *
 * There are no command line parameters. It's just a jiffy program ....... *
 *                                                                         *
 * P. J. Daly October 1995                                                 *
 *                                                                         *
 ***************************************************************************/


/***************************************************************************
 * Include Files                                                           *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>

/***************************************************************************
 * Defines                                                                 *
 ***************************************************************************/

#define Boundary      512                      /* word boundary for header */
#define Buffer    1048576                      /* size of the input buffer */
#define EXTN       ".mod"       /* default file extension for created file */
#define EndMarker     '}'                          /* end of header marker */
#define Search "headerid"                    /* search string for a header */
#define Length          8             /* length of the search string above */

/***************************************************************************
 * Global Un-initialised Variables                                         *
 ***************************************************************************/

char OutFileName[Buffer], Out[Buffer + Length];

int CheckBlock (int Start, int Size)
{
  int  i;
  char str[1 + Length];

  while (Start < Size) {
    if (Out[Start] == 'h' || Out[Start] == 'H') {
      (void) strncpy (str, &Out[Start], Length);
      for (i = 0; i < Length; i++) str[i] = tolower (str[i]);
      str[Length] = (char) NULL;
      if (! strcmp (str, Search)) return (Start);
    }
    Start++;
  }
  return (-1);
}

void CreateFileName (char *Input)
{
  char *s1;

  if ((s1 = strrchr (Input, '/')) == (char *) NULL)
    s1 = Input;
  else
    s1++;
  (void) strcpy (OutFileName, s1);

  if ((s1 = strrchr (OutFileName, '.')) == (char *) NULL){
    (void) strcat (OutFileName, EXTN);
  } else {
    (void) strcpy (s1, EXTN);
  }
  (void) strcat (OutFileName, "\0");
}

/***************************************************************************
 * Main Program                                                            *
 ***************************************************************************/

main (int argc, char *argv[])
{
  int   i, k, pos, found;
  long  int j;
  FILE *in, *out;
  char  str[1 + Length];

  if (! --argc) {
    (void) printf ("Usage: %s input-file [output-file]\n", argv[0]);
    exit (1);
  }

  if ((in = fopen (argv[1], "rb")) == (FILE *) NULL) {
    (void) printf ("%s: cannot open input file \"%s\"\n", argv[0], argv[1]);
    exit (2);
  }

  if (argc == 1)
    CreateFileName (argv[1]);
  else
    (void) strcpy (OutFileName, argv[2]);

  if ((out = fopen (OutFileName, "wb")) == (FILE *) NULL) {
    (void) printf ("%s: cannot open output file \"%s\"\n",
                   argv[0], OutFileName);
    exit (2);
  }

  (void) fread (Out, 1, Length, in);
  while (! feof (in)) {
    i = fread (&Out[Length], 1, Buffer, in);
    pos = 0;
    while (pos < i) {
      k = CheckBlock (pos, i);
      if (k == -1) break;
      found = 0;
      while (! found) {
        while (k < i && Out[k] != EndMarker) k++;
        if (Out[k] == EndMarker) found = 1;
        if (k == i) {
          (void) fwrite (&Out[pos], 1, k - pos, out);
          for (k = 0; k < Length; k++) Out[k] = Out[Buffer + k];
          i = fread (&Out[Length], 1, Buffer, in);
          pos = k = 0;
        }
      }
      (void) fwrite (&Out[pos], 1, k - pos, out);
      (void) fflush (out);
      j = ftell (out);
      if ((j + 2) % Boundary) 
        (void) fprintf (out, "%*s", Boundary - (j % Boundary) - 2, "");
      (void) fflush (out);
      pos = k;
    }
    (void) fwrite (&Out[pos], 1, i - pos, out);
    for (k = 0; k < Length; k++) Out[k] = Out[Buffer + k];
  }
  (void) fwrite (Out, 1, Length, out);
  (void) fclose (in);
  (void) fclose (out);

  return (0);
}
