/*+++***********************************************************************
NAME

    schultz.h

SYNOPSIS

    #include "schultz.h"

DESCRIPTION
    Header of the module "schultz.c". 
***********************************************************************---*/
#ifndef _SCHULTZ_
# define _SCHULTZ_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
#  define PRIVATE static // used to declare variables of private type 
#endif

#ifndef PUBLIC
#  define PUBLIC         // used to declare variables of public type 
#endif

/****************************************************************************
*  Include                                                                  *
****************************************************************************/

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

# include "gamma.h"

/***************************************************************************
* Functions                                                                *
***************************************************************************/

PUBLIC extern double 
    // Schultz distribution
       schultz( double R, double Z, double X ), 
    // sqrt(<R^2>-<R>^2)
       sigma_schultz( double R, double Z ), 
    // <R^2>
       R2_schultz( double R, double Z ),
    // <R^3>
       R3_schultz( double R, double Z ),
    // Average form factor of spheres following a Schultz distribution
       f2_schultz( double Z, double qR );


#endif
