/*+++***********************************************************************
NAME

    gauss.h

SYNOPSIS

    #include "gauss.h"

DESCRIPTION
    Header of the module "gauss.c"
***********************************************************************---*/
#ifndef _GAUSS_
# define _GAUSS_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
# define PRIVATE       static /* used to declare variables of private type */
# define PUBLIC                /* used to declare variables of public type */
#endif

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <ctype.h>
# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

/***************************************************************************
* Functions                                                                *
***************************************************************************/

PUBLIC extern double

       Gauss ( double x, double sigma ),       // gaussian normal distribution
       IntGauss ( double x, double sigma ),    // integral of gaussian
       InvIntGauss ( double y, double sigma ), // inverse integral
       GaussNoise( double sigma );             // creates gaussian noise

PUBLIC extern void 
       GaussNoiseSeed( unsigned int seed ),    // set random number seed
       GaussDebug( int mode );                 // 0: no debug mode, 1: debug 

#endif
