/*+++***********************************************************************
NAME

    edfio.h 

SYNOPSIS

    #include "edfio.h"

DESCRIPTION
    Header of the module "edfio.c"

HISTORY 
    17-Mar-1998 Peter Boesecke
    16-May-1998 PB INTERNAL_BYTE_ORDER, data_sizeof
    01-Jun-1998 PB set_bsl_input_byteorder
    18-Apr-1999 PB all public routines start with edf_ or edfio_
    30-Apr-1999 PB new routine edf_read_data_2d_raw
    23-Jun-1999 PB Restrictions (PUBLIC)
    24-Jun-1999 PB module HISTORY added, restriction again only private
    26-Jun-1999 PB History_Line changed to Header_Symbol_List (HSymb)
    23-Jul-1999 PB call to edf_read_data_2d_raw and edf_write_data_2d_raw
                   changed (DataValueOffset)
    08-Nov-1999 PB edf_raster_normalization added
    08-Nov-1999 PB in HSymb: shortlen and required added, 
                   new functions: edf_history_skip(), edf_history_take()
                   INTERNAL_BYTE_ORDER redefined according to bytesex.h
    18-Nov-1999 PB default of INTERNAL_BYTE_ORDER: HighByteFirst
    25-Nov-1999 PB dec alpha (__alpha)
    16-Mar-2000 PB comments revised
    18-Mar-2000 PB DBClass and DBInstance
    07-Apr-2000 PB V1.19 set_max_line_width
    30-Apr-2000 PB V1.20 MType
    01-Mai-2000 PB V1.21
    30-Jul-2000 PB V1.24 edf_raster_multiplication, edf_raster_inversion
    10-Nov-2000 PB V1.30 edf_write_data_2d_raw -> edf_write_data_raw
                         edf_write_data_2d_float -> edf_write_data_float
    11-Nov-2000 PB V1.31
    12-Nov-2000 PB V1.32 edf_write_data_float -> edf_write_data(...,MFloat,...)
                   V1.33 long * pDataArraySize -> size_t * pDataArraySize
                   V1.34 edf_read_data_...(... , long Dim[], ...)
                         ---> edf_read_data_...(... , long **pDim, ...)
                         edf_read_data_2d_... -> edf_read_data_...
                         edf_read_data_float --> edf_read_data(...,MFloat,...)
    30-Dec-2000 PB V1.36 
    01-Jan-2001 PB V1.37
    19-May-2001 PB V1.47 edf_dump
    01-Jun-2001 PB V1.49 edf_dump, new parameter list
    07-Jun-2001 PB V1.50 internal parameter functions,
                         the parameter list of edf_dump is not finished,
                         do not use generally 
    06-Jul-2001 PB V1.53 edf_search_stream
    08-Jul-2001 PB V1.55 EdfMaxKeyLen etc., edf_byteorder
    02-Sep-2001 PB V1.59 edf_set_datatype 
    13-Sep-2001 PB V1.62 history routines with history_key

***************************************************************************/

#ifndef EDFIO

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/
#ifndef PRIVATE
# define PRIVATE       static /* used to declare variables of private type */
# define PUBLIC                /* used to declare variables of public type */
#endif

#ifndef True
# define True           1 
# define False          0
#endif

# include <stdio.h>
# include <stdlib.h>
# include <math.h>

/***************************************************************************
* Functions                                                                *
***************************************************************************/

PUBLIC extern void
edf_write_data_raw         ( int stream, long DataNumber,
                   int DataChain, const long Dim[],
                   void *pData, int DataType, 
                   long DataValueOffset, int ByteOrder, 
                   long RasterConfiguration,
                   int * pErrorValue, int *pstatus ), 
edf_write_data             ( int stream, long DataNumber,
                   int DataChain, const long Dim[],
                   void *pData, int MachineType,
                   int * pErrorValue, int *pstatus ),
edf_read_data_raw          ( int stream, long DataNumber,
                   int DataChain, long **pDim,
                   size_t * pDataArraySize, void **ppData,
                   int * pDataType, long * pDataValueOffset,
                   int * pByteOrder, long * pRasterConfiguration,
                   int * pErrorValue, int * pstatus ), 
edf_read_data              ( int stream, long DataNumber,
		   int DataChain, long **pDim, size_t * pDataArraySize, 
                   void **ppData, int MachineType,
		   int * pErrorValue, int * pstatus ),
edf_close_data_file        ( int stream, int *pErrorValue, int *pstatus );

PUBLIC extern int
edf_open_data_file         ( const char *fname, const char * mode,
		   int *pErrorValue, int *pstatus ),
edf_search_stream          ( const char *fname,  const char * mode,
                   int *pErrorValue, int *pstatus ),
edf_read_data_dimension    ( int stream, long DataNumber,
		   int DataChain, long **pDim,
		   size_t * pDataArraySize,
		   int * pErrorValue, int * pstatus ),
edf_search_minmax_number   ( int stream, int DataChain,
		   long *pMinNumber, long * pMaxNumber,
		   int *pErrorValue, int *pstatus),
edf_read_header_long       ( int stream, long DataNumber,
		   int DataChain, const char * keyword,
		   long * Value, int * pErrorValue, int * pstatus),
edf_read_header_float      ( int stream, long DataNumber,
		   int DataChain, const char * keyword,
		   float * Value, int * pErrorValue, int * pstatus ),
edf_read_header_line       ( int stream, long DataNumber,
		   int DataChain, const char * keyword,
		   char * Value, int * pErrorValue, int * pstatus ),
edf_write_header_long      ( int stream, long DataNumber,
		   int DataChain, const char * keyword,
		   long Value, int * pErrorValue, int * pstatus ),
edf_write_header_float     ( int stream, long DataNumber,
		   int DataChain, const char * keyword,
		   float Value, int * pErrorValue, int * pstatus ),
edf_write_header_line      ( int stream, long DataNumber,
		   int DataChain, const char * keyword,
		   const char * Value,
		   int * pErrorValue, int * pstatus ),
edf_test_header            ( int stream, long DataNumber,
                   int DataChain,
                   int *pErrorValue, int *pstatus ),
edf_general_block          ( int writetodisk ), 
edf_set_datatype           ( int datatype_out ),
edf_set_datavalueoffset    ( long int datavalueoffset_out ),
edf_set_bsl_input_byteorder ( int byteorder ),
edf_set_max_line_width     ( unsigned long width ),
edf_free_data_file         ( void ),
edf_free_all               ( void );

PUBLIC extern char
*edf_report_data_error     ( int ErrorValue ),
*edf_dataformat_version    ( void );

/***************************************************************************
* Data conversion routines                                                 *
***************************************************************************/
PUBLIC extern size_t 
edf_data_sizeof ( int data_type );

PUBLIC extern unsigned long
edf_dim_product          ( const long * dim );

PUBLIC extern int
edf_machinetype2datatype ( int mtype ),
edf_string2datatype      ( const char * string ),
edf_raster_normalization ( void * dest, const void * src,
                           const long data_dim[],
                           long raster_configuration, size_t item ),
edf_machine2machine        ( void * dest, int mtype_dest,
                           const void * src, long value_offset,
                           int mtype_src, unsigned long n );

PUBLIC extern long
edf_raster_multiplication( long a, long x ),
edf_raster_inversion     ( long x );

PUBLIC extern const char
* edf_datatype2string( int data_type );

PUBLIC extern void
edf_bswap                ( void * dest, const void * src, size_t item,
                           unsigned long n ),
edf_showdatatypes        ( int full ),
edf_showmachinetypes     ( int full );

/***************************************************************************
* Debug routines                                                           *
***************************************************************************/
PUBLIC extern void
edfio_debug            ( int debug );

PUBLIC extern int
edf_print_filetable        ( FILE * out, int level, int verbose ),
edf_dump                   ( FILE * out, int stream, int format, 
                             char * chainkey[], char * blockkey[],
                             char * keyword[] ); 

PUBLIC extern char
*edfio_version         ( void );

/***************************************************************************
* History routines                                                         *
***************************************************************************/
PUBLIC extern int
edf_history_new          ( const char * history_key ),
edf_history_skip         ( const char * history_key ),
edf_history_take         ( const char * history_key ),
edf_history_argv         ( const char * history_key,
                           const char * substring ),
edf_read_header_history  ( int stream, long DataNumber,
                           int DataChain, const char * history_key,
                           int * pErrorValue, int * pstatus ),
edf_write_header_history ( int stream, long DataNumber,
                           int DataChain, const char * history_key,
                           int * pErrorValue, int * pstatus ),
edf_history_free         ( const char * history_key );

/***************************************************************************
* Header routines                                                          *
***************************************************************************/
PUBLIC extern int
edf_new_header           ( const char * header_key ),
edf_read_header          ( int stream, long DataNumber,
                           int DataChain, const char * header_key,
                           int * pErrorValue, int * pstatus ),
edf_write_header         ( int stream, long DataNumber,
                           int DataChain, const char * header_key,
                           int * pErrorValue, int * pstatus ),
edf_free_header          ( const char * header_key ),
edf_print_header         ( FILE * out, int level, int verbose );

/***************************************************************************
* Internal Parameter Definitions                                           *
***************************************************************************/

#define EdfMaxFiles                 20  /* maximum number of file streams */
#define EdfMaxKeyLen                64      /* maximum length of keywords */
#define EdfMaxValLen               512        /* maximum length of values */
#define EdfMaxLinLen               255             /* maximum line length */
#define EdfMaxDataChains            20 /* max. number of user data chains */
#define EdfBufferSize              512            /* size of input buffer */
#define EdfMaxDimensions EdfBufferSize    /* maximum number of dimensions */

/***************************************************************************
* Internal Parameter Functions (return the above defined parameters)       *
***************************************************************************/

PUBLIC extern unsigned long
edf_maxfiles             ( void ),
edf_maxkeylen            ( void ),
edf_maxvallen            ( void ),
edf_maxlinlen            ( void ),
edf_maxdatachains        ( void ),
edf_buffersize           ( void ),
edf_maxdimensions        ( void );

PUBLIC extern int
edf_byteorder            ( void );           /* return internal byteorder */

/***************************************************************************
* Symbolic Names of Error Values                                           *
***************************************************************************/

# define status_error           100
# define status_success         0

/***************************************************************************
* Endian type of machine                                                   *
***************************************************************************/
#if defined(__i386__) || defined(__alpha__) || defined(__alpha) \
        || (defined(__mips__) && (defined(MIPSEL) || defined (__MIPSEL__)))
# define INTERNAL_BYTE_ORDER      LowByteFirst
#elif defined(__mc68000__) || defined (__sparc__) || defined (__PPC__) \
        || (defined(__mips__) && (defined(MIPSEB) || defined (__MIPSEB__)))
# define INTERNAL_BYTE_ORDER      HighByteFirst 
#else
# define INTERNAL_BYTE_ORDER      HighByteFirst // default
#endif

/***************************************************************************
* Error Values                                                             *
***************************************************************************/

enum ErrorValues {
RoutineFailed = -1,
RoutineSucceeded,
CouldNotMallocMemory,
CouldNotFreeHeaders,
CouldNotGetBinaryArray,
NoMoreStreamsAvailable,
InvalidStream,
CouldNotOpenFile,
EndOfFileDetected,
CouldNotFindHeader,
CouldNotFindSymbol,
BadSizeDefinition,
BadDataBlock,
CouldNotFindKeyword,
WriteDataError,
ReadDataError,
NoFileOpen,
NotESRFDataFile,
NoDataBlocksFound,
ExternalData,
FileIsNotWritable,
FileIsNotOpened,
IncompatibleOpeningModes,
CouldNotCloseFile,
CouldNotInsertChain,
CouldNotInsertBlock,
CouldNotInsertSymbol,
MissingKeyDefinition,
GeneralBlockNotFirst,
ErrorCreatingGeneralBlock,
ErrorReadingGeneralBlock,
ErrorLocatingBlocks,
CouldNotSetBuffer,
NumberConversionFailed,
DataConversionFailed,
DataBufferTooSmall,
MissingArrayDimensions,
NotNdData,
Not2dData,
CouldNotWriteDimension,
CouldNotReadDimension,
CouldNotWriteBinary,
CannotReOpenGeneralBlock,
CannotOpenAsBslFile
};

/* The following enums start with 1. 0 is used to specify an invalid value.
   The string tables start with "InValid" and end with (char *) NULL. */

/***************************************************************************
* Data Type Translation Tables                                             *
***************************************************************************/

enum DType { InValidDType,
             Unsigned8=1, Signed8,      Unsigned16,    Signed16,
             Unsigned32,  Signed32,     Unsigned64,    Signed64,
             FloatIEEE32, DoubleIEEE64, Unused11,      Unused12,
             FloatVAX32,  DoubleVAX64,  FloatConvex32, DoubleConvex64,
             EndDType };

enum MType { InValidMType,
             MUnsignedChar=1,    MChar,       MUnsignedShort, MShort,
             MUnsignedInteger,   MInteger,    MUnsignedLong,  MLong,
             MFloat,             MDouble,
             EndMType };

/***************************************************************************
* Byte Order Translation Tables                                            *
***************************************************************************/

enum BOrder { InValidBOrder, 
              LowByteFirst=1, HighByteFirst, 
              EndBOrder };

/***************************************************************************
* Data Compression Translation Tables                                      *
***************************************************************************/

enum DCompression { InValidDCompression, 
                    UnCompressed=1, 
                    EndDCompression };


/***************************************************************************
* Data block classes and instances                                         *
***************************************************************************/

enum DBClass      { InValidDBClass, 
                    DBGeneral, 
                    DBImage, 
                    EndDBClass };
enum DBInstance   { InValidDBInstance, 
                    DBPrimaryData, 
                    DBError, 
                    EndDBInstance };

#endif
#ifndef EDFIO 
#  define EDFIO 
#endif
/************************************************************************---*/
