/*+++***********************************************************************
NAME

    SaxsExpression.h

SYNOPSIS

    #include "SaxsExpression.h"

DESCRIPTION
    Header of the module "SaxsExpression.c"
***********************************************************************---*/
#ifndef _SAXSEXPRESSION_
# define _SAXSEXPRESSION_

/***************************************************************************
* General Definitions                                                      *
***************************************************************************/

#ifndef PRIVATE
#  define PRIVATE static // used to declare variables of private type 
#endif

#ifndef PUBLIC
#  define PUBLIC         // used to declare variables of public type 
#endif

/****************************************************************************
*  Include                                                                  *
****************************************************************************/

# include <limits.h>
# include <errno.h>
# include <stdio.h>
# include <stdlib.h>
# include <fcntl.h>
# include <math.h>
# include <float.h>

# include "SaxsError.h"
# include "SaxsInput.h"
# include "gamma.h"

/***************************************************************************
* Functions                                                                *
***************************************************************************/

PUBLIC extern long longexpr( char * s, int * pstatus);

PUBLIC extern float floatexpr( char * s, int * pstatus);

PUBLIC extern double doubleexpr( char * s, int * pstatus);

#endif
