/* @(#) $Source: GetFrame.h V2.0 by P. Daly, P. Boesecke c. ESRF Dec. 1995 $ */
/**************************************************************************/
/* GetDldFrame.h                                                          */
/**************************************************************************/

#ifndef _GETDLDFRAME_ROUTINES 
#define _GETDLDFRAME_ROUTINES

#define HScalerLen 32 
#define HScalerNameLen 10

#ifdef __STDC__
  extern int 
     ReadDldData (FILE *stream, int FrameNumber, void **Start),
     ReadDldDataV1 (FILE *stream, int FrameNumber, void **Start),
     GetMaxDldNumber (FILE *stream, int *Maximum),
     ReadDldType (FILE *stream, int *X, int *Y, int *DataLength,
                   int * OffsetX, int * OffsetY),
     ReadDldScalars (FILE *stream, char **HmDldVersion, 
         float Scalars[HScalerLen],
         char *ScalarName[HScalerLen],
         float ScalarZero[HScalerLen],
         float ScalarCalib[HScalerLen],
         float *ScalarDepth,
         int *ScalarI0, int *ScalarI1,
         int *ScalarAnode, int *ScalarTime,
         int *ScalarI0S, int *ScalarI1S,
         int *ScalarAnodeS, int *ScalarTimeS,
         float *HmDeltaTime, 
         char HmStartTime[],
         int FrameNumber),
     ReadDldInfo(FILE * stream, 
         char * DetectorType[], 
         char * MachineInfo[],
         char * OpticsInfo[],
         char * StationInfo[],
         char * ProposalInfo[]),
     ReadDldExperiment(FILE * stream,
         char * Title[], char * ExperimentInfo[],
         float * Center_1, float * Center_2, int * ICenter,
         float * PixSize_1, float * PixSize_2, int * IPixSize,
         float * WaveLength, int * IWaveLength,
         float * SampleDistance, int * ISampleDistance,
	 float * DetectorPosition, int * IDetectorPosition);
			  ;
#else
   extern int
     ReadDldData(),
     ReadDldDataV1(),
     GetMaxDldNumber(),
     ReadDldType(),
     ReadDldScalars(),
     ReadDldInfo(),
     ReadDldExperiment(); 
#endif

#endif /* _GETDLDFRAME_ROUTINES */

/**************************************************************************/
/*                                                                        */
/**************************************************************************/

