"""
Py4datReducedImagePlugin.py
"""
import Command,os,sys, string
from PyDVT.Binding import Menu, Pen
from PyDisWindow import Plugin,ViewWindow
import PyDVT.ExtendedImageView as ExtendedImageView
import PyDVT.GraphView as GraphView
import PyDVT.ImageViewSelect as ImageViewSelect
import MccdFileData
import EdfFileData
import DataSelection
import PyDVT.ImageView as ImageView
from ErrorWindow import ErrorWindow

__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin'
__date__='25/02/03'

DEBUG=0

class Py4datReducedImagePlugin(Plugin):
    	"""
	Plugin Py4datReducedImagePlugin inherits Plugin.
	It allows to work on a selected region on an image or a stack of images.
	You must select a ROI on a window and select the 'Get Reduced Image' in the window popup menu.
	The resulting window give an access to the selected ROI for each file.
	Gain in reading time and in calculations time.
	"""
	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		if DEBUG: print 'In Py4datReducedImagePlugin.OnStartInit...'
		return 1

    	def OnFinishInit (self,app_window):
        	if DEBUG: print 'In Py4datReducedImagePlugin.OnFinishInit...'
		self.app_window=app_window

    	def OnInitWindowPopupMenu (self,window):
    		if DEBUG: print 'In Py4datReducedImagePlugin.OnInitWindowPopupMenu...'	
		if hasattr(window,'shortName') and window.shortName=='Stack':
			window.View.AddMenuSeparator()
			window.View.AddMenuPopupItem('Get Reduced Square Image',Command.Command(self.GetReducedImage,window))
					
	def GetInfoString(self):
		return "v. "+__version__+",  Author:"+__author__
	
    	########################################################
    	### Private methods
    	########################################################

	################## GET REDUCED IMAGE ############################################
	
	def GetReducedImage(self,window):
		"""
		Select a ROI on the window and choose 'Get Reduced Image' open a new window with
		the selected area of the image. The user can work on this selected area. -> gain in calculation time.
		If the user is working on a stack of images, only the selected region will be read from each file -> gain in reading time. 
		"""
		if window.View.Source!=():
			if len(window.rois.keys())!=1:
				dial=ErrorWindow(None,message=' You must select 1 ROI to obtain a reduced image !',sizex=350,sizey=60)
				return
			else:
				ret=[]
				for roi in window.rois.keys():
					ret.append(window.rois[roi])
				print 'number of ROIs:',len(ret)
				self.Limitsx = [ret[0].Limitsx[0]][0]
				self.Limitsy = [ret[0].Limitsy[0]][0]
				sizeX=self.Limitsx[1]-self.Limitsx[0]
				sizeY=self.Limitsy[1]-self.Limitsy[0]
				self.size=max(sizeX,sizeY)
			reducedWindow=self.app_window.GetWindow("ReducedImage - "+window.name)
			if reducedWindow is None:
    				reducedWindow=ViewWindow(self.app_window.mdi, ExtendedImageView.ExtendedImageView, name="ReducedImage - "+window.name, view_pars={"AddSelection":0,"UseImageValues":1})
        			reducedWindow.fileName=window.fileName
				reducedWindow.shortName='Stack - ReducedImage'
        			if reducedWindow.fileName[0][-3:]=='edf': reducedWindow.Data=EdfFileData.EdfFileData()
				elif reducedWindow.fileName[0][-4:]=='mccd': reducedWindow.Data=MccdFileData.MccdFileData()
				else: reducedWindow.Data=EdfFileData.EdfFileData()
        		reducedWindow.DataSelection=DataSelection.RectSelection(reducedWindow.Data)
        		reducedWindow.Filter=ImageView.ColormapFilter(None,reducedWindow.DataSelection)
        		reducedWindow.View.SetSource(reducedWindow.Filter) 
			reducedWindow.NumImages=len(reducedWindow.fileName)
			reducedWindow.pos=(self.Limitsx[0],self.Limitsy[0])
			reducedWindow.size=(self.size,self.size)
			if hasattr(reducedWindow,'Slider')==0:
				self.SetStackViewMenu(reducedWindow)
        		self.PageSelect(reducedWindow,0,pos=reducedWindow.pos,size=reducedWindow.size)
			info=reducedWindow.Data.GetPageInfo(0)
			if info.has_key('PSize_1') and info.has_key('PSize_2'): 
				value1=self.ConvertInformation(info['PSize_1'],'um')
				value2=self.ConvertInformation(info['PSize_2'],'um')
				if value1!=None and value2!=None: reducedWindow.pixelsize=(value1,value2)
			if info.has_key('Center_1') and info.has_key('Center_2'): 
				value1=self.ConvertInformation(info['Center_1'])-reducedWindow.pos[0]
				value2=self.ConvertInformation(info['Center_2'])-reducedWindow.pos[1]
				if value1!=None and value2!=None: reducedWindow.center=(value1,value2)
			if info.has_key('WaveLength'): 
				value=self.ConvertInformation(info['WaveLength'],'angstroms')
				if value!=None: reducedWindow.wavelength=value
			if info.has_key('SampleDistance'): 
				value=self.ConvertInformation(info['SampleDistance'],'mm')
				if value!=None: reducedWindow.distance=value
    
   	def ConvertInformation(self,information,unit=None):
    		" information is a string and ConvertInformation convert it in a float"
		information=string.split(information,' ')
		if len(information)!=2: return None
		else:
	   		if information[1]=='m' and unit=='angstroms': return float(information[0])*1e10
	   		elif information[1]=='m' and unit=='um': return float(information[0])*1e6
	   		elif information[1]=='m' and unit=='mm': return float(information[0])*1e3
	   		elif information[1]=='pixel': return float(information[0])
	   		else: return None
		
    	def SetStackViewMenu(self,window):        
        	window.View.AddMenuSeparator()
        	cascademenu=Menu(window.View.GetPopupMenu())
        	cascademenu.AddCommand("Horizontal",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectHLine),"radiobutton")
        	cascademenu.AddCommand("Vertical",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectVLine),"radiobutton")
        	cascademenu.AddCommand("Line",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectLine),"radiobutton")
        	cascademenu.AddCommand("Rectangle",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectRect),"radiobutton")
        	cascademenu.AddSeparator()
        	if window.NumImages > 1:
            		cascademenu.AddCommand("Depth Point",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectPoint,callback=self.EventDepthSelection),"radiobutton")        
            		cascademenu.AddCommand("Depth Horizontal",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectHLine,callback=self.EventDepthSelection),"radiobutton")
            		cascademenu.AddCommand("Depth Vertical",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectVLine,callback=self.EventDepthSelection),"radiobutton")
            		cascademenu.AddSeparator()
        	cascademenu.AddCommand("Clear Selection",window.View.ClearViewSelect,"radiobutton")
        	cascademenu.SetCheckedRadio("Clear Selection")
        	window.View.AddMenuPopupCascade("Selection",cascademenu)
        	self.app_window.Set2DViewMenu(window)
        	window.View.AddMenuSeparator()
        	if window.NumImages > 1:
            		window.image_selection_menu=Menu(window.View.GetPopupMenu())
            		for i in range(window.NumImages):
                    		window.image_selection_menu.AddCommand(os.path.split(window.fileName[i])[1],Command.Command(self.PageSelect,window,i),"radiobutton")
            		window.image_selection_menu.SetCheckedRadio("1")
            		window.View.AddMenuPopupCascade("Select Image",window.image_selection_menu)
            		self.app_window.AddImageSlider(window,self.onImageSelectionSliderChanged)

    	def onImageSelectionSliderChanged(self,page):
		window=self.app_window.mdi.activeWindow()
        	if page != window.SelectedPage: self.PageSelect(window,page,pos=window.pos,size=window.size)

    	def PageSelect(self,window,page,pos=None,size=None):        
        	if window.NumImages > 1:
            		window.SelectedPage=page        
            		short_name=os.path.split(window.fileName[page])[1]
			window.SetTitle(window.shortName + " - %d/%d - %s" % (page+1,window.NumImages,short_name))
            		window.image_selection_menu.SetCheckedRadio(short_name)
            		window.SliderLabel.setText("Image: %d" %(page+1,))            
            		if window.Slider.value() != page: window.Slider.setValue(page)
		if window.fileName[page][-3:]=='edf': 
			window.Data.SetSource(window.fileName[page])
			window.Data.LoadSource(0,pos=pos,size=size)
		elif window.fileName[page][-4:]=='mccd':
			window.Data.SetSource(window.fileName[page])
                	window.Data.LoadSource(0,pos=pos,size=size)
		else:
			window.Data.SetSource(window.fileName[page])
			window.Data.LoadSource(0,pos=pos,size=size)

    	def EventDepthSelection  (self,source):
        	sel=source.GetDataSelection()
        	origin=self.app_window.mdi.activeWindow()
        	if sel==None or origin==None or hasattr(origin,"View")==0:return
        	if origin.View.__class__ is not ExtendedImageView.ExtendedImageView or hasattr(origin,"sufix"):return
        	if self.Semaphore: return
        	self.Semaphore=1
        	try:            
            		pos = source.GetSelection()["BoundingRect"][0]
            		if source.GetType()=="Point":
                		windowname=str(origin)+" - Depth Point"
                		sufix=" - Depth Point Selection (x=%d y=%d)" % pos.PageCoord                
                		classname=GraphView.GraphView
                		opts={"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,}
            		else:
                		if source.GetType()=="VLine":   
                    			windowname=str(origin)+" - Depth VLine"                    
                    			sufix=" - Depth Vertical Selection (x=%d)" % (pos.PageCoord[0],)
                		else:
                    			windowname=str(origin)+" - Depth HLine"                    
                    			sufix=" - Depth Horizontal Selection (y=%d)" % (pos.PageCoord[1],)
                		classname=ExtendedImageView.ExtendedImageView
                		###I'm setting "UseImageValues" to 1 because I don't have so far a DataSelection with coords convertion for cross-page selection
                		opts={"UseImageValues":1,"AddSelection":0,"SelectionCallback":self.app_window.EventSelection,"UseColormapWidget":1}
            		window=self.app_window.GetWindow(windowname)
            		if window is None:
                		window=ViewWindow (self.app_window.mdi,classname,windowname,opts,master_window=origin)
                		if source.GetType()=="Point":
                    			window.View.SetStyle("PointsLine")
                    			self.app_window.Set1DViewMenu(window)
                		else:
                    			self.app_window.Set2DViewMenu(window)
            		window.SetTitle(origin.shortName,sufix=sufix)
            
            		if hasattr(window,"Data")==0 or window.Data is None:
				if window.master_window.fileName[0][-3:]=='edf': window.Data=EdfFileData.EdfFileData()
				elif window.master_window.fileName[0][-4:]=='mccd': window.Data=MccdFileData.MccdFileData()
				else: window.Data=EdfFileData.EdfFileData()
            		if source.GetType()=="Point":
                		window.View.SetLabels(x_label="Image",y_label="Value")
                		append=0
                		for file in origin.fileName:
                    			window.Data.SetSource(file)
                    			window.Data.LoadSource(0,pos=pos.PageCoord, size=(1,1),append=append,invalidate=0)
                    			append=1
                		if not hasattr(window,"pen"): window.pen=Pen((255,0,0),2,"solid")
                		if hasattr(window,"DataSelection")==0:
                    			window.DataSelection=DataSelection.DataSelection(window.Data,(0,0),(1,1),"ALL",1)                        
                    			window.Filter=GraphView.GraphFilter("1",window.DataSelection,pen=window.pen)
                    			window.View.SetSource(window.Filter)
                		else:
                    			window.Data.Invalidate()
            		else:
                		append=0
                		for file in origin.fileName:
					window.Data.SetSource(file)
                    			if source.GetType()=="VLine": 
						window.Data.LoadSource(0,pos=(pos.PageCoord[0],0), size=(1,"ALL"),append=append,invalidate=0)
					else:
						window.Data.LoadSource(0,pos=(0,pos.PageCoord[1]), size=("ALL",1),append=append,invalidate=0)
                    			append=1
                		if hasattr(window,"DataSelection")==0:
                    			if source.GetType()=="VLine": 
						window.DataSelection=DataSelection.RectSelection(window.Data,(0,0),(1,"ALL"),"ALL")
                    			else:
						window.DataSelection=DataSelection.RectSelection(window.Data,(0,0),("ALL",1),"ALL")
					window.Filter=ImageView.ColormapFilter("",window.DataSelection)
                    			window.View.SetSource(window.Filter)
               			else:
                    			window.Data.Invalidate()            
 			#self.app_window.SetEdfViewMenu(window)         
        	except: 
 			import traceback
 			traceback.print_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)
			pass

        	self.Semaphore=0

plugin=Py4datReducedImagePlugin()
