"""
    Py4datMosaicImage.py
    Py4datMosaicImage plugin to display mosaic images 
"""
import Numeric,types,Command
import qt
from PyDisWindow import Plugin,ViewWindow
import PyDVT.ExtendedImageView as ExtendedImageView
import MccdFileData
import EdfFileData
import DataSelection
import PyDVT.ImageView as ImageView
import MLabData
import ParametersDialog

DIRECTORY = '/scisoft/users/gendrin/PACKAGES/Py4dat/WRAPPERS'

__version__='1.0.0'
__date__=  '24/02/03'
__author__ =  'Anne-Cecile Gendrin'
    
DEBUG=0

class Py4datMosaicImage(Plugin):
    	'''
	Plugin that allows to open several files and create one mosaic image.
	The mosaic image is the result of the concatenation of the arrays contained in the files.(one array per file)
		
	'''
	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
        	return 1

    	def OnInitMenuBar (self,menu_bar):
        	menuFile=menu_bar.children()[0]
        	menuFile.insertItem('Open Mosaic',self.OpenMosaic,0,-1,5)	
			    
    	def OnInitWindowPopupMenu(self,window):
		if DEBUG: print 'In Py4datMosaicImage.OnInitWindowPopupMenu...'		
		if hasattr(window,'shortName')==0 or window.shortName!='Mosaic': return
		if isinstance(window.View,ExtendedImageView.ExtendedImageView) == 1:
			window.View.AddMenuSeparator()
			window.View.AddMenuPopupItem("Reduction Factor",Command.Command(self.ChangeReductionFactor,window))
			
	
	def OnFinishInit (self,app_window):
        	self.app_window=app_window
		self.NbColumns=2
		self.ReducFactor=1
                
    	def GetInfoString(self):
        	return "v"+__version__+",  Author:"+__author__

    	########################################################
    	### Private methods
    	########################################################
	
	def ChangeReductionFactor(self,window):
		if DEBUG: print "In Py4datMosaicImage.ChangeReductionFactor..."
		dial=ParametersDialog.ParametersDialog(None, {'Reduction Factor':window.ReducFactor},sizeY=60)
		if dial.dlg.result()==0: return
		window.ReducFactor=int(dial.params['Reduction Factor'])
        	window.Filter.SetReducParameters(window.ReducFactor,fastreduc=0)
	
	def OpenMosaic(self):
        	filter="EDF files (*.edf);;EDF files  (*);;Mccd files (*.mccd)"        
        	#fn = qt.QFileDialog.getOpenFileNames(filter,qt.QString(DIRECTORY), self.app_window, None,qt.QString.null)  
		fn = qt.QFileDialog.getOpenFileNames(filter,qt.QString(DIRECTORY), self.app_window, None,qt.QString('Choose files to create a Mosaic Image'))                       
        	files=[] 
        	for file in fn: files.append(str(file))
        	if len(files)==0: return
        	files.sort()
		
		dial=ParametersDialog.ParametersDialog(None, {'Number of columns':self.NbColumns,'Reduction Factor':self.ReducFactor})
		if dial.dlg.result()==0: return
		self.NbColumns=int(dial.params['Number of columns'])
		self.ReducFactor=int(dial.params['Reduction Factor'])
		
        	window=ViewWindow (self.app_window.mdi,ExtendedImageView.ExtendedImageView,"Mosaic",{"AddSelection":1,"SelectionCallback":self.app_window.EventSelection,"UseColormapWidget":1,"AddReduc":0})
		window.NumImages=len(files)
        	window.shortName="Mosaic"
        	window.filename=files
		window.NbColumns=self.NbColumns
		window.ReducFactor=self.ReducFactor
		
		array=self.CreateMosaicArray(window)
		
		window.Data=MLabData.MLabData(array)
		
		window.DataSelection=DataSelection.RectSelection(window.Data)
        	window.Filter=ImageView.ColormapFilter(None,window.DataSelection)
        	window.Filter.SetReducParameters(window.ReducFactor,fastreduc=0)
		self.app_window.Set2DViewMenu(window)
		#print window.View.GetColormapFilter()
		window.View.SetSource(window.Filter)
        	

    	def CreateMosaicArray(self,window):        
        	"""
		Read each file and concatenate all the arrays in one array.
		Numeric example: concatenate((a,b,c),axis=1)
		"""
		image=0
		arrayList=[]
		while image < window.NumImages:
		 	if window.filename[0][-3:]=='edf': data=EdfFileData.EdfFileData()
			elif window.filename[0][-4:]=='mccd': data=MccdFileData.MccdFileData()
			data.SetSource(window.filename[image])
			data.LoadSource()
			arrayList.append(data.GetPageArray(0))
			image=image+1
		mosaic=self.Concatenate( arrayList , min(window.NbColumns,len(arrayList)))
		return mosaic
		
	def Concatenate(self,list,nx):
		"""
		Create from a list of arrays a new array to display a mosaic.
		Parameters:
		- list: list of arrays of same shape
		- nx: number of arrays to put in a line of the mosaic
		If the numer of arrays is odd: add an array of zeros to complete the mosaic. 
		(Numeric.concatenate needs arrays of same shape)
		"""
		line=0
		ny=len(list)/float(nx)
		if (ny-int(ny))!=0: 
			ny=int(ny)+1
		arrayLineList=[]
		while line < int(ny):
			if len(list)%nx==0 or line <= (len(list)/float(nx))-1: arrayLine=Numeric.concatenate((list[line*nx:(line+1)*nx]),1)
			elif len(list)==1: arrayLine=list[line]
			elif len(list)%nx!=0: 
				if len(list)-nx*line > line: arr=Numeric.concatenate((list[line*nx:len(list)]),1)
				else: arr=list[line]
				zerosArr=Numeric.repeat(Numeric.zeros(list[0].shape),nx-(len(list)-line*nx),axis=1)
				arrayLine=Numeric.concatenate((arr,zerosArr),axis=1)  
			arrayLineList.append(arrayLine)
			line=line+1
		mosaic=Numeric.concatenate((arrayLineList))
		return mosaic
		
		
plugin=Py4datMosaicImage()