import string,os,sys
sys.path.insert(0,'../')
sys.path.insert(0,'.')

from PyDisWindow import Plugin,ViewWindow
import PyDVT.ExtendedGraphView as ExtendedGraphView
import PyDVT.ExtendedImageView as ExtendedImageView
import PyDVT.DataSelection as DataSelection
import PyDVT.ImageView as ImageView
import MccdFileData as MccdFileData

__version__ ='1.0.0'
__author__ =  'Anne-Cecile Gendrin'
__date__= '18/02/03'

DEBUG=0

class Py4datMccdPlugin(Plugin):
    	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		if DEBUG: print 'In Py4datMccdPlugin.OnStartInit...'
		return 1

    	def OnFinishInit (self,app_window):
        	if DEBUG: print 'In Py4datMccdPlugin.OnFinishInit...'
		self.app_window=app_window
	
	def OnFileOpen (self,filename,format_string):
        	if DEBUG: print 'In Py4datMccdPlugin.OnFileOpen...'
		type=string.upper(format_string)
            	short_name= os.path.split(filename)[1]
		if string.upper(type)[0:4]=="MCCD":
			window=ViewWindow (self.app_window.mdi,ExtendedImageView.ExtendedImageView,short_name)
                	window.shortName=short_name
                	window.fileName=filename
                	window.Data=MccdFileData.MccdFileData()
                	window.Data.SetSource(filename)
                	window.DataSelection=DataSelection.RectSelection(window.Data)
                	window.Filter=ImageView.ColormapFilter(None,window.DataSelection)
                	window.View.SetSource(window.Filter)
                	window.NumImages=1 
			window.Data.LoadSource()
	
	def OnFileSave (self,window,filename,format_string):
        	if DEBUG: print 'In Py4datMccdPlugin.OnFileSave...'
		pass
	
	def GetOpenFormatList(self):
        	if DEBUG: print 'In Py4datMccdPlugin.GetOpenFormatList...'
		return ["MCCD files (*.mccd)"]

	def GetInfoString(self):
		return "v. "+__version__+",  Author:"+__author__
	

			
plugin=Py4datMccdPlugin()
