"""
    PyDisWindow
    Python Generic Image Visualization Tool
"""
import sys

__version__=  '1.1'
__author__ =  'gendrin@esrf.fr or mirone@esrf.fr'
# 


from mdi import *
import qt

from   PyDVT.Binding import Pen,Brush,Menu,Dialog
import PyDVT.ImageView as ImageView
import PyDVT.ExtendedImageView as ExtendedImageView
import PyDVT.GraphView as GraphView
import PyDVT.TableView as TableView
import PyDVT.MeshView as MeshView
import PyDVT.ContourView as ContourView
import PyDVT.DataInfoView as DataInfoView

import PyDVT.EdfFileData as EdfFileData
import PyDVT.ImageFileData as ImageFileData
import PyDVT.DataSelection as DataSelection
import PyDVT.GraphViewSelect as GraphViewSelect
import PyDVT.ImageViewSelect as ImageViewSelect
import PyDVT.Transf2DFilter as Transf2DFilter


import Command
import Numeric
import string
import os
import stat

    
currentApplicationWindow=[None]

class PyDisWindow(ApplicationWindow):

    def __init__(self,parent = None, name = None, fl = 0, plugin_list=[]):
        currentApplicationWindow[0]=self
        self.plugins=[]
        strplugins=[]
        self.strplugins=[]
        local_dir=os.path.dirname(__file__)
        if local_dir=="": local_dir="."
        if "plugins" in os.listdir(local_dir) and stat.S_ISDIR(os.stat(local_dir+'/plugins')[stat.ST_MODE]):        
            plugin_list.append(local_dir+'/plugins')

        for plugin_location in plugin_list:
            if stat.S_ISDIR(os.stat(plugin_location)[stat.ST_MODE]):
                for file in os.listdir(plugin_location):
                    if file[-3:]==".py": strplugins.append(file[:-3])
                #sys.path.insert(0,plugin_location)
                sys.path.append(plugin_location)
            else:
                if plugin_location[-3:]==".py": strplugins.append(plugin_location[:-3])
	
        for module in strplugins:
            if module not in self.strplugins:
                try:
		    exec("import "+module)
		    exec("plugin="+module +".plugin")
		    if plugin.OnStartInit():
			self.plugins.append(plugin)
                        self.strplugins.append(module)
                except:
                    import traceback
                    traceback.print_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)

                    pass

        ApplicationWindow.__init__(self,parent,name, fl)
        self.CurPath='.'
        self.Semaphore=0

        for plugin in self.plugins: plugin.OnFinishInit(self)



    #----------------------------
    #mdi class overridables
    #----------------------------
    def onInitMenuBar(self):
        self.menuFile.removeItemAt(0)
        for plugin in self.plugins: plugin.OnInitMenuBar(self.menuBar())        


    def onOpen(self):
	standard_formats=("EDF files (*.edf)","EDF files  (*)","Image files (*.png *.jpg *.gif *.bmp)")
        filter=""
        for format in standard_formats: filter=filter+format+";;"

        plugin_formats_dict={}
        for plugin in self.plugins:
            plugin_formats=plugin.GetOpenFormatList()
            for format in plugin_formats:
                filter=filter+format+";;"
                plugin_formats_dict[format]=plugin             
            
        if qt.qVersion()>="3.0.0":
            selected=qt.QString()
            fn = qt.QFileDialog.getOpenFileName(self.CurPath,filter,self,None,qt.QString.null,selected)
        else:
            dlg=qt.QFileDialog(self.CurPath,filter,self,None,1)
            dlg.setCaption("Open")
            dlg.show()
            fn=dlg.selectedFile()
            selected=dlg.selectedFilter()
        if fn.isEmpty(): return
        filename = str(fn)
        format_str=str(selected)
        if format_str in standard_formats:
            format=format_str[-4:-1]
            if string.upper(format) not in ("EDF","PNG","JPG","GIF","BMP"): format="EDF"
            self.loadFile (filename,format)
        else:
	    plugin_formats_dict[format_str].OnFileOpen(filename,format_str)
        self.CurPath=os.path.dirname(filename)


    def onSaveAs(self):
        window=self.mdi.activeWindow()
        if window==None: return
        filter=""
        standard_formats=[]
        for fmt in window.View.GetSaveFormats(): standard_formats.append (fmt+" files (*."+string.lower(fmt)+")")
        for format in standard_formats: filter=filter+format+";;"

        plugin_formats_dict={}
        for plugin in self.plugins:
            plugin_formats=plugin.GetSaveFormatList(window)
            for format in plugin_formats:
                filter=filter+format+";;"
                plugin_formats_dict[format]=plugin                     
        
        if filter=="":
            self.statusBar().message('No file format supported by view object',4000)
            return
                    
        if qt.qVersion()>="3.0.0":
            selected=qt.QString()
            fn = qt.QFileDialog.getSaveFileName(self.CurPath,filter,self,None,qt.QString.null,selected)
        else:
            dlg=qt.QFileDialog(self.CurPath,filter,self,None,1)
            dlg.setCaption("Save As")
            dlg.show()            
            fn=dlg.selectedFile()
            selected=dlg.selectedFilter()
        if fn.isEmpty(): return
        filename = str(fn)
        format_str=str(selected)

        if not fn.isEmpty():
            window.filename = fn
            if format_str in standard_formats:
                window.save_plugin=None
                window.format=string.upper(format_str[-4:-1])
            else:
                window.save_plugin=plugin_formats_dict[format_str]
                window.format=format_str
            if window.format==".PS":window.format="PS"
            self.onSave()
            self.CurPath=os.path.dirname(filename)
        else:
            self.statusBar().message('Saving aborted',2000)        


    def onSave(self):
        window=self.mdi.activeWindow()
        if window is not None:
            if hasattr (window,"filename")==0 or window.filename.isEmpty():
                self.onSaveAs()
                return
            if window.save_plugin==None: ret=window.View.Save(str(window.filename),str(window.format))
            else: ret= window.save_plugin.OnFileSave(window,str(window.filename),window.format)
            if  ret==0: self.statusBar().message('Error writing file',4000)
                

    def onPrint(self):
        import os
        window=self.mdi.activeWindow()
        if window==None: return

        for plugin in self.plugins:
            if plugin.OnFilePrint(window): return
            
        if "PS" not in window.View.GetSaveFormats():
            self.statusBar().message('Unable to print',4000)
            return
        try:
            if self.printer.setup(self):
                self.statusBar().message('Printing...')
                if self.printer.outputToFile()==1:
			print 'Saving in a file...'
			filename=str(self.printer.outputFileName())
			print filename
			if filename[-3:]!=".ps": filename=filename+'.ps'
			window.View.Save(filename,"PS")
			return
		
		window.View.Save("_tmp.ps","PS")
                
                printername= str(self.printer.printerName())
                
		if sys.platform!= "win32":
		    os.system("lp -c -d " + printername + " _tmp.ps")
                else:
		    import win32print
		    printer=win32print.OpenPrinter(printername)
                    win32print.StartDocPrinter(printer,1,("Py4dat Doc",None,None))
                    psfile=open("_tmp.ps",'r')
                    win32print.WritePrinter(printer,psfile.read())
                    win32print.EndDocPrinter(printer)
                    win32print.ClosePrinter(printer)
                    psfile.close()                     
                os.remove("_tmp.ps")
                self.statusBar().message('Printing completed',4000)
            else:
                self.statusBar().message('Printing aborted',4000)
        except:
            import traceback
            traceback.print_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)

            self.statusBar().message('Error writing file',4000)        

    
    def onAbout(self):
        import PyDVT
        import mdi
        msg='Py4dat is based on PyDis - 2D Data Visualisation and Analysis Tool,\n'
        msg=msg + 'Version: '+ __version__ +'  (PyDis v'+PyDVT.Binding.__version__+' mdi v'+mdi.__version__+')\n\n'
        msg=msg + 'Plugins: \n'        
        for i in range(len(self.strplugins)):
            msg=msg + self.strplugins[i]+': '+ self.plugins[i].GetInfoString() +'\n'
        msg=msg+'\nBug report at: ' + __author__       
        qt.QMessageBox.about(self,'Py4dat',msg)

    
    #----------------------------
    #File loading
    #----------------------------
    def setCurPath(self,path):
        self.CurPath=path

    ## USARE QUESTA FUNZIONE
    def loadFile (self,filename,type):
        try:
            type=string.upper(type)
            short_name= os.path.split(filename)[1]
            if string.upper(type)=="EDF":
                window=ViewWindow (self.mdi,ExtendedImageView.ExtendedImageView,short_name,{"AddSelection":0,"SelectionCallback":self.EventSelection,"UseColormapWidget":1,"AddReduc":1})
                window.shortName=short_name
                window.fileName=filename
                window.Data=EdfFileData.EdfFileData()
                window.Data.SetSource(filename)
                window.DataSelection=DataSelection.RectSelection(window.Data)
                window.Filter=ImageView.ColormapFilter(None,window.DataSelection)
                window.View.SetSource(window.Filter)
                info=window.Data.GetSourceInfo()
                window.NumImages=info["Size"]
                self.SetEdfViewMenu(window)
                self.PageSelect(window,0)     
		info=window.Data.GetPageInfo(0)
		if info.has_key('PSize_1') and info.has_key('PSize_2'): 
		    value1=self.ConvertInformation(info['PSize_1'],'um')
		    value2=self.ConvertInformation(info['PSize_2'],'um')
		    if value1!=None and value2!=None: window.pixelsize=(value1,value2)
		if info.has_key('Center_1') and info.has_key('Center_2'): 
		    value1=self.ConvertInformation(info['Center_1'])
		    value2=self.ConvertInformation(info['Center_2'])
		    if value1!=None and value2!=None: window.center=(value1,value2)
		if info.has_key('WaveLength'): 
		    value=self.ConvertInformation(info['WaveLength'],'angstroms')
		    if value!=None: window.wavelength=value
		if info.has_key('SampleDistance'): 
		    value=self.ConvertInformation(info['SampleDistance'],'mm')
		    if value!=None: window.distance=value           
            elif (type=="JPG" or type=="GIF" or type=="BMP" or type=="PNG"):
                window=ViewWindow (self.mdi,ExtendedImageView.ExtendedImageView,short_name,{"AddSelection":0,"AddColormap":0,"AddReduc":0})
                window.fileName=filename
                window.Data=ImageFileData.ImageFileData()
                window.Data.SetSource(filename)
                window.DataSelection=DataSelection.RectSelection(window.Data)
                window.Filter=ImageView.ImageFilter(None,window.DataSelection)
                window.View.SetSource(window.Filter)
                window.View.AddMenuPopupItem("Data Info",self.DataInfo)                       
                window.Data.LoadSource()
            else:
                window.close()
                self.statusBar().message('Unknown file type',4000)
        except:
            import traceback
            traceback.print_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)

            try:
                window.close()
            except:
                import traceback
                traceback.print_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)

                pass
            self.statusBar().message('Error loading file',4000)

    def ConvertInformation(self,information,unit=None):
        " information is a string and ConvertInformation convert it in a float"
	information=string.split(information,' ')
	if len(information)!=2: return None
	else:
	    if information[1]=='m' and unit=='angstroms': return float(information[0])*1e10
	    elif information[1]=='m' and unit=='um': return float(information[0])*1e6
	    elif information[1]=='m' and unit=='mm': return float(information[0])*1e3
	    elif information[1]=='pixel': return float(information[0])
	    else: return None
	   
    #----------------------------
    #Default Menus
    #----------------------------

    def Set1DViewMenu(self,window):
        window.View.AddMenuSeparator()
        window.View.AddMenuPopupItem("Set Color",self.SelectColor)
        window.View.AddMenuPopupItem("Table",self.Table)
        window.View.AddMenuPopupItem("Data Info",self.DataInfo)
        for plugin in self.plugins:plugin.OnInitWindowPopupMenu(window)        

            
    def Set2DViewMenu(self,window):
        window.View.AddMenuSeparator()
        window.View.AddMenuPopupItem("Histogram",Command.Command(self.Histogram,window))
        window.View.AddMenuPopupItem("Contour Plot",Command.Command(self.ContourPlot,window))
        window.View.AddMenuPopupItem("Mesh Plot",Command.Command(self.MeshPlot,window))
        window.View.AddMenuPopupItem("Table",self.Table)
        window.View.AddMenuPopupItem("Data Info",self.DataInfo)
        for plugin in self.plugins: plugin.OnInitWindowPopupMenu(window)


    def SetEdfViewMenu(self,window):
        window.View.AddMenuSeparator()
        cascademenu=Menu(window.View.GetPopupMenu())
        cascademenu.AddCommand("Horizontal",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectHLine),"radiobutton")
        cascademenu.AddCommand("Vertical",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectVLine),"radiobutton")
        cascademenu.AddCommand("Line",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectLine),"radiobutton")
        cascademenu.AddCommand("Rectangle",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectRect),"radiobutton")
        cascademenu.AddSeparator()
        if hasattr(window,"NumImages" ):
         if window.NumImages > 1:
            cascademenu.AddCommand("Depth Point",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectPoint,callback=self.EventDepthSelection),"radiobutton")        
            cascademenu.AddCommand("Depth Horizontal",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectHLine,callback=self.EventDepthSelection),"radiobutton")
            cascademenu.AddCommand("Depth Vertical",Command.Command(window.View.CreateViewSelect,ImageViewSelect.ImageViewSelectVLine,callback=self.EventDepthSelection),"radiobutton")
            cascademenu.AddSeparator()
        cascademenu.AddCommand("Clear Selection",window.View.ClearViewSelect,"radiobutton")
        cascademenu.SetCheckedRadio("Clear Selection")
        window.View.AddMenuPopupCascade("Selection",cascademenu)
        self.Set2DViewMenu(window)
        window.View.AddMenuSeparator()
        if hasattr(window,"NumImages" ):
         if window.NumImages > 1:
            window.image_selection_menu=Menu(window.View.GetPopupMenu())
            for i in range(window.NumImages): window.image_selection_menu.AddCommand(str(i+1),Command.Command(self.PageSelect,window,i),"radiobutton")
            window.image_selection_menu.SetCheckedRadio("1")
            window.View.AddMenuPopupCascade("Select Image",window.image_selection_menu)
            self.AddImageSlider(window,self.onImageSelectionSliderChanged)

    def SetContourViewMenu(self,window,target_window):
        window.View.AddMenuSeparator()
        popupMenu=Menu(window.View.GetPopupMenu())
        for op in ('None','Transpose','FlipY','FlipX','FlipXY','Rotate90','Rotate180','Rotate270'):
            popupMenu.AddCommand(op,Command.Command(self.ContourTransf, window, op) ,"radiobutton")
        popupMenu.SetCheckedRadio('None')                    
        window.View.AddMenuPopupCascade("Transformation",popupMenu)                
        window.View.AddMenuSeparator()
        window.View.AddMenuPopupItem("Mesh Plot",Command.Command(self.MeshPlot,target_window))
        window.View.AddMenuPopupItem("Table",self.Table)
        window.View.AddMenuPopupItem("Data Info",self.DataInfo)
        for plugin in self.plugins: plugin.OnInitWindowPopupMenu(window)        

    def SetMeshViewMenu(self,window,target_window):
        window.View.AddMenuPopupItem("Set Color",self.SelectColor)
        window.View.AddMenuSeparator()
        window.View.AddMenuPopupItem("Contour Plot",Command.Command(self.ContourPlot,target_window))
        window.View.AddMenuPopupItem("Table",self.Table)
        window.View.AddMenuPopupItem("Data Info",self.DataInfo)
        for plugin in self.plugins: plugin.OnInitWindowPopupMenu(window)        

    def SetTableViewMenu(self,window):
        window.View.AddMenuSeparator()
        window.View.AddMenuPopupItem("Data Info",self.DataInfo)
        for plugin in self.plugins: plugin.OnInitWindowPopupMenu(window)        

    #----------------------------
    #View operations
    #----------------------------
    def AddImageSlider(self,window,callback):
        SliderFrame=qt.QHBox(window.View)
        window.SliderLabel=qt.QLabel(SliderFrame)
        window.Slider=qt.QSlider(0,window.NumImages-1,1,0,qt.Qt.Horizontal,SliderFrame)
        window.Slider.setTickmarks(qt.QSlider.Below)
        self.connect(window.Slider,qt.SIGNAL("valueChanged(int)"),callback)
        window.SliderLabel.setText("Image: 999" )
        qt.qApp.processEvents()
        window.SliderLabel.setFixedWidth(window.SliderLabel.width())
        window.SliderLabel.setText("Image: 1" )
        SliderFrame.show()

    def Table(self):
        window=self.mdi.activeWindow()
        prefix= "Table - "
        window_name=prefix + str(window)
        tableWindow=self.GetWindow(window_name)
        if tableWindow is None:            
            tableWindow=ViewWindow (self.mdi,TableView.TableView,window_name,master_window=window)
            self.SetTableViewMenu(tableWindow)
            tableWindow.SetTitle(None,prefix=prefix)
            tableWindow.View.SetSource(window.View.GetSource())
        else: tableWindow.setFocus()


    def DataInfo(self):
        window=self.mdi.activeWindow()
        prefix= "Data Info - "
        window_name=prefix + str(window)
        dataInfoWindow=self.GetWindow(window_name)
        if dataInfoWindow is None:
            dataInfoWindow=ViewWindow (self.mdi,DataInfoView.DataInfoView,window_name,master_window=window)
            dataInfoWindow.SetTitle(None,prefix=prefix)
            dataInfoWindow.View.SetSource(window.View.GetSource())
        else: dataInfoWindow.setFocus()


    def EventHistSelection(self,source):
        ((x0,y0),(x1,y1))=source.GetSelection()["BoundingRect"]        
        ColormapPars=source.Target.GetColormapParameters()
        ColormapPars["MinMax"]=(x0,x1)
        ColormapPars["AutoScale"]=0
        source.Target.SetColormapParameters(ColormapPars)        
        

    def DefineColormap(self,histWindow):
        if histWindow.View.GetPopupMenu().IsItemChecked(histWindow.chkColormap):
            histWindow.View.GetPopupMenu().CheckItem(histWindow.chkColormap,0)
            histWindow.View.GetPopupMenu().EnableItem(histWindow.View.ZoomMenuItem)
            if hasattr(histWindow,"Select") and histWindow.Select is not None:
                histWindow.Select.Destroy()
            histWindow.Select=None
        else:
            histWindow.View.GetPopupMenu().CheckItem(histWindow.chkColormap,1)
            histWindow.View.GetPopupMenu().DisableItem(histWindow.View.ZoomMenuItem)
            data=histWindow.View.GetSource()[0].GetData()
            if data==None: return
            if hasattr(histWindow,"Select") and histWindow.Select is not None:
                histWindow.Select.Destroy()
            histWindow.Select=GraphViewSelect.GraphViewSelectHRect(data,self.EventHistSelection)
            histWindow.Select.SetBrush(Brush((240,240,240),"fill_100"))
            histWindow.Select.Target=histWindow.master_window.Filter
            histWindow.Select.ConnectView(histWindow.View)        
        

    def Histogram(self,window):        
        if (window.Filter is not  None):
            prefix= "Histogram - "
            window_name=prefix + str(window)                    
            histWindow=self.GetWindow(window_name)
            if histWindow is None:
                histWindow=ViewWindow (self.mdi,GraphView.GraphView,window_name,{"AddStyleSelect":1,"AddCursorSelect":1,"AddStatus":1,"AutoHideStatus":1},master_window=window)
                histWindow.SetTitle(window.caption(),prefix=prefix) 
                histWindow.View.AddMenuSeparator()
                histWindow.chkColormap=histWindow.View.AddMenuPopupItem("Define Colormap",Command.Command(self.DefineColormap,histWindow),"checkbutton")
                histWindow.View.AddMenuPopupItem("Table",self.Table)
                histWindow.View.AddMenuPopupItem("Set Color",self.SelectColor)
                histWindow.DataSelection=window.DataSelection
                histWindow.pen=Pen((0,196,0),1,"solid")
                histWindow.Filter=GraphView.HistFilter("1",histWindow.DataSelection,pen=histWindow.pen)
                histWindow.Filter.SetDivisions(100)
                histWindow.View.SetStyle("Bars")
                histWindow.View.SetLabels(x_label="Value",y_label="Count")
                histWindow.View.SetSource(histWindow.Filter)
            else:
                histWindow.setFocus()

            
    def ContourTransf(self, contourWindow, transf):
        if transf in ('Transpose','Rotate90','Rotate270'): contourWindow.View.SetLabels(x_label="(y)",y_label="(x)")        
        else: contourWindow.View.SetLabels(x_label="(x)",y_label="(y)")
        contourWindow.Filter.SetTransformation(transf,refresh=1)


    def ContourPlot(self,window):
        if (window.Filter != None):
            prefix="Contour Plot - "
            window_name= prefix+ str(window)
            contourWindow=self.GetWindow(window_name)
            if contourWindow is None:
                contourWindow=ViewWindow (self.mdi,ContourView.ContourView,window_name,master_window=window)
                contourWindow.SetTitle(window.caption(),prefix=prefix)
                self.SetContourViewMenu(contourWindow,window)
                contourWindow.DataSelection=window.DataSelection
                contourWindow.Filter=Transf2DFilter.Transf2DFilter(ContourView.ContourFilter("1",contourWindow.DataSelection))
                contourWindow.View.SetLabels(x_label="(x)",y_label="(y)")
                contourWindow.View.SetSource(contourWindow.Filter)
            else:
                contourWindow.setFocus()


    def MeshPlot(self,window):
        if (window.Filter != None):
            prefix="Mesh Plot - "
            window_name=prefix + str(window)        
            meshWindow=self.GetWindow(window_name)
            if meshWindow is None:
                meshWindow=ViewWindow (self.mdi,MeshView.MeshView,window_name,master_window=window)
                meshWindow.SetTitle(window.caption(),prefix=prefix)
                self.SetMeshViewMenu(meshWindow,window)
                meshWindow.pen=Pen((128,128,128),1,"solid")  
                meshWindow.View.SetLabels(x_label="(x)",y_label="(y)",z_label="")
                meshWindow.DataSelection=window.DataSelection
                meshWindow.Filter=MeshView.MeshFilter(name="1",source=meshWindow.DataSelection,pen=meshWindow.pen)
                meshWindow.View.SetSource(meshWindow.Filter)
            else:
                meshWindow.setFocus()
            

    def PageSelect(self,window,page):
        if window.NumImages > 1:
            window.SelectedPage=page        
            window.SetTitle(window.shortName + " - %d/%d" % (page+1,window.NumImages))
            window.image_selection_menu.SetCheckedRadio(str(page+1))
            window.SliderLabel.setText("Image: %d" %(page+1,))            
            if window.Slider.value() != page: window.Slider.setValue(page)
        window.DataSelection.Reconfig(index_list=[page])
        window.Data.LoadSource(page)
            
    def onImageSelectionSliderChanged(self,page):
        window=self.mdi.activeWindow()
        if page != window.SelectedPage: self.PageSelect(window,page)

                        
    def SelectColor(self):
        window=self.mdi.activeWindow()
        if not hasattr(window,"pen"): window.pen=Pen((0,0,0),1,"solid")
        color = qt.QColorDialog.getColor(qt.QColor(window.pen.color[0],window.pen.color[1],window.pen.color[2]))
        window.pen=Pen((color.red(),color.green(),color.blue()),window.pen.width,window.pen.style)
        window.View.SetPen("1",window.pen)                  
        

    def EventSelection(self,source,depth_selection=0):        
        sel=source.GetDataSelection()
        origin=self.mdi.activeWindow()
        if sel==None or origin==None or hasattr(origin,"View")==0:return

# --------------------------------------------------------------------------
# to get horizontal depth selection having fully featured menus
#         if origin.View.__class__ is not ExtendedImageView.ExtendedImageView or hasattr(origin,"sufix"):return

        if origin.View.__class__ is not ExtendedImageView.ExtendedImageView :return

        if self.Semaphore: return
        self.Semaphore=1
        try:            
            if depth_selection==0:
                if source.GetType()=="Rect":
                    windowname=str(origin)+" - Rect"                    
                    window=self.GetWindow(windowname)
                    sufix=" - Rectangle Selection (%d,%d) to (%d,%d)" % (sel.Position[0],sel.Position[1],sel.Position[0]+sel.Size[0],sel.Position[1]+sel.Size[1])
                    if window is None:
                        window=ViewWindow (self.mdi,ExtendedImageView.ExtendedImageView,windowname,{"ZoomMode":"FIT_TO_SCREEN","ScrollMode":"OFF","AddSelection":0,"AddReduc":0,"SelectionCallback":self.EventSelection,"UseColormapWidget":1},master_window=origin)
                        window.SetTitle(origin.caption(),sufix=sufix)  
                        self.Set2DViewMenu(window)
                        window.DataSelection=DataSelection.XYRectSelection(source.Data,position=sel.Position,size=sel.Size)
                        window.Filter=ImageView.ColormapFilter(None,window.DataSelection)
                        window.Filter.SetColormapParameters(origin.Filter.GetColormapParameters())
                        window.View.SetSource(window.Filter)
                    else:
                        window.SetTitle(origin.caption(),sufix=sufix)  
                        window.DataSelection.Reconfig(position=sel.Position,size=sel.Size)                    
                elif source.GetType() in ("HLine","VLine","Line"):                
                    if   source.GetType()=="HLine":
                        windowname=str(origin)+" - HLine"
                        sufix=" - Horizontal Selection (y=%d)" % (sel.Position[1],)
                    elif source.GetType()=="VLine":
                        windowname=str(origin)+" - VLine"
                        sufix=" - Vertical Selection (x=%d)" % (sel.Position[0],)
                    elif source.GetType()=="Line":
                        windowname=str(origin)+" - Line"
                        sufix=" - Line Selection (%d,%d) to (%d,%d)" % (sel.Begin[0],sel.Begin[1],sel.End[0],sel.End[1])
                    window=self.GetWindow(windowname)
                    if window is None:
                        window=ViewWindow (self.mdi,GraphView.GraphView,windowname,{"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,},master_window=origin)
                        window.SetTitle(origin.caption(),sufix=sufix)  
                        self.Set1DViewMenu(window)
                        if not hasattr(window,"pen"): window.pen=Pen((0,196,0),1,"solid")
                        if source.GetType()=="Line":
                            window.DataSelection=DataSelection.LineSelection(source.Data,begin=sel.Begin,end=sel.End)
                        else:
                            window.DataSelection=DataSelection.OrthoLineSelection(source.Data,position=sel.Position,size=sel.Size)
                        window.Filter=GraphView.GraphFilter("1",window.DataSelection,pen=window.pen)
                        window.View.SetLabels(x_label="Point",y_label="Value")
                        window.View.SetSource(window.Filter)
                    else:
                        window.SetTitle(origin.caption(),sufix=sufix)  
                        window.View.SetLabels(x_label="Point",y_label="Value")
                        if source.GetType()=="Line":
                            window.DataSelection.Reconfig(begin=sel.Begin,end=sel.End)
                        else:
                            window.DataSelection.Reconfig(position=sel.Position,size=sel.Size)                    
            else:
                pos = source.GetSelection()["BoundingRect"][0]
                if source.GetType()=="Point":
                    windowname=str(origin)+" - Depth Point"
                    sufix=" - Depth Point Selection (x=%d y=%d)" % pos.PageCoord                
                    classname=GraphView.GraphView
                    opts={"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,}
                else:
                    if source.GetType()=="VLine":   
                        windowname=str(origin)+" - Depth VLine"                    
                        sufix=" - Depth Vertical Selection (x=%d)" % (pos.PageCoord[0],)
                    else:
                        windowname=str(origin)+" - Depth HLine"                    
                        sufix=" - Depth Horizontal Selection (y=%d)" % (pos.PageCoord[1],)
                    classname=ExtendedImageView.ExtendedImageView
                    ###I'm setting "UseImageValues" to 1 because I don't have so far a DataSelection with coords convertion for cross-page selection
                    opts={"UseImageValues":1,"AddSelection":0,"SelectionCallback":self.EventSelection,"UseColormapWidget":1}
                window=self.GetWindow(windowname)
                if window is None:
                    window=ViewWindow (self.mdi,classname,windowname,opts,master_window=origin)
                    if source.GetType()=="Point":
                        window.View.SetStyle("PointsLine")
                        self.Set1DViewMenu(window)
                    else:
                        self.Set2DViewMenu(window)
                window.SetTitle(origin.shortName,sufix=sufix)
                
                if hasattr(window,"Data")==0 or window.Data is None: window.Data=EdfFileData.EdfFileData()
                if source.GetType()=="Point":
                    window.View.SetLabels(x_label="Image",y_label="Value")
                    window.Data.SetSource(origin.fileName)
                    window.Data.LoadSource(pos=pos.PageCoord, size=(1,1),invalidate=0)
                    if not hasattr(window,"pen"): window.pen=Pen((255,0,0),2,"solid")
                    if hasattr(window,"DataSelection")==0:
                        window.DataSelection=DataSelection.DataSelection(window.Data,(0,0),(1,1),"ALL",1)                        
                        window.Filter=GraphView.GraphFilter("1",window.DataSelection,pen=window.pen)
                        window.View.SetSource(window.Filter)
                    else:
                        window.Data.Invalidate()
                else:
                    window.Data.SetSource(origin.fileName)
                    if source.GetType()=="VLine": window.Data.LoadSource(pos=(pos.PageCoord[0],0), size=(1,"ALL"),invalidate=0)
                    else: window.Data.LoadSource(pos=(0,pos.PageCoord[1]), size=("ALL",1),invalidate=0)                    
                    if hasattr(window,"DataSelection")==0:
                        if source.GetType()=="VLine": window.DataSelection=DataSelection.RectSelection(window.Data,(0,0),(1,"ALL"),"ALL")
                        else:window.DataSelection=DataSelection.RectSelection(window.Data,(0,0),("ALL",1),"ALL")
                        window.Filter=ImageView.ColormapFilter("",window.DataSelection)
                        window.View.SetSource(window.Filter)
                    else:
                        window.Data.Invalidate()            
        except:
            pass
            import traceback
            traceback.print_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)

        self.Semaphore=0


    def EventDepthSelection  (self,source):
        self.EventSelection(source,depth_selection=1)


    def GetWindow(self,name):
        for window in self.mdi.windows:
            if window.name==name:
                return window
        return None

        

class ViewWindow(ChildWindow):
    
    def __init__(self,parent,view_class,name="",view_pars={},master_window=None):
        view_pars["AddOnLine"]=1
        view_pars["AddLockPosition"]=1
        view_pars["AddRefresh"]=1
        view_pars["DataChangedCallback"]=self.DataChangedCallback
        activewindow=parent.activeWindow()
        if activewindow is not None:
            if qt.qVersion()>="3.0.0":
                if activewindow.isMaximized():
                    activewindow.showNormal()
            else:
                activewindow.showNormal()
                
        ChildWindow.__init__(self,parent,name,qt.Qt.WDestructiveClose)
        self.name=name
        self.parent=parent
        self.OnLine=1
        self.LockZoom=0
        self.View =view_class(self,view_pars)
        self.SetTitle(name)
        self.setCaption(name)
        self.View.Show()
        self.resize(0.5*self.parent.width(),0.5*self.parent.height())
        self.master_window=master_window
        if qt.qVersion()>="3.0.0": self.showNormal()
        else: self.show()

        self.view_class = view_class
        self.name = name
        self.master_window = master_window
        self.view_pars= view_pars


    def __getstate__(self):
        print " GETSTATE ViewWindow "
     	ret={}
        ret['view']=self.View
        ret['name']=self.name
        ret['view_class']=self.view_class
        ret['master_window']=self.master_window 
        print self.view_pars
        if "DataChangedCallback" in self.view_pars.keys():
           self.view_pars["DataChangedCallback"] =None
        ret['view_pars']=self.view_pars
        return ret

    def __setstate__(self, dict):

        print " GETSTATE ViewWindow "
        
	ViewWindow.__init__(self, 
		currentApplicationWindow[0].mdi,
		dict["view_class"],
		dict["name"],
		dict["view_pars"],
		dict["master_window"])
        for key in dict["view"].__dict__.keys():
            self.View.__dict__[key] = dict["view"].__dict__[key]

        for key in dict["view"].drawable_dict.keys():
            self.View.Drawable.__dict__[key] = dict["view"].drawable_dict[key]


        self.View.DataChanged()
        


        
    def SetTitle(self,title=None,prefix=None,sufix=None):
        if prefix is not None: self.prefix=prefix
        if sufix is not None: self.sufix=sufix
        
        if hasattr(self,"sufix"): title=str(title)+self.sufix
        if title is None:
            if hasattr(self,"master_window"):
                title=self.master_window.OriginalCaption
        self.OriginalCaption=str(title)

        for window in self.parent.windowList():            
            if hasattr(window,"master_window") and window.master_window is self:
                window.SetTitle(title)

    def DataChangedCallback(self,view,source=None):
        if hasattr(self,"prefix"): ChildWindow.setCaption(self,self.prefix+self.OriginalCaption)
        else: ChildWindow.setCaption(self,self.OriginalCaption)
        
    def resizeEvent(self,e):
        if hasattr(self,"View"): self.View.SetSize(self.width(),self.height())


    def focusInEvent (self,e):
        if hasattr(self,"View"): self.View.GetDrawable().setFocus()


    def closeEvent(self,ce):
        for window in self.parent.windowList():            
            if hasattr(window,"master_window") and window.master_window is self: window.close(1)
        
        if hasattr(self,"Select") and self.Select is not None: self.Select.Destroy()
        if hasattr(self,"Data") and self.Data is not None: self.Data.Destroy()
        if hasattr(self,"View") and self.View is not None: self.View.Destroy()
        self.Data=None
        self.Filter=None
        self.DataSelection=None
        self.View=None
        ChildWindow.closeEvent(self,ce)
        self.parent=None


class Plugin:
    def OnStartInit (self):
        return 1

    def OnInitMenuBar (self,menu_bar):
        pass

    def OnFinishInit (self,app_window):
        pass

    def OnInitWindowPopupMenu (self,window):
        pass

    def OnFileOpen (self,filename,format_string):
        pass

    def OnFileSave (self,window,filename,format_string):
        pass

    def OnFilePrint(self,window):
        return 0
    
    def GetOpenFormatList(self):
        return []

    def GetSaveFormatList(self,window):
        return []

    def GetInfoString(self):
        return ""
