'''
Easy Data Class to use in the command line.
Use: MLabMccdFileData(filename)
'''

from MccdFileData import MccdFileData
from Py4datMLabPlugin import MLab
import MLabData

__date__='19/02/03'
__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin'


class MLabMccdFileData(MccdFileData):
	'''
	Easy Data Class to use in the command line.
	Use: MLabMccdFileData(filename)
	'''
	def __init__(self,filename,refresh_interval=None,info={}):
		MccdFileData.__init__(self,refresh_interval,info)
		self.SetSource(filename)
		self.LoadSource()
	
	def display(self):
		mldata=MLabData.MLabData(self.GetPageArray(0))
		MLab.newWindow(mldata)
	
	def show(self):
		self.display()
		
	def applyFilter(self,filterName):
		'''
		Allows to apply easily an existing filter to a data object
		without taking care of the selection and colormap filters
		Parameters:
		- FilterName: string containing the name of the filter (ex:AzimIntFilter)
		'''
		import DataSelection
		sel=DataSelection.RectSelection(self)
		import ImageView
		colormap=ImageView.ColormapFilter(None,sel)
		print filterName, type(filterName)
		exec("from "+filterName+" import "+filterName+" as filter")
		import sys
		print filter, type(filter)
		filteredData=filter(colormap)
		return filteredData	
	
	def displayFilteredImage(self,filterName):
		data=self.applyFilter(filterName)
		mldata=MLabData.MLabData(data)
		MLab.newWindow(mldata)
		
	
		
		
if __name__=='__main__':
	data=MLabMccdFileData('../circle.edf')
