"""
    DemoFit.py
    Demo application - fitting a function
 
    Contact: Alexandre Gobbo (gobbo@esrf.fr)
    Version: 1.0
"""    


import qt
import sys
sys.path.insert(0,"../")
from Data import Data
from GraphView import GraphView,GraphFilter
from DataSelection import OrthoLineSelection
from FitFilter import FitFilter
from FitParametersDialog import FitParametersDialog
from Binding import Pen
import Numeric



root = qt.QApplication(sys.argv)
data=Data()
arr = Numeric.ones ((200,),"f")
arr[100]=3
arr[101]=5
arr[102]=8
arr[103]=10
arr[104]=20
arr[105]=17
arr[106]=15
arr[107]=13
arr[108]=8
arr[109]=2
data.AppendPage({},arr)

sel=OrthoLineSelection(data)
frame=qt.QSplitter(qt.Qt.Vertical,None)
ParDlg=FitParametersDialog(frame,None)
ParDlg.Show()
fit_filter=FitFilter(sel)


view = GraphView(frame,{"AddLockPosition":1,"AddOnLine":1,"AddRefresh":1,"AddCursorSelect":1,"AddStyleSelect":1,"ScrollMode":"ON","AddStatus":1,"AutoHideStatus":1,})
view.SetLabels("DemoFit","(x)","(y)")
view.SetStyle("PointsLine")
view.SetSource((GraphFilter("G1",sel,pen=Pen((255,0,0),0,"solid")),GraphFilter("G2",fit_filter,pen=Pen((0,255,0),0,"dotted"))))


pars={}
pars["Weight"]=0
pars["Theory"]="Area Gaussians"
pars["Background"]="Linear"
pars["Mode"]="Normal"

pars["Action"]="ESTIMATE"
fit_filter.SetParameters(pars)
pars["Action"]="FIT"
fit_filter.SetParameters(pars)


fit_filter.ConnectParameterEditor(ParDlg)
frame.resize(500,500)
view.Show()
frame.setSizes([126,126])
frame.show()
root.setMainWidget(frame)
root.exec_loop()


