"""
    myqplplot.py
    qplplot derived widget - Manages mouse events
    
"""

from PyDVT import __version__,__date__,__author__

import qt
import qplplot
import sys
import os
import pyqt_pl
if os.getenv("PLPLOT_HOME") is None:   
   if os.path.dirname(pyqt_pl.__file__)=="":
      os.environ["PLPLOT_HOME"]="."
   else:
      os.environ["PLPLOT_HOME"]=os.path.dirname(pyqt_pl.__file__)


class MyQplplot(qplplot.qplplot):
   def __init__(self,parent=None,name=None,back_color=None  ):
       #if sys.platform== "win32":
       #   qplplot.qplplot.__init__(self,parent,name,back_color,double_buffered=1)
       #else:
       #   qplplot.qplplot.__init__(self,parent,name,back_color,double_buffered=1,meta_buffer=0)
       qplplot.qplplot.__init__(self,parent,name,back_color,double_buffered=1,meta_buffer=0,alloc_colors=0)
       self.bPainting=0
       self.parent=parent
       self.setMouseTracking (1 )
       self.setFocusPolicy(qt.QWidget.StrongFocus)
       self.setFocus()
       

   def mousePressEvent(self, e):
    if e.button() == qt.Qt.RightButton:
        self.parent._RightButtonPress(e)

    elif e.button() == qt.Qt.LeftButton:
        self.parent._LeftButtonPress(e)
               
   def mouseDoubleClickEvent(self,e):
        self.parent._DoubleClick(e)

   def mouseReleaseEvent(self,e):
       if e.button() == qt.Qt.LeftButton:
           self.parent._LeftButtonRelease(e)
           

   def mouseMoveEvent(self,e):       
       if e.state()==0:
           self.parent._Motion(e)
       elif e.state()==1:
           self.parent._PressMotion(e)

   def keyPressEvent(self,e):
       self.parent._KeyPress(e)
       e.ignore()


   def resizeEvent(self,e):
       qplplot.qplplot.resizeEvent(self,e)
       if self.is_created:
          #TODO: Advantages and disadvantages in calling processEvents
          #(here and in the base class). Worse redrawing for fast draws,
          #better for slow.  Calling processEvents generates bad assincronous
          #behaviour, like a bad sequence for interprating mouse/keyboard.
          #Anyway this is unavoidable, since in the constructor processEvents
          #is unavoidably called. The best is to remove it from resize, and
          #find a way in Qt to create a mdi window not redrawable while resizing. 
          if sys.platform!= "win32": self.App.processEvents()
          self.parent._Refresh()

   def set_cmap1_rgb(self,modpl,rgb,reverse=0):
        import Numeric
        # Independent variable of control points.
        i = Numeric.array((0., 0.25, 0.50, 0.75, 1.))
        rc,gc,bc=float(rgb[0])/255.,float(rgb[1])/255.,float(rgb[2])/255.
        if reverse:
            r = Numeric.array((rc,rc*0.75,rc*0.5,rc*0.25,0.))
            g = Numeric.array((gc,gc*0.75,gc*0.5,gc*0.25,0.))
            b = Numeric.array((bc,bc*0.75,bc*0.5,bc*0.25,0.))        
        else:
            r = Numeric.array((0.,rc*0.25,rc*0.5,rc*0.75,rc))
            g = Numeric.array((0.,gc*0.25,gc*0.5,gc*0.75,gc))
            b = Numeric.array((0.,bc*0.25,bc*0.5,bc*0.75,bc))        
        rev = Numeric.array((0, 0, 0, 0, 0))

        # number of cmap1 colours is 256 in this case.
        modpl.plscmap1n(256)
        # Interpolate between control points to set up cmap1.
        #modpl.plscmap1l(0, i, h, l, s, rev)
        modpl.plscmap1l(1, i, r, g, b, rev)



   # Routine for restoring colour map1 to default.
   # See static void plcmap1_def(void) in plctrl.c for reference.
   def set_cmap1_color(self,modpl):
        import Numeric
        ## For center control points, pick black or white, whichever is closer to bg 
        ## Be careful to pick just short of top or bottom else hue info is lost
        #vertex = Numeric.sum(Numeric.array(modpl.plgcolbg()))/(3.*255.)
        #if vertex < 0.5:
        #    vertex = 0.01
        #    midpt = 0.10
        #else:
        #    vertex = 0.99
        #    midpt = 0.90
        #I'm forcing middle color to black
        vertex = 0.01
        midpt = 0.10
        # Independent variable of control points.
        i = Numeric.array((0., 0.44, 0.50, 0.50, 0.56, 1.))
        # Hue for control points.  Blue-violet to red
        h = Numeric.array((260., 260., 260., 0., 0., 0.))
        # Lightness ranging from medium to vertex to medium
        l = Numeric.array((0.5, midpt, vertex, vertex, midpt, 0.5))
        # Saturation is complete for default
        s = Numeric.array((1., 1., 1., 1., 1., 1.))
        # Integer flag array is zero (no interpolation along far-side of colour
        # figure.)  
        rev = Numeric.array((0, 0, 0, 0, 0, 0))
        # Default number of cmap1 colours
        modpl.plscmap1n(256)
        # Interpolate between control points to set up default cmap1.
        modpl.plscmap1l(0, i, h, l, s, rev)


   def set_cmap1_temp(self,modpl):
        import Numeric
        i = Numeric.array((0., 0.25, 0.50, 0.75, 1.))
        r = Numeric.array((0., 0.,0.,1.,1.))
        g = Numeric.array((0., 1.,1.,1.,0.))
        b = Numeric.array((1., 1.,0.,0.,0.))
        rev = Numeric.array((0, 0, 0, 0, 0))
        modpl.plscmap1n(256)
        # Interpolate between control points to set up default cmap1.
        modpl.plscmap1l(1, i, r, g, b, rev)


