"""
    DrawableTable.py
    Table displaying widget
        
"""

from PyDVT import __version__,__date__,__author__


import qt
try:
    import qttable
except:
    qttable=qt
    pass



class  Drawable_Table(qttable.QTable):
    def __init__( self, parent=None, vertical_header=1, horizontal_header=1):
        qttable.QTable.__init__( self, parent)
        if qt.qVersion()>="3.0.0":
            self.setReadOnly(1)
            self.cg=qt.QColorGroup()
            self.cg.setColor(qt.QColorGroup.Text,qt.QColor(0,0,0))
            self.cg.setColor(qt.QColorGroup.Base,qt.QColor(255,255,255))
            self.cg.setColor(qt.QColorGroup.Highlight,qt.QColor(0,0,128))
            self.cg.setColor(qt.QColorGroup.HighlightedText,qt.QColor(255,255,255))
            
        self.setShowGrid(1)
        self.verticalHeader().setResizeEnabled(1,-1)
        self.horizontalHeader().setResizeEnabled(1,-1)
        if not vertical_header:
            self.verticalHeader().hide()
            self.setLeftMargin( 0 )
        if not horizontal_header:
            self.horizontalHeader().hide()
            self.setTopMargin( 0 )        
        self.Data=None
        self.myparent=parent


    def beginEdit(self,row,col,replace):
        if qt.qVersion()<"3.0.0":
            return None
        return qttable.QTable.beginEdit(self,row,col,replace)
    
    
    def Show(self):
       self.show()
              
    def paintCell(self,painter,row,col,rect,selected):
        if self.Data is None:
            if qt.qVersion()<"3.0.0":
                qttable.QTable.paintCell(self,painter,row,col,rect,selected)
            else:
                qttable.QTable.paintCell( self,painter, row, col, rect, selected, self.cg )
            return
        
        if rect.width() == 0 or rect.height() == 0: return
        if self.item(row,col) is None:
            self.setText(row,col, str(self.Data[row][col]))
        else:
            self.item(row,col).setText(str(self.Data[row][col]))
        if qt.qVersion()<"3.0.0":
            qttable.QTable.paintCell(self,painter,row,col,rect,selected)
        else:
            painter.eraseRect(self.cellRect(row,col))            
            qttable.QTable.paintCell( self,painter, row, col, rect, selected, self.cg )
        
    def SetData(self,data=None,h_header=None,v_header=None):
        self.Data=data
        if data is not None and data.shape[0] and data.shape[1]:
            self.setNumRows(data.shape[0])
            self.setNumCols(data.shape[1])            
            #for i in range(data.shape[0]):
            #    for j in range (data.shape[1]):
            #        self.setText(i,j, str(Data[i][j]))
            if  v_header is not None:
                header=self.verticalHeader()
                for i in range(len(v_header)):
                    header.setLabel(i,str(v_header[i]))
                
            if  h_header is not None:
                header=self.horizontalHeader()
                for i in range(len(h_header)):
                    header.setLabel(i,str(h_header[i]))

        else:
            self.setNumRows(0)
            self.setNumCols(0)

    def SetRows(self,rows):
        self.setNumRows(rows)
        self.update()

    def SetCols(self,cols):
        self.setNumCols(cols)
        self.update()

    def SetText(self,row,col,text):
        self.setText(row,col,str(text))

    def SetHHeaderText(self,col,text):
        self.horizontalHeader().setLabel(col,str(text))
        
    def SetVHeaderText(self,row,text):
        self.verticalHeader().setLabel(row,str(text))

    def MergeCells(self,row,col,rowspan,colspan):
        self.item(row,col).setSpan(rowspan,colspan)

    def AdjustColumn(self,col):
        self.adjustColumn(col)


    def contentsMousePressEvent(self, e):        
        if e.button() == qt.Qt.RightButton:
            self.myparent._RightButtonPress(e.globalPos ())
        else:
            qttable.QTable.contentsMousePressEvent(self,e)

    def contentsMouseDoubleClickEvent(self,e):       
        pass

    def contentsMouseReleaseEvent(self,e):
        pass

    def contentsMouseMoveEvent(self,e):       
        pass
                       
    def keyPressEvent(self,e):
        qttable.QTable.keyPressEvent(self,e) #Manages arrow keys
        ret=str(e.text())
        if ret=="":
             ret= e.key()
        self.myparent._KeyPress(ret)
        e.ignore()

    def GetViewport(self):
        return self

