from Tkinter import *
from TableWidget import *


class testTable:
	def __init__(self,master):
		
		self.table=TableWidget(master,nbCol=6,nbRow=5,rowTitlesCnf={'bg':'blue','bd':4,'relief':'groove'},
							colTitlesCnf={'bg':'red','bd':2,'relief':'sunken'},)

		nbColLab=Label(master,text='nbCol')
		self.nbCol=IntVar()
		self.nbColEnt=Entry(master,width=3,textvariable=self.nbCol)
		
		nbRowLab=Label(master,text='nbRow')
		self.nbRow=IntVar()
		self.nbRowEnt=Entry(master,width=3,textvariable=self.nbRow)
		
		cellInfLab=Label(master,text="cell's infos")
		self.cellInfText=Text(master,height=6,width=20)
		
		colLab=Label(master,text='col')
		self.col=IntVar()
		self.colEnt=Entry(master,width=3,textvariable=self.col)

		rowLab=Label(master,text='row')
		self.row=IntVar()
		self.rowEnt=Entry(master,width=3,textvariable=self.row)

		valLab=Label(master,text='value')
		self.val=StringVar()
		self.valEnt=Entry(master,width=8,textvariable=self.val)
		
		addTextButton=Button(master,text='addText',command=self.addText)
		addButton=Button(master,text='addButton',command=self.addButton)
		addColButton=Button(master,text='add col',command=self.addCol)
		addRowButton=Button(master,text='add row',command=self.addRow)
		delColButton=Button(master,text='del col',command=self.delCol)
		delRowButton=Button(master,text='del row',command=self.delRow)
		setColNameButton=Button(master,text='set col name',command=self.setColName)
		setRowNameButton=Button(master,text='set row name',command=self.setRowName)
		hideColButton=Button(master,text='hide col titles',command=self.hideColTitles)
		hideRowButton=Button(master,text='hide row titles',command=self.hideRowTitles)
		showColButton=Button(master,text='show col titles',command=self.showColTitles)
		showRowButton=Button(master,text='show row titles',command=self.showRowTitles)
		setColWidthButton=Button(master,text='set col width',command=self.setColWidth)
		setRowHeightButton=Button(master,text='set row height',command=self.setRowHeight)
		getSizeButton=Button(master,text='get nbCol/nbRow',command=self.getSize)
		getCellInfos=Button(master,text='get cell infos',command=self.getCellInfos)
		hideButton=Button(master,text='hide',command=self.hide)
		showButton=Button(master,text='show',command=self.show)
		
		self.table.grid(col=0,row=0,columnspan=4,sticky='nsew')
		nbColLab.grid(col=0,row=1,sticky='nsew')
		self.nbColEnt.grid(col=1,row=1)
		nbRowLab.grid(col=2,row=1,sticky='nsew')
		self.nbRowEnt.grid(col=3,row=1)
		cellInfLab.grid(col=0,row=2,columnspan=4,sticky='nsew')
		self.cellInfText.grid(col=0,row=3,columnspan=4,sticky='nsew')
		
		colLab.grid(col=0,row=4,sticky='nsew',columnspan=2)
		rowLab.grid(col=2,row=4,sticky='nsew',columnspan=2)
		self.colEnt.grid(col=0,row=5,columnspan=2)
		self.rowEnt.grid(col=2,row=5,columnspan=2)
		valLab.grid(col=0,row=6,sticky='nsew',columnspan=2)
		self.valEnt.grid(col=2,row=6,columnspan=2)
		addTextButton.grid(col=0,row=7,sticky='nsew',columnspan=2)
		addButton.grid(col=2,row=7,sticky='nsew',columnspan=2)
		addColButton.grid(col=0,row=8,sticky='nsew',columnspan=2)
		addRowButton.grid(col=2,row=8,sticky='nsew',columnspan=2)
		delColButton.grid(col=0,row=9,sticky='nsew',columnspan=2)
		delRowButton.grid(col=2,row=9,sticky='nsew',columnspan=2)
		setColNameButton.grid(col=0,row=10,sticky='nsew',columnspan=2)
		setRowNameButton.grid(col=2,row=10,sticky='nsew',columnspan=2)
		hideColButton.grid(col=0,row=11,sticky='nsew',columnspan=2)
		hideRowButton.grid(col=2,row=11,sticky='nsew',columnspan=2)
		showColButton.grid(col=0,row=12,sticky='nsew',columnspan=2)
		showRowButton.grid(col=2,row=12,sticky='nsew',columnspan=2)
		setColWidthButton.grid(col=0,row=13,sticky='nsew',columnspan=2)
		setRowHeightButton.grid(col=2,row=13,sticky='nsew',columnspan=2)
		getSizeButton.grid(col=0,row=14,sticky='nsew',columnspan=2)
		getCellInfos.grid(col=2,row=14,sticky='nsew',columnspan=2)
		hideButton.grid(col=0,row=15,sticky='nsew',columnspan=2)
		showButton.grid(col=2,row=15,sticky='nsew',columnspan=2)
		
		master.rowconfigure(0,weight=1)
		master.columnconfigure(0,weight=1)
		master.columnconfigure(1,weight=1)
		master.columnconfigure(2,weight=1)
		master.columnconfigure(3,weight=1)
		
	def hide(self):
		self.table.hide()
		
	def show(self):
		self.table.show()
	
	def addText(self):
		self.table.setCell(int(self.colEnt.get()),int(self.rowEnt.get()),cellCnf={'cellType':'Text',
																'cellOptions':{'bd':2,'relief':'sunken','height':2,'width':10}})
		self.table.setValue(int(self.colEnt.get()),int(self.rowEnt.get()),self.valEnt.get())

	def addButton(self):
		self.table.setCell(int(self.colEnt.get()),int(self.rowEnt.get()),cellCnf={'cellType':'Button',
																'cellOptions':{'bd':2,'relief':'sunken','text':self.valEnt.get()}})

	def addCol(self):
		#print "addCol"
		self.table.addColumn(self.valEnt.get())
	
	def addRow(self):
		#print "addRow"
		self.table.addRow(self.valEnt.get())
	
	def delCol(self):
		#print "delCol"
		self.table.delColumn(int(self.colEnt.get()))
	
	def delRow(self):
		#print "delRow"
		self.table.delRow(int(self.rowEnt.get()))

	def setColName(self):
		self.table.setColumnName(int(self.colEnt.get()),self.valEnt.get())
		
	def setRowName(self):
		self.table.setRowName(int(self.rowEnt.get()),self.valEnt.get())
		
	def hideColTitles(self):
		self.table.hideColumnTitles()
		
	def hideRowTitles(self):
		self.table.hideRowTitles()
		
	def showColTitles(self):
		self.table.showColumnTitles()
		
	def showRowTitles(self):
		self.table.showRowTitles()
	
	def setColWidth(self):
		self.table.setColumnWidth(int(self.colEnt.get()),int(self.valEnt.get()))
		
	def setRowHeight(self):
		self.table.setRowHeight(int(self.rowEnt.get()),int(self.valEnt.get()))
		
	def getSize(self):
		self.nbColEnt.delete(0,END)
		self.nbRowEnt.delete(0,END)
		
		self.nbColEnt.insert(END,self.table.getNbrOfCols())
		self.nbRowEnt.insert(END,self.table.getNbrOfRows())
	
	def getCellInfos(self):
		self.cellInfText.delete(1.0,END)
		self.cellInfText.insert(END,"cell : "+repr(self.table.getCell(int(self.colEnt.get()),int(self.rowEnt.get())))+"\n")
		self.cellInfText.insert(END,"cell widget : "+repr(self.table.getCellWidget(int(self.colEnt.get()),int(self.rowEnt.get())))+"\n")
		self.cellInfText.insert(END,"value : "+repr(self.table.getValue(int(self.colEnt.get()),int(self.rowEnt.get()))))

def test():
	r=Tk()
	f=Frame(r)
	
	testTable(f)
	
	f.pack(expand=1,fill='both')
	r.mainloop()
	
if __name__=='__main__':
	test()		

