#!/usr/bin/env python
import sys, string
import qt
from resources import *

__version__=  '1.0.0'
__author__ =  'Alexandre Gobbo (gobbo@esrf.fr)'
  
TRUE=1
FALSE=0


class ChildWindow(qt.QWidget):
    def __init__(self,parent,name,flags=qt.Qt.WDestructiveClose):
        qt.QWidget.__init__(self,parent,name,flags)
        self.Changed=0
        self.parent=parent
        self.RepaintsWhileResizing=0
        if self.parent is not None: self.parent.windows.append (self)

        
    def closeEvent(self,ce):
        if self.Changed==0:
            ce.accept()
            if self.parent is not None: self.parent.windows.remove (self)
            return
        """
        rc = qt.QMessageBox.information(self,'Close',
                    'The document has been changed since the last save.',
                    'Save Now','Cancel','Leave Anyway',0,1)
        if rc == 0:
            self.save()            
            ce.accept()
            if self.parent is not None: self.parent.windows.remove (self)
        elif rc == 2:
            ce.accept()
            if self.parent is not None: self.parent.windows.remove (self)
        else:
            ce.ignore()
        """

    
    def repaintWhileResizing(self,flag):
        self.RepaintsWhileResizing=flag



class ApplicationWindow(qt.QMainWindow):
    def __init__(self,parent = None, name = None, fl = 0):
        qt.QMainWindow.__init__ (self, parent, name, fl)

        if qt.qVersion()>="3.0.0":
            self.mdi = qt.QWorkspace (self)
            self.mdi.setScrollBarsEnabled(TRUE)
            self.setCentralWidget (self.mdi)
        else:
            self.mdi = qt.QWorkspace (self)            
            self.setCentralWidget (self.mdi)
            self.mdi.setBackgroundColor(qt.QColor("gainsboro"))
        self.mdi.windows=[]
        self.mdi.show ()
        self.mdi.setStyle

        self.filename = qt.QString.null
        self.printer = qt.QPrinter()        
        if qt.qVersion()<"3.0.0":        
            self.openIcon = qt.QPixmap(fileopen)
            self.saveIcon = qt.QPixmap(filesave)	      
            self.printIcon = qt.QPixmap(fileprint)
        else:
            self.openIcon = qt.QIconSet(qt.QPixmap(fileopen))
            self.saveIcon = qt.QIconSet(qt.QPixmap(filesave))	      
            self.printIcon = qt.QIconSet(qt.QPixmap(fileprint))

        self.toolbar = qt.QToolBar(self,'file operations')
        self.onInitToolBar()
        self.initMenuBar()
        
        qt.QWhatsThis.whatsThisButton(self.toolbar)

        qt.QWhatsThis.add(self.fileOpen,fileOpenText)
        qt.QMimeSourceFactory.defaultFactory().setPixmap('fileopen',qt.QPixmap(fileopen))
        qt.QWhatsThis.add(self.fileSave,fileSaveText)
        qt.QWhatsThis.add(self.filePrint,filePrintText)

        
        self.statusBar().message('Ready',2000)
        self.resize(600,400)
                       

    def initMenuBar(self):
        
        self.menuFile = qt.QPopupMenu(self.menuBar())
        self.menuBar().insertItem('&File',self.menuFile)

        self.menuFile.insertItem('&New',self.onNewDoc,qt.Qt.CTRL + qt.Qt.Key_N)

        id = self.menuFile.insertItem(qt.QIconSet(self.openIcon),'&Open',self.onOpen,qt.Qt.CTRL + qt.Qt.Key_O)
        self.menuFile.setWhatsThis(id,fileOpenText)

        id = self.menuFile.insertItem(qt.QIconSet(self.saveIcon),'&Save',self.onSave,qt.Qt.CTRL + qt.Qt.Key_S)
        self.menuFile.setWhatsThis(id,fileSaveText)

        id = self.menuFile.insertItem('Save &as',self.onSaveAs)
        self.menuFile.setWhatsThis(id,fileSaveText)

        self.menuFile.insertSeparator()

        id = self.menuFile.insertItem(qt.QIconSet(self.printIcon),'&Print',self.onPrint,qt.Qt.CTRL + qt.Qt.Key_P)
        self.menuFile.setWhatsThis(id,filePrintText)

        self.menuFile.insertSeparator()

        self.menuFile.insertItem('&Quit',qt.qApp,qt.SLOT('closeAllWindows()'),qt.Qt.CTRL + qt.Qt.Key_Q)


        self.onInitMenuBar()    


        self.menuWindow = qt.QPopupMenu(self.menuBar())
        self.menuWindow.setCheckable(TRUE)
        self.connect(self.menuWindow,
                     qt.SIGNAL("aboutToShow()"),
                     self.slotWindowMenuAboutToShow)
        self.menuBar().insertItem("&Window", self.menuWindow)



        self.menuHelp = qt.QPopupMenu(self.menuBar())
        self.menuBar().insertSeparator()
        self.menuBar().insertItem('&Help',self.menuHelp)

        self.menuHelp.insertItem('&About',self.onAbout,qt.Qt.Key_F1)
        self.menuHelp.insertItem('About &Qt',self.aboutQt)



    def slotWindowMenuAboutToShow(self):
        self.menuWindow.clear()
        if len(self.mdi.windowList())==0: return
        self.menuWindow.insertItem('&Cascade',self.cascade)
        self.menuWindow.insertItem('&Tile',self.mdi.tile)
        self.menuWindow.insertItem('&Tile Horizontally',self.tilehoriz)
        self.menuWindow.insertItem('&Tile Vertically',self.tilevertic)
        self.menuWindow.insertSeparator()
        

        i=0 # window numbering
        self.menuToWindowMap={}
        for window in self.mdi.windowList():
            i=i+1
            index=self.menuWindow.insertItem(("&%i " % i) +
                                             str(window.caption()),
                                             self.slotWindowMenuActivated)
            self.menuToWindowMap[index]=window
            if self.mdi.activeWindow()==window:
                self.menuWindow.setItemChecked(index, TRUE)

    def slotWindowMenuActivated(self, index):
        self.menuToWindowMap[index].setFocus()

    def cascade(self):
        self.mdi.cascade()
        for window in self.mdi.windowList():
            window.resize(0.7*self.mdi.width(),0.7*self.mdi.height())

    def tilehoriz(self):
        nbVisibleWindows=0
	for window in self.mdi.windowList():
		if window.isVisible():
			nbVisibleWindows=nbVisibleWindows+1
	windowheight=float(self.mdi.height())/nbVisibleWindows
        i=0
        for window in self.mdi.windowList():
	    if window.isVisible():
	    	window.parentWidget().showNormal()
            	window.parentWidget().setGeometry(0,int(windowheight*i),self.mdi.width(),int(windowheight))
		window.parentWidget().raiseW()
            	i=i+1
        self.mdi.update()
        self.update()
            
            
    def tilevertic(self):
        nbVisibleWindows=0
	for window in self.mdi.windowList():
		if window.isVisible():
			nbVisibleWindows=nbVisibleWindows+1
	windowwidth=float(self.mdi.width())/nbVisibleWindows
        i=0
        for window in self.mdi.windowList():
	    if window.isVisible():
            	window.parentWidget().showNormal()
            	window.parentWidget().setGeometry(int(windowwidth*i),0,int(windowwidth),self.mdi.height())
            	window.parentWidget().raiseW()
            	i=i+1
        self.mdi.update()
        self.update()
        
    
    def closeEvent(self,ce):
        ce.accept()


    def aboutQt(self):
        qt.QMessageBox.aboutQt(self,'About Qt')


    #----------------------------
    #View operations
    #----------------------------

    def onInitMenuBar(self):
        pass

    def onInitToolBar(self):
        self.fileOpen = qt.QToolButton(self.openIcon,'Open File',qt.QString.null,self.onOpen,self.toolbar,'open file')
        self.fileSave = qt.QToolButton(self.saveIcon,'Save File',qt.QString.null,self.onSave,self.toolbar,'save file')
        self.filePrint = qt.QToolButton(self.printIcon,'Print File',qt.QString.null,self.onPrint,self.toolbar,'print file')

    def onNewDoc(self):
        w = ChildWindow (self.mdi, "window", qt.Qt.WDestructiveClose)
        w.show ()
        return w
                
    
    def onOpen(self):
        pass

    def onSave(self):
        pass
    
    def onSaveAs(self):
        pass
    
    def onPrint(self):
        pass

    def onAbout(self):
        qt.QMessageBox.about(self,'MDI',
            'MDI Application Framework\nVersion: '+ __version__)



class MDIApp(qt.QApplication):
    #Defined to control the use of child windows not redrawables during resizing
    def __init__(self,*args,**key):
        qt.QApplication.__init__(self,*args,**key)
        self.ToplevelMouseDown = 0
        self.ToplevelIgnoreResize = 0
        self.ToplevelSaveObject = None        
        self.installEventFilter( self )


    def eventFilter(self,o,e):
        type=e.type()
    
        if type==qt.QEvent.MouseButtonPress:
            self.ToplevelMouseDown = 1
            self.ToplevelIgnoreResize = 0
            self.ToplevelSaveObject = None
            self.ToplevelSaveEvent = None

        elif type==qt.QEvent.MouseButtonRelease:
            self.ToplevelMouseDown = 0
            if self.ToplevelIgnoreResize and self.ToplevelSaveObject is not None:
                self.ToplevelIgnoreResize = 0
                qt.QApplication.postEvent(self.ToplevelSaveObject, self.ToplevelSaveEvent)
                self.ToplevelIgnoreResize = 0
                self.ToplevelSaveObject=None
        elif type==qt.QEvent.Resize:
                if self.ToplevelMouseDown and isinstance(o,ChildWindow) and o.RepaintsWhileResizing==0:
                    self.ToplevelIgnoreResize = 1
                    self.ToplevelSaveObject=o
                    self.ToplevelSaveEvent = qt.QResizeEvent(e.size(),e.oldSize())
                    return 1
        return qt.QApplication.eventFilter(self, o, e )


if __name__ == "__main__":
    app = MDIApp(sys.argv)
    mw = ApplicationWindow()
    mw.setCaption('Document 1')
    app.setMainWidget (mw)
    mw.show()
    app.connect(app, qt.SIGNAL('lastWindowClosed()'), app, qt.SLOT('quit()'))
    app.exec_loop()
