""" Useful things. """
# (mcb) June, 1999




from types import *
from string import split
import os




#
# some global switches (these should be implemented in a custom module
# later ...)
#
ut_PRINT_DEPTH  =    20
ut_PRINT_ON     =     1




#
# some useful constants
#
TRUE     =   1
FALSE    =   0

ON       =   1
OFF      =   0

YES      =   1
NO       =  -1
UNKNOWN  =   0




#
# print traceback
#
def utPrintTraceback():
	print '- ut', '-'*62, 'ut -'
	import traceback
	traceback.print_exc()
	print '- ut', '-'*62, 'ut -'




def utInstance(x_name, x_class, x_args, x_module):
	inst_code =    'from ' + x_module + ' import ' + x_class + '\n' \
               + 'x_instance=' + x_class + x_args + '\n' \
               + 'x_instance' + '._inst=\"' + x_name + '\"\n'
	exec inst_code 
	return x_instance	




def ute(x):
	return "print \'(CheckValue: " + x + " = \' + `" + x + "` + \')\'"




def utPrintOn():
	global utP, utp, utI, uti, utA, uta
	def utP(x):
		print x
	def utp(x):
		print x,
	def utI(x):
		if not type(x) is StringType:
			x = `x`
		print '(Info: ' + x + ')'
	def uti(x):
		if not type(x) is StringType:
			x = `x`
		print '(Info: ' + x + ')',
	def utA(w, x):
		if not type(x) is StringType:
			x = `x`
		print '(' + w + ': ' + x + ')',
	def uta(w, x):
		if not type(x) is StringType:
			x = `x`
		print '(' + w + ': ' + x + ')',




def utPrintOff():
	global utP, utp, utI, uti, utA, uta
	def utP(x):
		pass
	def utp(x):
		pass
	def utI(x):
		pass
	def uti(x):
		pass
	def utA(x):
		pass
	def uta(x):
		pass



#
# print a long line
#
def utPrintLongLine(line, wraplen = 72, indent = 0, lineindent = 0):
	indentStr = ' '*indent
	lineIndentStr = ' '*lineindent
	cut = 0
	linelen = len(line)
	print "%s[%s]" % (lineIndentStr, line[cut:min(cut+wraplen,linelen)])
	cut = cut + wraplen
	while cut < linelen:
		print "%s%s[%s]" % (lineIndentStr, indentStr,
		                    line[cut:min(cut+wraplen-indent,linelen)])
		cut = cut + wraplen - indent
	return

#
# print what's in a class instance
#
def utPrintRecursor(obj, maxdepth, depth = 0, indent = 0):
	""" Print an object.

	This function prints value of an object.
	If the object is a class instance it tries to print all its
	attributes (recursively). """

	if maxdepth < 0 or depth > maxdepth:
		print ' '*indent + '(maximum depth reached)'
		return

	theType = type(obj)
	if ListType is theType:
		print ' '*indent + 'List: '
		for item in obj:
			utPrintRecursor(item, maxdepth, depth + 1, indent + 2)
		print ' '*indent + ':EndOfList'
	elif DictType is theType:
		print ' '*indent + 'Dict: '
		for item in obj.keys():
			print ' '*(indent + 2) + 'key: ' + item
			utPrintRecursor(obj[item], maxdepth, depth + 1, indent + 2)
		print ' '*indent + ':EndOfDict'
	elif InstanceType is theType:
		print ' '*indent + `obj`
		whatWeHave = dir(obj)
		for item in whatWeHave:
			someThing = getattr(obj, item)
			utPrintRecursor(someThing, maxdepth, depth + 1, indent + 2)
	else:
		print ' '*indent + `obj`

	return




#
# Some handy little functions to query recursive dictionaries and
# dealing with periode separated reference or path names respectively
#
def utRef2List(branch):
	if '.' == branch[0] or '.' == branch[-1]:
		return None
	else:
		return split(branch, '.')




def utKeys2Thing(keys, dc):
	thing = dc
	try:
		for k in keys:
			thing = thing[k]
		return thing
	except:
		return None




def utRef2Thing(branch, dc):
	if '.' == branch[0] or '.' == branch[-1]:
		return None
	else:
		keys = split(branch, '.')
		thing = dc
		try:
			for k in keys:
				thing = thing[k]
			return thing
		except:
			return None




#
# selectively activate definitions
#
if ut_PRINT_ON:
	utPrintOn()
else:
	utPrintOff()
