/*               SaxsRoutine.h V1.15 by Peter Boesecke July 2001           */
/****************************************************************************
* SaxsRoutine.h                                                             *
****************************************************************************/

#ifndef SAXS_ROUTINE
# define SAXS_ROUTINE

# include "SaxsImage.h"

  extern void
     ArgvFilenames         ( CmdBlk * pcb, ImgBlk ib[], ImgHeadBlk ihb[],
                             int block_1st, int block_lst, int * pstatus),
     GetLinearOverlap     (  CmdBlk *pcb,      ImgHeadBlk ihb[],
                             int   coordinate, int   OutImage,
                             int   MinImage,   int   MaxImage,
                             int   WminInI,    float WminIn,
                             int   WmaxInI,    float WmaxIn,
                             float Off[],      float Ps[],
                             float fmin[],     float fmax[],
                             float *Wmin,      float *Wmax ),
     GetImageOverlap       ( CmdBlk * pcb, ImgHeadBlk ihb[],
                             int MinImage, int MaxImage,
                             float Off_1[], float Off_2[],
                             float Ps_1[],  float Ps_2[],
                             float fmin_1[], float fmax_1[],
                             float fmin_2[], float fmax_2[],
                             float * Wmin_1, float * Wmax_1,
                             float * Wmin_2, float * Wmax_2),
     GetReferenceParameters( CmdBlk * pcb, ImgHeadBlk ihb[],
                             int MinImage, int MaxImage,
                             float Off_1[], float Off_2[],
                             float Ps_1[],  float Ps_2[],
                             int * pstatus ),
     GetReference          ( long RSys, int blockno, ImgHeadBlk ihb[],
                             float * Off_1, float * Off_2,
                             float * Ps_1,  float * Ps_2,
                             int * pstatus ),
     Ipol2                 ( float *Data, int Dim_1, int Dim_2,
                             float f_1, float f_2, float *value),
     TransformFloat2d      ( float *data, long int dim_1, long int dim_2,
                             float dummy, float ddummy,
                             float factor, float constant ),
     ClipFloat2d           ( float *data, long int dim_1, long int dim_2,
                             float dummy, float ddummy,
                             float minclip, int minclipI,
                             float maxclip, int maxclipI ),
     RebinFloat2d          ( float * dataIn, float * dataOut,
                             long int * dim_1, long int * dim_2,
                             float dummy, float ddummy,
                             long int bin_1, long int bin_2),
     GnawFloat2d           ( float * data,
                             long int dim_1, long int dim_2,
                             float dummy, float ddummy,
                             long int gnaw_1, long int gnaw_2,
                             int * pstatus ),
     AffineFloat2d         ( float *data, long int dim_1, long int dim_2,
                             float dummy, float ddummy,
                             float *out, long int odim_1, long int odim_2,
                             float odummy, double t[3][2], int isw, 
                             int *pstatus ),
     Affine               (  CmdBlk * pcb, ImgHeadBlk ihb[],
                             int InputBlock, int OutputBlock,
                             double t[3][2], int * pstatus );
  extern int
    Ipol2ldw               ( float *Data, int Dim_1, int Dim_2,
                             float Dummy, float DDummy,
                             float f_1, float f_2, float *sum, float *weight),
    Ipol2ld                ( float *Data, int Dim_1, int Dim_2,
                             float Dummy, float DDummy,
                             float f_1, float f_2, float *value),
    Ipol2d                 ( float *Data, int Dim_1, int Dim_2,
                             float Dummy, float DDummy,
                             float f_1, float f_2, float *value),
    copy_amat              ( double t[3][2], double p[3][2] ),
    invert_amat            ( double t[3][2], double p[3][2] );
  extern float
   RowProjection           ( float *line, long int dim, float initvalue,
                             float *data, long int dim_1, long int dim_2,
                             float dummy, float ddummy,
                             float f_21, float f_22, int mode, int testbit),
   ColProjection           ( float *line, long int dim, float initvalue,
                             float *data, long int dim_1, long int dim_2,
                             float dummy, float ddummy,
                             float f_11, float f_12, int mode, int testbit);
  extern char
    *SaxsRoutineVersion    ( void );

#endif /* SAXS_ROUTINE */

/****************************************************************************
*                                                                           *
****************************************************************************/
