from PyDisWindow import *
from PyDVT.View import View
from PyDVT.FitFilter import FitFilter
from PyDVT.Binding import FitParametersDialog
import PyDVT

__version__=  '1.0.1'
__author__ =  'Alexandre Gobbo (gobbo@esrf.fr)'


class PyDisFit1D(Plugin):
    ########################################################
    ### Virtuals
    ########################################################
    def OnFinishInit (self,app_window):
        self.app_window=app_window
            

    def OnInitWindowPopupMenu (self,window):
        if isinstance(window.View,PyDVT.GraphView.GraphView):
            window.View.AddMenuSeparator()
            window.View.AddMenuPopupItem("Add Fit",Command.Command(self.AddFit,window))
        
    def GetInfoString(self):
        return "v. "+__version__

    ########################################################
    ### Private methods
    ########################################################
    def AddFit(self,window):
        if hasattr(window,"ParDlg")==0 or window.ParDlg.View is None:
            window.fit_filter=FitFilter(window.Filter)
            window.ParDlg=FitParsWindow (self.app_window.mdi,FitParsView,'Fit Parameters - '+ str(window.caption()),{},master_window=window)
            window.fit_filter.ConnectParameterEditor(window.ParDlg.View.Drawable)
            window.View.SetSource((window.Filter,GraphView.GraphFilter("G2",window.fit_filter,pen=Pen((255,0,0),0,"solid"))))
    	



class FitParsView(View):
    def CreateDrawable(self):
        self.Drawable=FitParametersDialog(self.parent,None)	
        self.Drawable.Show()

    def resizeEvent(self,e):
        self.Drawable.resize(self.width(),self.height())        

class FitParsWindow(ViewWindow):
    def closeEvent(self,ce):
        self.master_window.View.SetSource(self.master_window.Filter)
        ViewWindow.closeEvent(self,ce)


plugin=PyDisFit1D()
