import sys, qt
sys.path.insert(0,'../.')

from PyDisWindow import Plugin
from TrackingParametersDialog import TrackingParametersDialog

__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'
__date__= '19/11/2002'

DEBUG=0

class Py4datTrackingPlugin(Plugin):
    	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		if DEBUG: print 'In Py4datTrackingPlugin.OnStartInit...'
		return 1

     	def OnInitMenuBar (self,menu_bar):
        	if DEBUG: print 'In Py4datTrackingPlugin.OnInitMenuBar...'
		self.menu_plugin = qt.QPopupMenu(menu_bar)
        	self.menu_plugin.insertItem('Tracking Parameters',self.TrackingParameters)
        	menu_bar.insertItem('&Tracking',self.menu_plugin)
		
    	def OnFinishInit (self,app_window):
        	if DEBUG: print 'In Py4datTrackingPlugin.OnFinishInit...'
		self.app_window=app_window
		self.app_window.RTrackingFlag=0
		self.app_window.RTrackingWidth=10
		self.app_window.RTrackingStep=2
		self.app_window.PhiTrackingFlag=0
		self.app_window.PhiTrackingWidth=10
		self.app_window.PhiTrackingStep=2

	def GetInfoString (self):
		return "v. "+__version__

    	########################################################
    	### Private methods
    	########################################################	
			
	################## Change TrackingParameters ################################################
	
	def TrackingParameters(self):	
		if DEBUG: print 'In Py4datTrackingPlugin.TrackingParameters...'
		dial=TrackingParametersDialog(None,\
			{'RTrackingFlag':self.app_window.RTrackingFlag,'RTrackingWidth':self.app_window.RTrackingWidth,'RStep':self.app_window.RTrackingStep,\
			 'PhiTrackingFlag':self.app_window.PhiTrackingFlag,'PhiTrackingWidth':self.app_window.PhiTrackingWidth,'PhiStep':self.app_window.PhiTrackingStep})	
		if dial.dlg.result()==0: return
		self.app_window.RTrackingFlag=dial.RTrackingFlag
		self.app_window.RTrackingWidth=dial.RTrackingWidth
		self.app_window.RTrackingStep=dial.RStep
		self.app_window.PhiTrackingFlag=dial.PhiTrackingFlag
		self.app_window.PhiTrackingWidth=dial.PhiTrackingWidth
		self.app_window.PhiTrackingStep=dial.PhiStep
	
		
plugin=Py4datTrackingPlugin()
