import string,os,sys
sys.path.insert(0,'../')
sys.path.insert(0,'.')

from PyDisWindow import Plugin,ViewWindow
from PyDVT.GraphView import GraphFilter
from PyDVT.ImageView import ColormapFilter
import PyDVT.ExtendedGraphView as ExtendedGraphView
import PyDVT.ExtendedImageView as ExtendedImageView
import PyDVT.DataSelection as DataSelection
import PyDVT.EdfFileData as EdfFileData
from scidxp.util import DefaultGroupNode
from DataWrapper import DataToGroupNode
from SciDXPData import SciDXPData
from ReadMccdFile import ReadMccdFileGroupNode

__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'
__date__= '20/09/2002'
__lastModif__='23/09/2002'

DEBUG=0

class Py4datMccdPlugin(Plugin):
    	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		if DEBUG: print 'In Py4datMccdPlugin.OnStartInit...'
		return 1

    	def OnFinishInit (self,app_window):
        	if DEBUG: print 'In Py4datMccdPlugin.OnFinishInit...'
		self.app_window=app_window
	
	def OnFileOpen (self,filename,format_string):
        	if DEBUG: print 'In Py4datMccdPlugin.OnFileOpen...'
		type=string.upper(format_string)
            	short_name= os.path.split(filename)[1]
            	print string.upper(type)[0:4]
		if string.upper(type)[0:4]=="MCCD":
			inputGroupNode=ReadMccdFileGroupNode(filename)
			inputDataSetNode=inputGroupNode.getChild(inputGroupNode.getChildren().keys()[0])
			size=len(inputDataSetNode.getData().getData().shape)
			if size==1: window=ViewWindow (self.app_window.mdi,ExtendedGraphView.ExtendedGraphView,short_name)
			elif size ==2: window=ViewWindow (self.app_window.mdi,ExtendedImageView.ExtendedImageView,short_name)
			else: return
                	window.shortName=short_name
                	window.fileName=filename
			sciData=SciDXPData()
                	window.Data=sciData
                	window.Data.SetSource(inputDataSetNode)
                	if size==1:
				window.DataSelection=DataSelection.OrthoLineSelection(window.Data)
                		window.Filter=GraphFilter(None,window.DataSelection)
				self.app_window.Set1DViewMenu(window)
			elif size==2: 
				window.DataSelection=DataSelection.RectSelection(window.Data)
				window.Filter=ColormapFilter(None,window.DataSelection)
				self.app_window.Set2DViewMenu(window)
			else: return
                	window.View.SetSource(window.Filter)
                	info=window.Data.GetSourceInfo()
                	window.NumImages=info["Size"]
                	window.Data.LoadSource()
	
	def OnFileSave (self,window,filename,format_string):
        	if DEBUG: print 'In Py4datMccdPlugin.OnFileSave...'
		pass
	
	def GetOpenFormatList(self):
        	if DEBUG: print 'In Py4datMccdPlugin.GetOpenFormatList...'
		return ["MCCD files (*.mccd)"]
		
	def GetSaveFormatList(self,window):
        	if DEBUG: print 'In Py4datMccdPlugin.GetSaveFormatList...'
		return ["MCCD files (*.mccd)"]

	def GetInfoString(self):
		return "v. "+__version__
	

			
plugin=Py4datMccdPlugin()
