from qt import *
import Command,types,Numeric
from PyDisWindow import Plugin,ViewWindow
from PyDVT.Binding import Pen
import PyDVT.View as View
import PyDVT.ImageView as ImageView
import PyDVT.ImageViewSelect as ImageViewSelect
from PyDVT.ImageViewSelect import ImageViewSelectRect
import PyDVT.DataSelection as DataSelection
import PyDVT.GraphView as GraphView
import PyDVT.ExtendedImageView as ExtendedImageView
from AzimIntFilter import AzimIntFilter
from IntegrateQFilter import IntegrateQFilter
from IntegratePhiFilter import IntegratePhiFilter
from Py4datMaskFilter import Py4datMaskFilter
from Py4datImageViewSelect import ViewSelectPolygon
from Py4datImageViewSelect import ImageViewSelectMultiplePoints
from AzimParametersDialog import AzimParametersDialog
from FindCentreFunction import FindCentreFunction

__version__=  '1.0.0'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'

DEBUG=0

class Py4dat2DTransformPlugin(Plugin):
    	########################################################
    	### Virtuals
    	########################################################
    	def OnStartInit (self):
		if DEBUG: print 'In Py4dat2DTransformPlugin.OnStartInit...'
		return 1

    	def OnFinishInit (self,app_window):
        	if DEBUG: print 'In Py4dat2DTransformPlugin.OnFinishInit...'
		self.app_window=app_window

    	def OnInitWindowPopupMenu (self,window):
    		if DEBUG: print 'In Py4dat2DTransformPlugin.OnInitWindowPopupMenu...'
		if isinstance(window.View,ImageView.ImageView) == 1:
			window.Mask=None
			window.View.AddMenuSeparator()
			window.View.AddMenuPopupItem("Add mask Rectangle",Command.Command(self.MaskDefine,window))
			window.View.AddMenuPopupItem("Add mask Polygon",Command.Command(self.Polygon,window))
			window.View.AddMenuPopupItem("Del Masks",Command.Command(self.DelMasks,window))
			window.View.AddMenuSeparator()
			if window.master_window==None or window.name[0:9]=='Transform':
				window.pixelsize=(0.01,0.01)
				window.offset=(0.0,0.0)
				window.center=(256,256)	
				window.distance=50000
				window.wavelength=1000
				window.View.AddMenuPopupItem("Image Parameters",Command.Command(self.ChangeParameters,window))
				window.View.AddMenuPopupItem("Set centre by clicks",Command.Command(self.ClicksCentre,window))
				window.View.AddMenuPopupItem("AzimInt",Command.Command(self.AzimInt,window))				
			window.View.AddMenuPopupItem("I(Phi)",Command.Command(self.IPhi,window))
			window.View.AddMenuPopupItem("I(q)",Command.Command(self.Iq,window))
			
	def GetInfoString(self):
		return "v. "+__version__
	
    	########################################################
    	### Private methods
    	########################################################

	def UpdateViews(self,window):
		if DEBUG: print 'In Py4dat2DTransformPlugin.UpdateViews...'
		if window.name[0:7]=='AzimInt':
			integratePhiWindow=self.app_window.GetWindow('I(Phi) - '+ window.name)
			integrateqWindow=self.app_window.GetWindow('I(q) - '+ window.name)
			if integratePhiWindow != None:
				self.IPhi(window)
			if integrateqWindow != None: 
				self.Iq(window)
		else:
			azimIntWindow=self.app_window.GetWindow('AzimInt - '+ window.name)
			integratePhiWindow=self.app_window.GetWindow('I(Phi) - AzimInt - '+ window.name)
			integrateqWindow=self.app_window.GetWindow('I(q) - AzimInt - '+ window.name)
			if azimIntWindow != None: 
				self.AzimInt(window)
				if hasattr(azimIntWindow,'Mask') and type(azimIntWindow.Mask)!=types.NoneType: 
					dataFilter=azimIntWindow.Filter
					if dataFilter==None: return
					maskedImage=Py4datMaskFilter(dataFilter)
					colormap=ImageView.ColormapFilter("colormap",maskedImage)
					azimIntWindow.View.SetSource(colormap)
					azimIntWindow.View.GetSource()[0].GetSource().SetMask(azimIntWindow.Mask)
				if integratePhiWindow != None:
					self.IPhi(azimIntWindow)
				if integrateqWindow != None: 
					self.Iq(azimIntWindow)

	############## AZIM INT ################################################
    
    	def AzimInt(self,window):
    		if DEBUG: print 'In Py4dat2DTransformPlugin.AzimInt...'
		#dataSize=window.View.GetSource()[0].GetOutput()['data'].shape
		#window.center=(dataSize[0]/2.,dataSize[1]/2.)
    		azimWindow=self.app_window.GetWindow('AzimInt - '+ window.name)
		if azimWindow is None:
			azimWindow=ViewWindow (self.app_window.mdi,ExtendedImageView.ExtendedImageView,name='AzimInt - '+ window.name,view_pars={"UseImageValues":1},master_window=window)
			azimWindow.SetTitle(azimWindow.name)
			self.app_window.Set2DViewMenu(azimWindow)
    		azimWindow.DataSelection=window.View.Source[0]
		azimWindow.Filter=ImageView.ColormapFilter(None,AzimIntFilter(azimWindow.DataSelection,buffer_input=1,pixelsize=window.pixelsize,offset=window.offset,center=window.center))
    		azimWindow.Filter.SetColormapParameters(window.Filter.GetColormapParameters())
    		azimWindow.View.SetSource(azimWindow.Filter)

	################## INTEGRATE  I(Phi)################################################

	def IPhi(self,window):
		if DEBUG: print 'In Py4dat2DTransformPlugin.IPhi...'
		IPhiWindow=self.app_window.GetWindow('I(Phi) - '+ window.name)
		if window.View.Source!=() :				
			if IPhiWindow is None:
    				IPhiWindow=ViewWindow (self.app_window.mdi,GraphView.GraphView,name='I(Phi) - '+ window.name,master_window=window)
				IPhiWindow.SetTitle(None,prefix="I(Phi) - ")
				self.app_window.Set1DViewMenu(IPhiWindow)
			IPhiWindow.DataSelection=window.View.Source[0]
			IPhiWindow.Filter=IntegratePhiFilter("IPhi",IPhiWindow.DataSelection,parentWindow=window,pen=Pen((0,128,0),0,"solid"))
			IPhiWindow.View.SetLabels(x_label='Phi (degrees)',y_label='I')
			IPhiWindow.View.SetSource(IPhiWindow.Filter)
	
	################## I(q) ################################################
	
	def Iq(self,window):
		if DEBUG: print 'In Py4dat2DTransformPlugin.Iq...'
		IqWindow=self.app_window.GetWindow('I(q) - '+ window.name)
		SourceWindow=self.GetSourceWindow()
		if (window.View.Source!=()):
			if IqWindow is None:
    				IqWindow=ViewWindow (self.app_window.mdi,GraphView.GraphView,'I(q) - '+ window.name,{"AddStyleSelect":1,"AddCursorSelect":1,"AddStatus":1,"AutoHideStatus":1},master_window=window)
				IqWindow.SetTitle(None,prefix="I(q) - ")
				self.app_window.Set1DViewMenu(IqWindow)
				IqWindow.View.SetStyle("PointsLine")
			IqWindow.DataSelection=window.View.Source[0]
			IqWindow.Filter=IntegrateQFilter("Iq",IqWindow.DataSelection,pen=Pen((0,128,0),0,"solid"), wavelength=SourceWindow.wavelength, distance=SourceWindow.distance)
			IqWindow.View.SetLabels(x_label='q (1/angstroms)',y_label='I')
			IqWindow.View.SetSource(IqWindow.Filter)
			
	################## Change Parameters ################################################
	
	def ChangeParameters(self,window):	
		if DEBUG: print 'In Py4dat2DTransformPlugin.ChangeParameters...'
		dial=AzimParametersDialog(None,{'pixelsizeX':window.pixelsize[0],'pixelsizeY':window.pixelsize[1],'offsetX':window.offset[0],'offsetY':window.offset[1],'centerX':window.center[0],'centerY':window.center[1],'wavelength':window.wavelength,'distance':window.distance})	
		if dial.dlg.result==0: return
		window.pixelsize=(dial.pixelsizeX,dial.pixelsizeY)
		window.offset=(dial.offsetX,dial.offsetY)
		window.center=(dial.centerX,dial.centerY)
		window.wavelength=dial.wavelength
		window.distance=dial.distance
		if DEBUG: print  'pixelsize=',window.pixelsize,'offset=',window.offset,'center=',window.center, 'wavelength=',window.wavelength,'distance=',window.distance
		self.UpdateViews(window)

	################## Find Centre ################################################
		
	def ClicksCentre(self,window):	
		if DEBUG: print 'In Py4dat2DTransformPlugin.ClicksCentre...'
		self.CentreClicks=[]
		if (window.View.Source!=()):
			dataFilter=window.Filter
			if dataFilter==None: return
			if hasattr(window.View,"PointsSelect") and window.View.PointsSelect is not None:
				window.View.PointsSelect.Destroy()
			window.View.PointsSelect=ImageViewSelectMultiplePoints(dataFilter,self.EventPointsSelection)
			window.View.PointsSelect.ConnectView(window.View)
		self.UpdateViews(window)

	def EventPointsSelection(self,source):
		if DEBUG: print 'In Py4dat2DTransformPlugin.EventPointsSelection...' 
		window=self.app_window.mdi.activeWindow()
		i=0
		while i<len(source.GetSelection()['Points']):
			(xi,yi)=(source.GetSelection()['Points'][i].PageCoord)
			self.CentreClicks.append((xi,yi))
			i=i+1
		print self.CentreClicks
		if len(self.CentreClicks)==1:
			window.center=self.CentreClicks[0]
		elif len(self.CentreClicks)==2:	
			window.center=((self.CentreClicks[0][0]+self.CentreClicks[1][0])/2,(self.CentreClicks[0][1]+self.CentreClicks[1][1])/2) 
			if DEBUG: print window.center
		elif len(self.CentreClicks)==3:
			window.center = FindCentreFunction(self.CentreClicks)	
		else: print 'Wrong number of points: select 1, 2 or 3 points'
		print 'Centre coordinates:',window.center
		source.Disable()
		self.UpdateViews(window)
		self.ClearPointsSelect()
		
	def ClearPointsSelect(self):
        	window=self.app_window.mdi.activeWindow()
		if (window.View.PointsSelect is not None):
          		window.View.PointsSelect.Destroy()
          		window.View.PointsSelect=None
			
			
	############## MASK ################################################
		
	def SetMask(self, val=None, rect=None):
		window=self.app_window.mdi.activeWindow()
		window.View.Drawable.SetMask (val=val,rect=rect)
	
	def DelMasks(self,window):
		data=window.View.GetSource()[0].GetOutput()['data']
		window.View.GetSource()[0].GetSource().SetMask(Numeric.ones(data.shape,data.typecode()))
		window.View.Refresh()
		self.UpdateViews(window)
		window.Mask=None
	
	def MaskDefine(self,window):
		if (window.View.Source!=()):
			#data=window.View.Source[0].GetData()
			dataFilter=window.Filter
			if dataFilter==None: return
			if type(window.Mask)==types.NoneType:
				#maskedImage=Py4datMaskFilter(DataSelection.RectSelection(dataFilter))
				maskedImage=Py4datMaskFilter(dataFilter)
				colormap=ImageView.ColormapFilter("colormap",maskedImage)
				window.View.SetSource(colormap)
			window.View.MaskSelect=ImageViewSelectRect(dataFilter,self.EventMaskSelection)
			window.View.MaskSelect.ConnectView(window.View)	
			
	def EventMaskSelection(self,source):
		window=self.app_window.mdi.activeWindow()
		if (window.View.Source != ()) and (window.View.Source[0] != None):
			if type(window.Mask)==types.NoneType:
				#window.Mask=Numeric.ones(window.View.Source[0].GetData().Pages[0].Array.shape)
				window.Mask=Numeric.ones(window.View.Source[0].GetOutput()['data'].shape)
			data=window.View.GetSource()[0].GetOutput()['data']
          		if window.View.GetSource()[0]==None:
             			window.View.ClearMaskSelect(window)
              			return
          		window.View.MaskSelect.EraseSelection(window.View)
          		(p0,p1)=source.GetSelection()["BoundingRect"]
          		(x0,y0),(x1,y1)=window.View.Source[0].DataCoord2SelectionCoord(p0),window.View.Source[0].DataCoord2SelectionCoord(p1)
          		rect=(min(x0,x1),min(y0,y1),max(x0,x1),max(y0,y1))
			x,y=x0,y0
			while x < x1:
				while y < y1:
					window.Mask[y,x]=0.
					y=y+1
				x,y=x+1,y0
			window.View.GetSource()[0].GetSource().SetMask(window.Mask)
			window.View.Refresh()
			self.UpdateViews(window)
			self.ClearMaskSelect(window)

	def ClearMaskSelect(self,window):
        	if (window.View.MaskSelect is not None):
          		window.View.MaskSelect.Destroy()
          		window.View.MaskSelect=None    

	################## POLYGON ################################################
		
	def Polygon(self,window):
		if (window.View.Source!=()):
			#data=window.View.Source[0].GetData()
			dataFilter=window.Filter
			if dataFilter==None: return
			if type(window.Mask)==types.NoneType:
				maskedImage=Py4datMaskFilter(dataFilter)
				colormap=ImageView.ColormapFilter("colormap",maskedImage)
				window.View.SetSource(colormap)
			if hasattr(window.View,"PolygonSelect") and window.View.PolygonSelect is not None:
				window.View.PolygonSelect.Destroy()
			window.View.PolygonSelect=ViewSelectPolygon(dataFilter,self.EventPolygonSelection)
			window.View.PolygonSelect.ConnectView(window.View)
			
	def EventPolygonSelection(self,source):
		window=self.app_window.mdi.activeWindow()
		if type(window.Mask)==types.NoneType:
				window.Mask=Numeric.ones(window.View.Source[0].GetOutput()['data'].shape)
		nbSites=len(source.GetSelection()['Polygon'])-1
		listx,listy=[],[]
		for position in source.GetSelection()['Polygon']:
			listx.append(position.PageCoord[0]),listy.append(position.PageCoord[1])
		xmin,ymin,xmax,ymax=min(listx),min(listy),max(listx),max(listy)
		x=xmin
		while x < xmax:	
			y=ymin
			while y < ymax:
				i=0
				intersection=0
				while i < nbSites:
					try:
						(xi,yi)=(source.GetSelection()['Polygon'][i].PageCoord)
						if i<nbSites-1: (xinext,yinext)=(source.GetSelection()['Polygon'][i+1].PageCoord)
						elif i==nbSites-1:(xinext,yinext)=(source.GetSelection()['Polygon'][0].PageCoord)
						a=(yinext-yi)*1./(xinext-xi)
						b=(yi*xinext-yinext*xi)*1./(xinext-xi)
						c=(y*1./x)
						xj=b/(c-a)
						yj=(c*b)/(c-a)
						if xj>min(xi,xinext) and xj<max(xi,xinext) and yj>min(yi,yinext) and yj<max(yi,yinext) and xj<x and yj<y:
							intersection=intersection+1
						i=i+1
					except:
						i=i+1
						continue
				if intersection % 2==0: pass
				else:
					window.Mask[y,x]=0.
				y=y+1
			x=x+1
		window.View.GetSource()[0].GetSource().SetMask(window.Mask)
		window.View.Refresh()
		source.Disable()
		self.UpdateViews(window)
		self.ClearPolygonSelect()
		
	def ClearPolygonSelect(self):
        	window=self.app_window.mdi.activeWindow()
		if (window.View.PolygonSelect is not None):
          		window.View.PolygonSelect.Destroy()
          		window.View.PolygonSelect=None

	def GetSourceWindow(self):
		window=self.app_window.mdi.activeWindow()
		while window.master_window!=None:
			window=window.master_window
		return window

plugin=Py4dat2DTransformPlugin()
