import saxs,array,types,math
from Numeric import *
from qt import *
from PyDVT.ExtendedImageView import *
from Py4datGraphView import *
from scidxp.util import *
import ReadEdfFile
from WriteEdfFile import *
from PyDVT.Filter import *
#from PyDVT.Data import *
from PyDVT.GraphViewSelect import *
import PyDVT.ImageViewSelect
import Py4datImageViewSelect
import PyDVT.DataSelection as DataSelection
import DataWrapper
from SciDXPData import *
from Py4datMaskFilter import Py4datMaskFilter


DEBUG=0

class Py4datDisplay(DefaultDataSetNode):
	def __init__(self,inputDataSetNode):
		#try:
			DefaultDataSetNode.__init__(self,'',DefaultArray([0]))
			arr=inputDataSetNode.getData().getData()
			root=qt.QApplication(sys.argv)
			dvt_data=SciDXPData()
			dvt_data.SetSource(inputDataSetNode)
			dvt_data.LoadSource()
			#print 'dvt_data:', type(dvt_data.Pages[0].Array)
			#if type(dvt_data.Pages[0].Array)==types.InstanceType: dvt_data.Pages[0].Array=dvt_data.Pages[0].Array.getData()
			if len(arr.shape)==1:
				view=Py4datGraphView(None)
				#print 'attributes keys=',inputDataSetNode.getAttributes().keys()
				if 'xdata' in inputDataSetNode.getAttributes().keys() and inputDataSetNode.getAttribute('xdata')!=None:
					print 'XAxis detected'
					xaxis = Numeric.array(eval(inputDataSetNode.getAttribute('xdata').__repr__()))
					#print type(xaxis),len(xaxis),len(arr)
					GraphData=Graph(arr, xdata=xaxis)
				else: 
					GraphData=GraphFilter("Graph",OrthoLineSelection(dvt_data),pen=Pen((255,0,0),0,"solid"))
					#GraphData=Graph(arr)
				view.SetSource(GraphData)
				view.SetSize(400,400)
			elif len(arr.shape)==2:
				view=Py4datImageView(None)
				#imageData=Image(arr)
				#view.SetSource(imageData)
				#view.SetSize(arr.shape[0],arr.shape[1])
				
				blissData=SciDXPData()
				blissData.SetSource(inputDataSetNode)
				print blissData.GetSourceInfo()["KeyList"]
				blissData.LoadSource()
				#key1=('Image1')
				#print 'blissdata:', type(blissData.Pages[0].Array)
				#if type(blissData.Pages[0].Array)==types.InstanceType: blissData.Pages[0].Array=blissData.Pages[0].Array.getData()
				selection=DataSelection.RectSelection(blissData)
				maskedImage=Py4datMaskFilter(selection)
				colormap=ColormapFilter("colormap",maskedImage)
				#colormap=ColormapFilter("Image",DataSelection.RectSelection(blissData,page=blissData.GetPageIndex(key=key1)))
				view.SetSource(colormap)
				
				#node=DefaultGroupNode('')
				#node.insertChild(inputDataSetNode)
				#data=DataWrapper.GroupNodeToData(node)
				#sel=DataSelection.RectSelection(data)
				#print (sel.GetOutput()['data'].shape)
				#view.SetSource(ColormapFilter(None,sel))
			view.Show()
			root.setMainWidget(view)
			root.exec_loop()
		#except:
			#print 'Exception in Py4datDisplay'
		
			
###################################################################################


class Py4datImageView(ExtendedImageView):
	def __init__(self, parent=None, pars={}, **kw):
		ExtendedImageView.__init__(self, parent, pars, **kw)
		
		if self.MenuPopup is not None:self.AddMenuSeparator()
		#print dir(self)
		self.AddMenuPopupItem("AzimInt",self.AzimInt)
		#self.AddMenuPopupItem("Select ROI",self.ROISelect) 
		self.RoiMenuItem=self.AddMenuPopupItem('Roi',self._SetRoi,'checkbutton')
		self.AddMenuPopupItem('Del Rois',self._DelAllRois)
		self.AddMenuPopupItem("I(Phi)",self.Integrate) 
		self.AddMenuPopupItem("I(q)",self.Iq) 
                self.AddMenuPopupItem("Add mask Rectangle",self.Mask)
		self.AddMenuPopupItem("Add mask Polygon",self.Polygon) 
		self.AddMenuPopupItem("Del Masks",self.DelMasks) 
		self.AddMenuPopupItem("Save as test.edf",self.Save)
		
		#roi attributes
		self.rois={}
		self.Mask=None
		self.activeRoi=None
		self.activeRoiHighlight=[]
		#self.popups['Roi']={}
		self.roiLimit_dnd=0 	# roi limit drag 'n' drop management mode
		
		#self.menufile=QPopupMenu(self)
		#print dir(self)
		#self.menuBar().insertItem('&file',self.menufile)

	def UpdateViews(self):
		if hasattr(self,'AzimIntView'): self.AzimInt()
		if hasattr(self,'AzimIntView') and hasattr(self.AzimIntView,'IphiView'): self.AzimIntView.Integrate()
		if hasattr(self,'AzimIntView') and hasattr(self.AzimIntView,'IqView'): self.AzimIntView.Iq()
          		

################## MASK ################################################
		
	def SetMask(self, val=None, rect=None):
        	self.Drawable.SetMask (val=val,rect=rect)
	
	def DelMasks(self):
		data=self.GetSource()[0].GetOutput()['data']
		self.GetSource()[0].GetSource().SetMask(Numeric.ones(data.shape,data.typecode()))
		self.Refresh()
		self.Mask=None
		self.UpdateViews()
	
	def Mask(self):
		if (self.Source!=()):
			self.DisableModeRoi()
			data=self.Source[0].GetData()
			if data==None: return
			self.MaskSelect=ImageViewSelect.ViewSelectRect(data,self.EventMaskSelection)
			self.MaskSelect.ConnectView(self)		
			
	def EventMaskSelection(self,source):
		if (self.Source != ()) and (self.Source[0] != None):
			if type(self.Mask)==types.NoneType:
				self.Mask=ones(self.Source[0].GetData().Pages[0].Array.shape)
			data=self.GetSource()[0].GetOutput()['data']
          		if self.GetSource()[0]==None:
             			self.ClearMaskSelect()
              			return
          		self.MaskSelect.EraseSelection(self)
          		(p0,p1)=source.GetSelection()["BoundingRect"]
          		(x0,y0),(x1,y1)=self.Source[0].DataCoord2SelectionCoord(p0),self.Source[0].DataCoord2SelectionCoord(p1)
          		rect=(min(x0,x1),min(y0,y1),max(x0,x1),max(y0,y1))
          		print x0,y0,x1,y1
			x,y=x0,y0
			while x < x1:
				while y < y1:
					self.Mask[y,x]=0.
					#data[y,x]=0.
					y=y+1
				x,y=x+1,y0
			#print self.GetSource()[0].GetSource()
			self.GetSource()[0].GetSource().SetMask(self.Mask)
			self.Refresh()
			self.UpdateViews()
			self.ClearMaskSelect()

	def ClearMaskSelect(self):
        	if (self.MaskSelect is not None):
          		self.MaskSelect.Destroy()
          		self.MaskSelect=None
			

################## POLYGON ################################################
		
	def Polygon(self):
		if (self.Source!=()):
			self.DisableModeRoi()
			data=self.Source[0].GetData()
			if data==None: return
			if hasattr(self,"PolygonSelect") and self.PolygonSelect is not None:
				self.PolygonSelect.Destroy()
			self.PolygonSelect=Py4datImageViewSelect.ViewSelectPolygon(data,self.EventPolygonSelection)
			self.PolygonSelect.ConnectView(self)
			#from Binding import Pen
			#self.PolygonSelect.SetPen(Pen((255,0,0),2,"dotted"))
			
	def EventPolygonSelection(self,source):
		print 'Polygon selected' 
		if type(self.Mask)==types.NoneType:
				self.Mask=ones(self.Source[0].GetData().Pages[0].Array.shape)
		#print source.GetSelection()['Polygon']
		nbSites=len(source.GetSelection()['Polygon'])-1
		listx,listy=[],[]
		for position in source.GetSelection()['Polygon']:
			listx.append(position.PageCoord[0]),listy.append(position.PageCoord[1])
		#print listx,listy
		xmin,ymin,xmax,ymax=min(listx),min(listy),max(listx),max(listy)
		print 'xmin, ymin, xmax, ymax=',xmin, ymin, xmax, ymax
		x=xmin
		while x < xmax:	
			y=ymin
			while y < ymax:
				i=0
				#position='OUT'
				intersection=0
				#if i==0:
				while i < nbSites:
					try:
						(xi,yi)=(source.GetSelection()['Polygon'][i].PageCoord)
						if i<nbSites-1: (xinext,yinext)=(source.GetSelection()['Polygon'][i+1].PageCoord)
						elif i==nbSites-1:(xinext,yinext)=(source.GetSelection()['Polygon'][0].PageCoord)
						#try: (xinext,yinext)=source.GetSelection()['Polygon'][i+1].PageCoord
						#except: (xinext,yinext)=source.GetSelection()['Polygon'][-1].PageCoord
						#try: (xiend,yiend)=source.GetSelection()['Polygon'][i+2].PageCoord
						#except: (xiend,yiend)=source.GetSelection()['Polygon'][i+2-nbSites].PageCoord
						#if float((x-xi)*(yinext-yi)-(y-yi)*(xinext-xi))*float((xiend-xinext)*(yinext-yi)-(yiend-yinext)*(xinext-xi)) > 0.:
						a=(yinext-yi)*1./(xinext-xi)
						b=(yi*xinext-yinext*xi)*1./(xinext-xi)
						c=(y*1./x)
						xj=b/(c-a)
						yj=(c*b)/(c-a)
						if xj>min(xi,xinext) and xj<max(xi,xinext) and yj>min(yi,yinext) and yj<max(yi,yinext) and xj<x and yj<y:
							#print 'positive result',float((x-xi)*(yinext-yi)-(y-yi)*(xinext-xi))*float((xiend-xinext)*(yinext-yi)-(yiend-yinext)*(xinext-xi))
							#print 'intersection=',xj,yj
							intersection=intersection+1
							#position='IN'
						#else: 
							#print 'negative result'
							#position='OUT'
							#break
						#print i
						i=i+1
					except:
						i=i+1
						continue
				#if position=='IN':
				#	self.Source[0].GetData().Pages[0].Array[y,x]=0.
				#print 'intersection=',intersection
				if intersection % 2==0: pass #print 'intersection pair'
				else:
					self.Mask[y,x]=0.
					#self.Source[0].GetData().Pages[0].Array[y,x]=0.
					#print 'intersection impair'
				y=y+1
			x=x+1
		self.GetSource()[0].GetSource().SetMask(self.Mask)
		self.Refresh()
		self.UpdateViews()
		source.Disable()
		self.ClearPolygonSelect()
		
	def ClearPolygonSelect(self):
        	if (self.PolygonSelect is not None):
          		self.PolygonSelect.Destroy()
          		self.PolygonSelect=None

################## SELECT ROI ###############################################

	def _SetRoi(self):
		if DEBUG==1: print 'In _SetRoi...'
		newstate=not self.MenuPopup.IsItemChecked(self.RoiMenuItem)
		self.SetModeStateRoi(newstate)
		self.MenuPopup.CheckItem(self.RoiMenuItem,newstate)
		
	def _DelAllRois(self):
		for roi in self.GetRois(): 
			self.DelRoi(roi.name)
		#self.refresh()

	############################################
	###   SELECTION ON THE IMAGE CALLBACKS   ###
	############################################
	
	def EventRoiSelection(self,source):
		"""
		Virtual : Callback of a new roi selection : to be overidden for specific behavior
		"""
		if DEBUG : print "EventRoiSelection"
		#print self.Select.Selection["BoundingRect"][0]
		((xmin,y0),(xmax,y1))=self.Select.Selection["BoundingRect"][0].PageCoord,self.Select.Selection["BoundingRect"][1].PageCoord
		self.PutRoi(name='roi',Limitsx=[(xmin,xmax)],Limitsy=[(y0,y1)],pen=Pen((100,100,100),2,"solid"),brush=Brush((100,100,100),"fill_25"))
		nbRois=len(self.GetRois())
		#print self.GetRois()
		i=0
		if DEBUG:
			while i<nbRois:
				print self.GetRois()[i].name
				print self.GetRois()[i].Limitsx[0]
				i=i+1

	##########################################
	###  IMAGE ITEMS SELECTION CALLBACKS   ###
	##########################################
		
	def ClickOnRoiCB(self,roiName=None):
		"""
		Callback of a click in a roi event : to be overidden for specific behavior
		"""
		if DEBUG : print " ClickOnRoiCB ",roiName
		# if more than one roi, make it being the active one
		self.SetActiveRoi(roiName)

	##################################
	###   MOUSE EVENTS CALLBACKS   ###
	##################################
	
			
	def EventButtonPress(self,pos):
		pass
		# set active image near position
		#imageName=self.GetSource(pos.DataCoord)
		#if imageName is not None:
		#	self.ClickOnimageCB(imageName)

		#if self.opts['RoiSelection']: 
		# set active roi near position
		#enclosingRois=self.InsideRoi(pos.DataCoord)
		#if enclosingRois!=[]:
		#	self.ClickOnRoiCB(enclosingRois[0].name)

		# activate or not roi limit drag 'n' drop
		#overlappedRoiLimit=self.nearRoisLimit(pos.DataCoord)
		#if overlappedRoiLimit!=[]:
		#	self.roiLimit_dnd=1
	
	def EventButtonPressMotion(self,pos):
		#if self.opts['RoiSelection']: 
		# roi Limitsx drag 'n' drop
		if self.roiLimit_dnd:
			i=0
			while i<len(self.draggedRoiLimit):
				roi,limit=self.draggedRoiLimit[i]
				roi.MoveLimit(limit,pos.DataCoord[0])
				if roi==self.GetActiveRoi():
					# update active roi highlight box
					for obj in self.activeRoiHighlight:
						xmin,ymin,xmax,ymax=self.Drawable.GetObjectCoords(obj)
						#ymin,ymax=0,view.Source[0].GetData().Pages[0].Array.shape[1]
						if xmin==limit:
							xmin=pos.DataCoord[0]
							self.Drawable.SetObjectCoords(obj,xmin,ymin,xmax,ymax)
						elif xmax==limit:
							xmax=pos.DataCoord[0]
							self.Drawable.SetObjectCoords(obj,xmin,ymin,xmax,ymax)
				self.draggedRoiLimit[i]=(roi,pos.DataCoord[0])
				i+=1
	
	def EventButtonRelease(self,pos):
		#if self.opts['RoiSelection']: 
		# disable roi Limitsx drag 'n' drop if set
		if self.roiLimit_dnd:
			self.roiLimit_dnd=0
			self.draggedRoiLimit=overlappedRoiLimit
	

	################################
	###      ROI MANAGEMENT      ###
	################################
	
	def InsideRoi(self,pos):
		"""
		return the sequence of rois containing the image position 'pos'. If None, return an empty sequence
		"""
		ret=[]
		for roi in self.rois.keys():
			# in each roi 
			for min,max in self.rois[roi].Limitsx:
				# in each roi limit
					if pos[0]>=min and pos[0]<=max:
						ret.append(self.rois[roi])
		return ret

	
	
	def PutRoi(self,name='roi',Limitsx=[],Limitsy=[],pen=Pen((0,0,0),2,"solid"),brush=Brush((0,0,0),"fill_25")):
		"""
		Put a roi on the image with the specified parametres :
			-	name : the name given to this roi. If an already existant roi have the same name, it will be renamed with an non existing name using the style existing-name'_x'
				 		   where x is a integer.
			-	Limitsx : the image Limitsx defining this roi : it's a sequence of min,max tuples
			-	Limitsy : the image Limitsy defining this roi : it's a sequence of min,max tuples
			-	pen : the pen style used for drawing the roi border
			-	brush : the brush style used for filling the roi
		Once the roi has been added, it is set as the active one		   
		"""	
		if DEBUG: print 'In PutRoi...'
		if self.rois.has_key(name):
			# if a roi with a name of label exists : renamed the one to add
			i=0
			while self.rois.has_key(name+'_'+str(i)):
				i+=1
			name+='_'+str(i)
		
		# hide all other roi names
		for roi in self.rois.keys():
			self.rois[roi].HideName()
		
		# add the new roi parametres to the list
		#print 'ROI name=',name,'ROI Limitsx=',Limitsx
		self.rois[name]=Py4datImageViewRoi(self,name,Limitsx,Limitsy,pen,brush)
		
		# make the new roi become the active one
		self.SetActiveRoi(name)
			
	def DelRoi(self,name=''):
		"""
		Delete the roi with the given name
		"""
		if self.rois.has_key(name):
			# erases roi rectangles
			for obj in self.rois[name].drawnRect:
				self.Drawable.EraseObject(obj)
			# erases roi labels
			for obj in self.rois[name].drawnLab:
				self.Drawable.EraseObject(obj)
			# delete it in the rois list
			del self.rois[name]
			
			if self.GetActiveRoi().name == name:
				# if roi to delete is the active one : erases active roi border rectangles
				for obj in self.activeRoiHighlight:
					self.Drawable.EraseObject(obj)
					self.activeRoiHighlight.remove(obj)
			
	def ShowRoisNames(self):
		"""
		show all rois labels
		"""
		for roi in self.rois.keys():
			self.rois[roi].ShowName()
			
	def ShowRoiName(self,name=''):
		"""
		show the label of the roi called 'name' 
		"""
		if self.rois.has_key(name):
			self.rois[name].ShowName()
		
	def HideRoisNames(self):
		"""
		hide all rois labels
		"""
		for roi in self.rois.keys():
			self.rois[roi].HideName()
			
	def HideRoiName(self,name=''):
		"""
		hide the label of the roi called 'name' 
		"""
		if self.rois.has_key(name):
			self.rois[name].HideName()
		
	def SetActiveRoi(self,name=''):
		"""
		if existant, set the roi with a name of 'name' as the active one. Draws a red rectangle around it, and remove it on the old active one
		"""		
		if self.rois.has_key(name):
			self.activeRoi=self.rois[name]

			# if more than one roi : draw a red rectangle around the roi to view which one is the active one
			if len(self.rois)>1: 
				# erases old active roi border rectangles
				for obj in self.activeRoiHighlight:
					self.Drawable.EraseObject(obj)
					self.activeRoiHighlight.remove(obj)
				# create it on new active one
				ymin,ymax=0,self.Source[0].GetData().Pages[0].Array.shape[1]
				for xmin,xmax in self.activeRoi.Limitsx and ymin,ymax in self.activeRoi.Limitsy:
					# create the highlight rectangle
					self.activeRoiHighlight.append(self.Drawable.PutRectangle(xmin,ymin,xmax,ymax,pen=Pen((255,0,0),2,"solid")))

				# erases others roi lablels
				self.HideRoisNames()
			# show the label of the active roi
			self.ShowRoiName(name)
			
	def GetActiveRoi(self):
		"""
		return the active roi
		"""
		return self.activeRoi
		
	def GetRois(self):
		"""
		return a sequence containing all the displayed roi
		"""
		ret=[]
		for roi in self.rois.keys():
			ret.append(self.rois[roi])
		return ret
		
	# Roi mode
	def SetModeStateRoi(self,state):
		if state==0:
			self.DisableModeRoi()
		else:
			self.EnableModeRoi()
	
	def EnableModeRoi(self):
		# disable other selections
		if DEBUG: print 'In EnableModeRoi...'
		if self.ZoomSelect is not None:
			self.DisableModeZoom()

		if self.Select is None:
			self.MenuPopup.CheckItem(self.RoiMenuItem,1)
		
			self.activeMode='Roi'
			
			if (self.Source != ()):
				self._DestroySelect()
				data=self.Source[0].GetData()
				if data==None: return
				#print dir(ImageViewSelect)
				self.Select=ViewSelectHRect(data,self.EventRoiSelection)
				self.Select.ConnectView(self)
		
	def DisableModeRoi(self):
		if self.Select is not None:
			#self.MenuPopup.UnselectItem(3)
			self.MenuPopup.CheckItem(self.RoiMenuItem,0)
			
			self.activeMode=None
			self._DestroySelect()
			
	def _DestroySelect(self):
		if self.Select is not None:
			self.Select.Erase(self)
			self.Select.Destroy()
			self.Select=None
		
################## INTEGRATE  I(Phi)################################################
	
	def Integrate(self):
		if (self.Source!=()):
			if DEBUG: print 'In Integrate...'
			data=self.Source[0].GetOutput()
			if data==None: return
			#print 'Select 2 vertical lines to define ROI...'
			
			image=data['data']
			print 'number of ROIs:',len(self.GetRois())
			if len(self.GetRois())!=3:
				print 'You must select 3 ROIs before integrate !'
			else:
				Limitsx = [self.GetRois()[0].Limitsx[0],self.GetRois()[1].Limitsx[0],self.GetRois()[2].Limitsx[0]]
				Limitsy = [self.GetRois()[0].Limitsy[0],self.GetRois()[1].Limitsy[0],self.GetRois()[2].Limitsy[0]]
				Limitsx.sort()
				ROIx=Limitsx[1]
				ROIy=Limitsy[1]
				BKG1x=Limitsx[0]
				BKG1y=Limitsy[0]
				BKG2x=Limitsx[2]
				BKG2y=Limitsy[2]
				print 'BKG1,ROI,BKG2=',BKG1,ROI,BKG2
          			x1, x2 = ROIx[0],ROIx[1]
				x3, x4 = BKG1x[0],BKG1x[1]
				x5, x6 = BKG2x[0],BKG2x[1]
				y1, y2 = ROIy[0],ROIy[1]
				y3, y4 = BKG1y[0],BKG1y[1]
				y5, y6 = BKG2y[0],BKG2y[1]
          			#if (y1 >= 0) and (y1 <= ysize) and (y2 >= 0) and (y2 <= ysize):
	    			#x,ROI,BKG1,BKG2=0,[],[],[]
				#if type(self.Mask)!=types.NoneType:	print self.mask.shape
				#while x < image.shape[0]:
				#	y=y1
				#	while y<y2:
				#		if type(self.Mask)==types.NoneType or self.mask[x,y]==1:	
				#			ROI.append(image[x,y])
				#		y=y+1
				#	y=y3
				#	while y<y4:
				#		if type(self.Mask)==types.NoneType or self.mask[x,y]==1:
				#			BKG1.append(image[x,y])
				#		y=y+1
				#	y=y5
				#	while y<y6:
				#		if type(self.Mask)==types.NoneType or self.mask[x,y]==1:
				#			BKG2.append(image[x,y])
				#		y=y+1
				#	x=x+1
				print 'image=',image[0:2,0:2]
				ROI = Numeric.sum(image[int(y1):int(y2),int(x1):int(x2)],1)
            			BKG1 = Numeric.sum(image[int(y3):int(y4),int(x3):int(x4)],1)
          			BKG2 = Numeric.sum(image[int(y5):int(y6),int(x5):int(x6)],1)
        			if len(BKG1) == len(BKG2):
         				BKG = BKG1 + BKG2
        			else:
          				BKG = BKG1
        			print type(ROI),BKG
				integrated_arr = ROI - BKG
				print 'integration:',integrated_arr[0:5]
				#print type(integrated_arr.shape)
				
				if hasattr(self,'IphiView')==0: self.IphiView=Py4datGraphView(None)
				imageData=Graph(integrated_arr)
				self.IphiView.SetSource(imageData)
				self.IphiView.SetSize(400,400)
				self.IphiView.SetLabels("Integration","Phi","Intensity")
				self.IphiView.Show()
				#print dir(view)
			
				#dataSetNode=DefaultDataSetNode('',DefaultArray(integrated_arr))
				#Py4datimageView(dataSetNode)
			
				#self.IntegrateSelect=ImageViewSelect.ViewSelectVLine(data,self.EventIntegrateSelection)
				#self.IntegrateSelect.ConnectView(self)
			
	def EventIntegrateSelection(self,source):
		if (self.Source != ()) and (self.Source[0] != None):
          		data=self.Source[0].GetData()
          		if data==None:
             			self.ClearIntegrateSelect()
              			return
          		self.IntegrateSelect.EraseSelection(self)
			sel=source.GetDataSelection()
          		if source.GetType()=="HLine" or source.GetType()=="VLine" or source.GetType()=="Line":
                		print 'Line has been selected'
			#print sel.GetOutput()['data'][200:210]
			#(p0,p1)=source.GetSelection()["BoundingRect"]
          		#(x0,y0),(x1,y1)=self.Source[0].DataCoord2SelectionCoord(p0),self.Source[0].DataCoord2SelectionCoord(p1)
          		#rect=(min(x0,x1),min(y0,y1),max(x0,x1),max(y0,y1))
          		#print x0,y0,x1,y1
			#x,y=x0,y0
			#while x < x1:
			#	while y < y1:
			#		data.Pages[0].Array[y,x]=0.
			#		y=y+1
			#	x,y=x+1,y0
			#self.Refresh()
          		self.ClearIntegrateSelect()

	def ClearIntegrateSelect(self):
        	if (self.IntegrateSelect is not None):
          		self.IntegrateSelect.Destroy()
          		self.IntegrateSelect=None

################## I(q) ################################################
	
	def Iq(self):
		if (self.Source!=()):
			if DEBUG: print 'I funtion of q...'
			data=self.Source[0].GetOutput()
			if data==None: return
						
			image=data['data']
			outputGraph=[]
			for x in range(0,image.shape[1]):
          			outputGraph.append(Numeric.sum(image[:,x]))
			L=50000	# Distance echantillon-detecteur en um ?
			lo=1000	# Longeur d'onde en um ?
			px=100	# Pixel size in um
			py=100	# Pixel size in um
			i=0
			qGraph=[]
			xaxis=[]
			while i<len(outputGraph):
				if type(outputGraph[0])!=types.FloatType:	outputGraph[i]=float(outputGraph[i])
				#try:	qGraph.append(outputGraph[int(i*px*2*math.pi/L/lo)])
				#except: pass
				xaxis.append(i*px*2*math.pi/L/lo)
				i=i+1
			outputarr=array(outputGraph)	
					
			if hasattr(self,'IqView')==0: self.IqView=Py4datGraphView(None)
			imageData=Graph(outputarr,xdata=array(xaxis))
			self.IqView.SetSource(imageData)
			self.IqView.SetSize(400,400)
			self.IqView.SetLabels("Integration","q","Intensity")
			self.IqView.Show()
			
	def EventIqSelection(self,source):
		if (self.Source != ()) and (self.Source[0] != None):
          		data=self.Source[0].GetData()
          		if data==None:
             			self.ClearIqSelect()
              			return
          		self.IqSelect.EraseSelection(self)
			sel=source.GetDataSelection()
          		if source.GetType()=="HLine" or source.GetType()=="VLine" or source.GetType()=="Line":
                		print 'Line has been selected'
          		self.ClearIqSelect()

	def ClearIqSelect(self):
        	if (self.IqSelect is not None):
          		self.IqSelect.Destroy()
          		self.IqSelect=None

################## AZIM INT #################################################

	def AzimInt(self):
		if (self.Source!=()):
			if DEBUG: print 'In AzimInt...'
			#data=self.Source[0].GetData()
			data=self.Source[0].GetOutput()
			if data==None: return
			arr=data['data']
			print type(arr),arr.shape
			#arr=data.Pages[0].Array
			
			saxs.set_pixelsize(0.01, 0.01)
      			saxs.set_offset(0.0, 0.0)
      			saxs.set_center(arr.shape[0]/2., arr.shape[1]/2.)
			
			image = arr.astype(Numeric.Float32)
			print 'source=',image[0:2,0:2]
      			out_image =array((image))
      			saxs.azim_int(image, out_image, 0, -1, 0, 359, 1)
      			out_image = out_image[0:360, 0:1200]
      			print 'azimint=',out_image[0:2,0:2]
			#image=out_image.tostring()
			
			outputImage=Image(out_image)
			#self.Destroy()
			
			#view=Py4datImageView(None)
			if hasattr(self,'AzimIntView')==0: self.AzimIntView=Py4datImageView(None)
			#print self.AzimIntView.parent
			imageData=Image(out_image)
			self.AzimIntView.SetSource(imageData)
			self.AzimIntView.SetSize(out_image.shape[0],out_image.shape[1])
			#view.label.SetText('AzimInt')
			#view.label.Show()
			self.AzimIntView.Show()
			#print dir(view)
			
			#if hasattr(self.AzimIntView,'IphiView'): self.AzimIntView.Integrate()
			
			#self.SetSource(outputImage)
			#self.SetSize(out_image.shape[0],out_image.shape[1])
			#self.Show()
			#print self.Source[0].GetData().Pages[0].Array.shape
			#self.Update()
			#self.Refresh()
						
################## SELECTION ################################################

	def EventSelection(self,source):
		if (self.Source != ()) and (self.Source[0] != None):
          		sel=source.GetDataSelection()
          		if sel==None:return
        		if source.GetType()=="Rect":
            			if sel.Size is not None and sel.Position is not None:
                			xdata=Numeric.arrayrange(sel.Position[0],sel.Position[0]+sel.Size[0]+1)
                			ydata=Numeric.arrayrange(sel.Position[1],sel.Position[1]+sel.Size[1]+1)
            			else: xdata=ydata=None               
            
        		else:
            			if source.GetType()=="HLine" or source.GetType()=="VLine" or source.GetType()=="Line":
                			print 'Line has been selected'
					try: print sel.GetOutput()['data'][0:10]
					except: pass
					#dataSetNode=DefaultDataSetNode('',DefaultArray(sel.GetOutput()['data'][200:210]))
					#Py4datGraphView(dataSetNode)
				
##################### SAVE ##########################################		
			
	def Save(self):
		if (self.Source!=()):
			arr=self.Source[0].GetData().Pages[0].Array
			dataSetNode=DefaultDataSetNode('',DefaultArray(arr))
			#print self.GetRois()
			if self.GetRois() != ():
				nbRois=len(self.GetRois())
				Limitsx=[]
				Limitsy=[]
				i=0
				while i<nbRois:
					Limitsx.append(self.GetRois()[i].Limitsx[0])
					Limitsy.append(self.GetRois()[i].Limitsy[0])
					i=i+1
				Limitsx.sort()
				i=0
				while i<len(Limitsx):
					ROIx=[]
					ROIy=[]
					for limit in Limitsx[i]: ROIx.append(limit)
					for limit in Limitsy[i]: ROIy.append(limit)
					#print type(limit),'ROI'+str(i)+'=',ROI
					#print type(ROI),'DEBUG'
					dataSetNode.setAttribute('ROIx'+str(i),DefaultArray(ROIx))
					dataSetNode.setAttribute('ROIy'+str(i),DefaultArray(ROIy))
					i=i+1
			#print (dataSetNode.getAttribute('ROI1')._data.tolist()[0])
			WriteEdfFile('test.edf',dataSetNode)

#######################################################################

class Py4datImageViewRoi:
	"""
	Class representing a roi made on a image
	"""
	def __init__(self,view,name='roi',Limitsx=[],Limitsy=[],pen=Pen((0,0,0),2,"solid"),brush=Brush((0,0,0),"fill_25")):
		"""
		Constructor
			-	view : view where the roi must be drawn
			-	Limitsx : the image Limitsx defining this roi : it's a sequence of min,max tuples
			-	Limitsy : the image Limitsy defining this roi : it's a sequence of min,max tuples
			-	pen : the pen style used for drawing the roi border
			-	brush : the brush style used for filling the roi		   
		"""
		if DEBUG==1: print 'In Py4datImageViewRoi...'
		self.view=view
		
		self.name=name
		self.Limitsx=Limitsx
		self.Limitsy=Limitsy
		self.pen=pen
		self.brush=brush
		# drawn on view objects references
		# rectangles
		self.drawnRect=[]
		# labels
		self.drawnLab=[]
		
		# draw it on the view
		ymin,ymax=0,self.view.Source[0].GetData().Pages[0].Array.shape[1]
		#print 'ymin,ymax=',ymin,ymax
		labelYOffset=(ymax-ymin)/15
		
		#xmin=100
		#self.Limitsx=[(xmin,xmin+20)]
		i=0
		while i < len(self.Limitsx):
			xmin,xmax=self.Limitsx[i]
			ymin,ymax=self.Limitsy[i]
			# create the rectangle
			self.drawnRect.append(self.view.Drawable.PutRectangle(xmin,ymin,xmax,ymax,pen=self.pen,brush=self.brush))
			# create the roi label
			#self.drawnLab.append(self.view.Drawable.PutText(xmin+int((xmax-xmin)/2),ymax-labelYOffset,self.name))
			i=i+1		
		
	##################################
	###  CHANGE ATTRIBUTES VALUES  ###
	##################################
	
	def SetLimitsx(self,newLimitsx=[]):
		"""
		set new Limitsx for tyhis roi. Format : newLimitsx = [(roi1min,roi1max),(roi2min,roi2max)]
		"""
		oldLimitsxNbr,newLimitsxNbr=len(self.Limitsx),len(newLimitsx)
		ymin,ymax=0,self.view.Source[0].GetData().Pages[0].Array.shape[1]
		labelYOffset=(ymax-ymin)/15
		for i in range(min(oldLimitsxNbr,newLimitsxNbr)):
			(oldMin,oldMax),(newMin,newMax)=self.Limitsx[i],newLimitsx[i]
			if oldMin!=newMin or oldMax!=newMax:
				# update Limitsx attribute
				self.Limitsx[i]=(newMin,newMax)
				# update imageical items
				self.view.Drawable.SetObjectCoords(self.drawnRect[i],newMin,ymin,newMax,ymax)
				if self.drawnLab!=[]:
					self.view.Drawable.SetObjectCoords(self.drawnLab[i],newMin+int((newMax-newMin)/2),ymax-labelYOffset)
		for i in range(newLimitsxNbr,oldLimitsxNbr):
			# delete needless old Limitsx 
			del self.Limitsx[i]
			# update imageical items
			self.view.Drawable.EraseObject(self.drawnRect[i])
			del self.drawnRect[i]
			if self.drawnLab!=[]:
				self.view.Drawable.EraseObject(self.drawnLab[i])
				del self.drawnLab[i]
		for i in range(oldLimitsxNbr,newLimitsxNbr):
			# put new rectangles
			(newMin,newMax)=newLimitsx[i]
			# update Limitsx attribute
			self.Limitsx.append((newMin,newMax))
			# update imageical items
			self.drawnRect.append(self.view.Drawable.PutRectangle(newMin,ymin,newMax,ymax,pen=self.pen,brush=self.brush))
			#if self.drawnLab!=[]:
			#	self.drawnLab.append(self.view.Drawable.PutText(newMin+int((newMax-newMin)/2),ymax-labelYOffset,self.name))
			
	def MoveLimit(self,oldLimit,newLimit):
		"""
		changes the old limit for new one and redraw
		"""
		# search for the limit to be changed
		i=0
		while i<len(self.Limitsx) and (self.Limitsx[i][0]!=oldLimit and self.Limitsx[i][1]!=oldLimit):
			i+=1
		if i<len(self.Limitsx):
			#ymin,ymax=0,self.view.Source[0].GetData().Pages[0].Array.shape[1]
			ymin,ymax=self.Limitsy[i]
			labelYOffset=(ymax-ymin)/15
			xmin,xmax=self.Limitsx[i]
			if xmin==oldLimit:
				self.Limitsx[i]=(newLimit,xmax)
				self.view.Drawable.SetObjectCoords(self.drawnRect[i],newLimit,ymin,xmax,ymax)
				if self.drawnLab!=[]:
					self.view.Drawable.SetObjectCoords(self.drawnLab[i],newLimit+int((xmax-newLimit)/2),ymax-labelYOffset)
				#self.view.Drawable.marker_configure(self.drawnLab[i], coords=(newLimit+int((xmax-newLimit)/2),ymax-labelYOffset))
			else:
				self.Limitsx[i]=(xmin,newLimit)
				self.view.Drawable.SetObjectCoords(self.drawnRect[i],xmin,ymin,newLimit,ymax)
				if self.drawnLab!=[]:
					self.view.Drawable.SetObjectCoords(self.drawnLab[i],xmin+int((newLimit-xmin)/2),ymax-labelYOffset)
				#self.view.Drawable.marker_configure(self.drawnLab[i], coords=(xmin+int((newLimit-xmin)/2),ymax-labelYOffset))
	
	def Redraw(self):
		"""
		redraw the roi to fit to new image size
		"""
		# draw it on the view
		ymin,ymax=0,self.view.Source[0].GetData().Pages[0].Array.shape[1]
		labelYOffset=(ymax-ymin)/15
		for xmin,xmax in self.Limitsx and ymin,ymax in self.Limitsy :
			for rect in self.drawnRect:
				# update the rectangles
				self.view.Drawable.SetObjectCoords(rect,xmin,ymin,xmax,ymax)
			for lab in self.drawnLab:
				# update the roi labels
				self.view.Drawable.SetObjectCoords(lab,xmin+int((xmax-xmin)/2),ymax-labelYOffset)
	
	def SetName(self,name):
		"""
		change the name attribute, and redraw it on the image
		"""
		self.name=name
		for label in self.drawnLab:
			self.view.Drawable.UpdateObject(label,textOptsDic={'text':name})
	
	def SetPenValues(self,style=None,width=None,color=None):
		"""
		change pen values and redraw it
		"""
		changed=0
		if style is not None and self.pen.style!=style:
			self.pen.style=style
			changed=1
		if width is not None and self.pen.width!=width:
			self.pen.width=width
			changed=1
		if color is not None and self.pen.color!=color:
			self.pen.color=color
			changed=1
			
		if changed:
			# redraw
			for rect in self.drawnRect:				
				self.view.Drawable.UpdateObject(rect,self.pen,self.brush)

	def SetBrushValues(self,fill=None,color=None):
		"""
		change brush values and redraw it
		"""
		changed=0
		if fill is not None and self.brush.style!=fill:
			self.brush.style=fill
			changed=1
		if color is not None and self.brush.color!=color:
			self.brush.color=color
			changed=1
			
		if changed:
			# redraw
			for rect in self.drawnRect:
				self.view.Drawable.UpdateObject(rect,self.pen,self.brush)
	
	def ShowName(self):
		"""
		show the roi name in in all rectangle
		"""
		if self.drawnLab==[]:
			# if no label drawn : draw it on the view
			ymin,ymax=0,self.view.Source[0].GetData().Pages[0].Array.shape[1]
			labelYOffset=(ymax-ymin)/15
			#for xmin,xmax in self.Limitsx:
				# create the roi label
				#print dir(self.view.Drawable)
				#self.drawnLab.append(self.view.Drawable.PutText(xmin+int((xmax-xmin)/2),ymax-labelYOffset,self.name))
	
	def HideName(self):
		"""
		hide the roi name labels
		"""
		for lab in self.drawnLab:
			self.view.Drawable.EraseObject(lab)
		self.drawnLab=[]
		
########################################################################

class ViewSelectHRect(ImageViewSelect.ImageViewSelect):
  """
  Implemets a rectangle selection
  """
  def PressMotion(self,pos):
      """
      Virtual: See ViewSelect
      """
      mouse_position=pos.DataCoord
      for view in self.ViewList.keys():   
        self.DrawTemp(view,mouse_position)	


  def Press(self,pos):
      """
      Virtual: See ViewSelect
      """
      self.Erase("ALL")
      self.Selection={}
      self.Begin=pos.DataCoord


  def Release(self,pos):
      """
      Virtual: See ViewSelect
      """
      if hasattr(self,"Begin")==0: return
      if pos.DataCoord.PageCoord[0]>=self.Begin.PageCoord[0]:
        end=pos.DataCoord
      else:
        end=self.Begin
        self.Begin=pos.DataCoord
      self.SetSelectionPos((self.Begin,end ))


  def DrawSelection(self,view):
    """
    Virtual: See ViewSelectDefault
    """
    if "BoundingRect" not in self.Selection.keys(): return
    ((x0,y0),(x1,y1))=self.Selection["BoundingRect"]
    (ymin,ymax)= 0,view.Source[0].GetData().Pages[0].Array.shape[1]    
    self.EraseTemp(view)
    if "SelectDraw" not in self.ViewList[view].keys():
        #self.ViewList[view]["SelectDraw"]=view.Drawable.PutRectangle(x0, ymin,x1, ymax,self.Pen,self.Brush)
	self.ViewList[view]["SelectDraw"]=view.Drawable.PutRectangle(x0, y0,x1, y1,self.Pen,self.Brush)
    else:
        #view.Drawable.SetObjectCoords(self.ViewList[view]["SelectDraw"],x0, ymin, x1, ymax)
	view.Drawable.SetObjectCoords(self.ViewList[view]["SelectDraw"],x0, y0, x1, y1)


  def DrawTemp(self,view,mouse_position):
    """
    Virtual: See ViewSelectDefault
    """
    if hasattr(self,"Begin")==0: return
    start=self.Begin
    end=mouse_position    
    ymin,ymax= 0,view.Source[0].GetData().Pages[0].Array.shape[1]

    if "TempDraw" not in self.ViewList[view].keys():
        #self.ViewList[view]["TempDraw"]=view.Drawable.PutRectangle(start.PageCoord[0], ymin, end.PageCoord[0], ymax,self.Pen,self.Brush)
	self.ViewList[view]["TempDraw"]=view.Drawable.PutRectangle(start.PageCoord[0], start.PageCoord[1], end.PageCoord[0], end.PageCoord[1],self.Pen,self.Brush)
    else:
        #view.Drawable.SetObjectCoords(self.ViewList[view]["TempDraw"], start.PageCoord[0], ymin, end.PageCoord[0], ymax)
	view.Drawable.SetObjectCoords(self.ViewList[view]["TempDraw"], start.PageCoord[0], start.PageCoord[1], end.PageCoord[0], end.PageCoord[1])


  def GetType(self):
      """
      Virtual: See ViewSelect
      """
      return "HRect"

########################################################################

def testPy4datDisplay():
	file='data/circle.edf'
	#file='IPhi0.edf'
	node = ReadEdfFile.ReadEdfFileGroupNode(file)
	dataSetNode = node.getChild('Image1')
		
	#file='data/ll.spec'
	#node = ReadSpecFile.ReadSpecFileGroupNode(file)
	#scan = node.getChild("scan69")
	#dataSetNode = scan.getChild("Detector")
	
	print file,'/',dataSetNode.getName()
	Py4datDisplay(dataSetNode)


if __name__=='__main__':

	testPy4datDisplay()


