#!/usr/bin/env python
"""
    PyDis
    Python Generic Image Visualization Tool
"""


from PyDisWindow import PyDisWindow,MDIApp,__version__,__author__
import qt
import sys

                  
if __name__ == "__main__":

    def Help():
        print ""
        print "Py4dat - version ",__version__
        print "Contact:  ",__author__        
        print "Usage: Py4dat [-opt1 <par1>] [-opt2 <par2>] ..."
        print ""
        print "Options:"
        print "-f <filename>  File to be open on startup window"
        print "-e <format>    File format"
        print "               If omited uses extension of filename>: edf,jpg,png,bmp,..."
        print "-s <specname>  Spec to be open on startup window (requires -a option)"
        print "-a <arrayname> If -s used, indicates the name of the array to be open"
        print "-M             Starts PyDis maximized"
        print "-m             Opens startup window (if exists) maximized"
        print "-d <dir name>  Sets work directory"
        print "-r             If set, windows are repaint while resizing"
        print "-S <style>     Sets application style (Windows,Motif,MotifPlus,CDE,SGI,Platinum)"
        print "               If omited uses qt's default"        
        print "-F <font> <size> <weight> <italic>    Sets application font"
        print "               If omited uses qt's default"        
        print "               <font>: helvetica, times, ..."
        print "               <size>: font size, default=12"
        print "               <weight>: 0 to 100. Normal=50, Bold=100"
        print "               <italic>: 0 or 1"
        print "-p <plugin>    Sets plugin file or directory to read plugins from"
        print "               If directory, assumes all files inside are plugins"
        print "               If file, it must be inside PyDis directory or in Python path."
        print ""

        sys.exit(1)
##     if(1) :   
    try:
        #Gets command line options
        font=None
        filename=type=specname=specname=fmt=style=path=""
        Max=max=0
        plugin_list=[]
        for i in range(1,len(sys.argv)):
            if sys.argv[i]=="-f":   filename=sys.argv[i+1]
            elif sys.argv[i]=="-e": type=sys.argv[i+1]
            elif sys.argv[i]=="-s": specname=sys.argv[i+1]
            elif sys.argv[i]=="-a": arrayname=sys.argv[i+1]
            elif sys.argv[i]=="-S": style=sys.argv[i+1]
            elif sys.argv[i]=="-d": path=sys.argv[i+1]
            elif sys.argv[i]=="-M": Max=1
            elif sys.argv[i]=="-m": max=1
            elif sys.argv[i]=="-F": font=(sys.argv[i+1],int(sys.argv[i+2]),int(sys.argv[i+3]),int(sys.argv[i+4]))
            elif sys.argv[i]=="-p": plugin_list.append(sys.argv[i+1])
            elif sys.argv[i]=="-h": Help()
            
        
        #QApp init
        qt.QApplication.setColorSpec(qt.QApplication.CustomColor)
        if "-r" in sys.argv: app = qt.QApplication(sys.argv)    
        else: app = MDIApp(sys.argv)
        if font is not None: app.setFont( qt.QFont(font[0],font[1],font[2],font[3]))
        if style != "":
            style_classes={"Windows":qt.QWindowsStyle,"MotifPlus":qt.QMotifPlusStyle,"Motif":qt.QMotifStyle,"Motif":qt.QMotifStyle,"CDE":qt.QCDEStyle,"SGI":qt.QSGIStyle,"Platinum":qt.QPlatinumStyle}
            if style in style_classes.keys():
                newstyle=style_classes[style]()
                app.setStyle(newstyle)            

        #PyDisWindow init
        mw = PyDisWindow(None,None, qt.Qt.WDestructiveClose,plugin_list=plugin_list)
        mw.setCaption('Py4dat')
        app.setMainWidget (mw)
        if path != "": mw.setCurPath(path)
        if Max:mw.showMaximized()
        else:  mw.show()
        if filename != "":
            if type=="": type=filename[-3:]
            mw.loadFile(filename,type)
        elif specname !="" and arrayname!="":
            mw.loadSpec(specname,arrayname)
        if max:mw.mdi.activeWindow().showMaximized()

    except:
        print "CUCU"
        import traceback
        traceback.print_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)
        Help()
    app.exec_loop()

    
    
        
        
