"""
    AzimParametersDialog.py
    
"""
from qt import *
from PyDVT.Binding import *

__version__=  '1.0.0'
__date__='02/10/2002'
__lastUpdate__='10/01/03'
__author__ =  'Anne-Cecile Gendrin (gendrin@esrf.fr)'


class AzimParametersDialog(QMainWindow):
	"""
	AzimParametersDialog is a QMainWindow where the user can imput manually 
	the different image parameters:
	Pixel Size X (um)
	Pixel Size Y (um)
	Offset X (pixels)
	Offset Y (pixels)
	Center X (pixels)
	Center Y (pixels)
	Sample/Detector Distance (mm)
	Wavelength (Angstroms) or Energy (keV)
	"""
	def __init__(self, parent,initial_parameters):
        	QMainWindow.__init__(self,parent,"Azim Parameters Editor",0)  

		self.dlg=Dialog(self,"Image Parameters",1,0)
        	box=QVBox( self.dlg )
		self.pixelsizeX=initial_parameters['pixelsizeX']
		self.offsetX=initial_parameters['offsetX']
		self.centerX=initial_parameters['centerX']
		self.pixelsizeY=initial_parameters['pixelsizeY']
		self.offsetY=initial_parameters['offsetY']
		self.centerY=initial_parameters['centerY']
		self.distance=initial_parameters['distance']
		self.wavelength=initial_parameters['wavelength']
		self.energy=12.4/self.wavelength
		
        	box1 = QHBox( box )
        	box2 = QHBox( box )
        	box3 = QHBox( box )
        	box4 = QHBox( box )
		box5 = QHBox( box )
        	box6 = QHBox( box )
        	box7 = QHBox( box )
        	box8 = QHBox( box )
        	box9 = QHBox( box )
        
        	lab1=QLabel(box1)
		lab1.setFixedWidth(180)
        	ed1=QLineEdit(box1)
		ed1.setFixedWidth(100)
        	lab2=QLabel(box2)
		lab2.setFixedWidth(180)
        	ed2=QLineEdit(box2)
		ed2.setFixedWidth(100)
        	lab3=QLabel(box3)
		lab3.setFixedWidth(180)
        	ed3=QLineEdit(box3) 
		ed3.setFixedWidth(100)  
		lab4=QLabel(box4)
		lab4.setFixedWidth(180)
        	ed4=QLineEdit(box4)
		ed4.setFixedWidth(100)
        	lab5=QLabel(box5)
		lab5.setFixedWidth(180)
        	ed5=QLineEdit(box5)
		ed5.setFixedWidth(100)
        	lab6=QLabel(box6)
		lab6.setFixedWidth(180)
        	ed6=QLineEdit(box6)
		ed6.setFixedWidth(100)
        	lab7=QLabel(box7)
		lab7.setFixedWidth(180)
        	self.ed7=QLineEdit(box7) 
		self.ed7.setFixedWidth(100) 
		
		buttonGroup=QVButtonGroup(box8)
		buttonGroup.setExclusive(1)
		self.radioButton1=QRadioButton("Wavelength (Angstroms)",buttonGroup)
		self.radioButton1.setFixedWidth(170)
		self.radioButton1.setChecked(1)
		self.radioButton2=QRadioButton("Energy (keV)",buttonGroup)
		self.radioButton2.setFixedWidth(170)
		
		box8a= QVBox( box8 )
        	self.ed8a=QLineEdit(box8a)
		self.ed8a.setFixedWidth(100)
        	self.ed8a.setText(QString(str(self.wavelength)))
        	self.ed8b=QLineEdit(box8a)
		self.ed8b.setFixedWidth(100)
        	self.ed8b.setText(QString(str(self.energy)))
		self.ed8b.setReadOnly(1)
		     
        	lab1.setText("Pixel Size X (um)")
        	ed1.setText(QString(str(self.pixelsizeX)))
        	lab2.setText("Pixel Size Y (um)")
        	ed2.setText(QString(str(self.pixelsizeY)))
        	lab3.setText("Offset X (pixels)")
        	ed3.setText(QString(str(self.offsetX)))
		lab4.setText("Offset Y (pixels)")
        	ed4.setText(QString(str(self.offsetY)))
        	lab5.setText("Center X (pixels)")
        	ed5.setText(QString(str(self.centerX)))
        	lab6.setText("Center Y (pixels)")
        	ed6.setText(QString(str(self.centerY)))
        	lab7.setText("Sample/Detector Distance (mm)")
        	self.ed7.setText(QString(str(self.distance)))
        	OKButton=QPushButton(box9)
		OKButton.setFixedWidth(80)
        	OKButton.setText("OK")
		CancelButton=QPushButton(box9)
		CancelButton.setFixedWidth(80)
        	CancelButton.setText("Cancel")
        
		self.connect(OKButton,SIGNAL("pressed()"),self.dlg.accept)
		self.connect(CancelButton,SIGNAL("clicked()"),self.dlg.reject)
		self.connect(self.radioButton1, SIGNAL("toggled(bool)"), self.Update )
		self.connect(self.ed8a, SIGNAL("returnPressed()"), self.energyUpdate)
		self.connect(self.ed8b, SIGNAL("returnPressed()"), self.wavelengthUpdate )
        	box.resize( 300, 260 )
		
		if self.dlg.exec_loop():
            		try:
                		self.pixelsizeX=float(str(ed1.text()))
                		self.offsetX=float(str(ed3.text()))
                		self.centerX=float(str(ed5.text()))
				self.pixelsizeY=float(str(ed2.text()))
                		self.offsetY=float(str(ed4.text()))
                		self.centerY=float(str(ed6.text()))
                		self.distance=float(str(self.ed7.text()))
				if self.radioButton1.isChecked(): self.wavelength=float(str(self.ed8a.text()))
				elif self.radioButton2.isChecked(): self.energy=float(str(self.ed8b.text()))
            		except: pass
	
	def Update(self):
		if self.radioButton1.isChecked(): 
			self.ed8a.setReadOnly(0)
			self.ed8b.setReadOnly(1)
		elif self.radioButton2.isChecked(): 
			self.ed8a.setReadOnly(1)
			self.ed8b.setReadOnly(0)	
		
	def wavelengthUpdate(self):
		self.energy=float(str(self.ed8b.text()))
		self.ed8a.setText(QString(str(12.4/self.energy)))
	
	def energyUpdate(self):
		self.wavelength=float(str(self.ed8a.text()))
		self.ed8b.setText(QString(str(12.4/self.wavelength)))

#####################################################################

if __name__ == "__main__": 
    app = QApplication(sys.argv)
    app.connect(app,SIGNAL('lastWindowClosed()'),app,SLOT('quit()'))
    win=AzimParametersDialog(None,{'pixelsizeX':.01,'pixelsizeY':.01,'offsetX':0,'offsetY':0,'centerX':256,'centerY':256,'wavelength':1000,'distance':50000})
    app.setMainWidget (win)
    app.exec_loop()

