import Numeric


def reduce_image(image, newxsize, newysize):
  oldysize,oldxsize = image.shape
  if (oldxsize <= newxsize) or (oldysize <= newysize):
    print "ERROR! reduce_image can only reduce images!"
    raise "ReduceError"
  # New reduced image
  newimage = Numeric.zeros((newysize,newxsize),image.typecode())
  xo = 0.0
  yo = 0.0
  ratiox = oldxsize*1.0/newxsize
  ratioy = oldysize*1.0/newysize
  #pretabulate horizontal pixel positions
  xinittab = Numeric.zeros((newxsize))
  for x in range(newxsize):
    xin = int(xo)
    if (xin>=0) and (xin<oldxsize):
      xinittab[x] = xin
    xo += ratiox
  # Do the reduction
  for y in range(newysize):
    yi = int(yo)
    if (yi>=0) and (yi<oldysize):
      yin = image[yi,:]
      newimage[y,:] = Numeric.take(yin,xinittab)
    yo += ratioy
  # Ready!
  return newimage


def ReduceArray(arr):    
    a1=Numeric.take(arr, range(0,arr.shape[0],2))
    a1=Numeric.take(a1, range(0,arr.shape[1],2),1)

    a2=Numeric.take(arr, range(0,arr.shape[0],2))
    a2=Numeric.take(a2, range(1,arr.shape[1],2),1)

    a3=Numeric.take(arr, range(0,arr.shape[0],2))
    a3=Numeric.take(a3, range(1,arr.shape[1],2),1)

    a4=Numeric.take(arr, range(1,arr.shape[0],2))
    a4=Numeric.take(a4, range(1,arr.shape[1],2),1)
    return a1+a2+a3+a4
    
if __name__ == "__main__":
    a=Numeric.reshape(Numeric.arange(16),(4,4))
    print a
    print ReduceArray(a)
    print reduce_image(a,2,2)